/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.lwAWT;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import oracle.ewt.graphics.GraphicUtils;
import oracle.ewt.lwAWT.LWComponent;

public class LWLabel
extends LWComponent {
    public static final int LEFT = 0;
    public static final int CENTER = 1;
    public static final int RIGHT = 2;
    private String _text;
    private int _alignment;
    private static final String _sBaseName = "lwlabel";
    private static int _sNameCounter;

    public LWLabel() {
        this("", 0);
    }

    public LWLabel(String string) {
        this(string, 0);
    }

    public LWLabel(String string, int n) {
        this.setName(_sBaseName + _sNameCounter++);
        this._text = string;
        if (n < 0 || n > 2) {
            throw new IllegalArgumentException("improper alignment: " + n);
        }
        this._alignment = n;
    }

    public int getAlignment() {
        return this._alignment;
    }

    public synchronized void setAlignment(int n) {
        if (n < 0 || n > 2) {
            throw new IllegalArgumentException("improper alignment: " + n);
        }
        if (this._alignment != n) {
            this._alignment = n;
            this.repaint();
        }
    }

    public String getText() {
        return this._text;
    }

    public void setText(String string) {
        boolean bl = false;
        LWLabel lWLabel = this;
        synchronized (lWLabel) {
            if (!(string == this._text || this._text != null && this._text.equals(string))) {
                this._text = string;
                bl = true;
            }
        }
        if (bl) {
            this.invalidate();
            this.repaint();
        }
    }

    public void paintInterior(Graphics graphics) {
        int n;
        int n2;
        String string = this.getText();
        if (string == null) {
            return;
        }
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n3 = this.getAlignment();
        Dimension dimension = this.getSize();
        if (n3 != 0) {
            n2 = fontMetrics.stringWidth(string);
            n = dimension.width - n2;
            if (n3 == 1) {
                n /= 2;
            }
        } else {
            n = 0;
        }
        n2 = fontMetrics.getAscent();
        int n4 = n2 + (dimension.height - n2 - fontMetrics.getDescent()) / 2;
        if (this.isEnabled()) {
            graphics.drawString(string, n, n4);
            return;
        }
        GraphicUtils.drawDisabledString(graphics, string, n, n4);
    }

    public Dimension getPreferredSize() {
        Font font = this.getFont();
        if (font != null) {
            FontMetrics fontMetrics = this.getFontMetrics(font);
            String string = this._text;
            if (fontMetrics != null && string != null) {
                return new Dimension(fontMetrics.stringWidth(string), fontMetrics.getHeight());
            }
        }
        return new Dimension(0, 0);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public void setFont(Font font) {
        Font font2 = this.getFont();
        super.setFont(font);
        if (font2 != this.getFont()) {
            this.invalidate();
            this.repaint();
        }
    }

    protected String paramString() {
        String string = super.paramString();
        string = String.valueOf(string) + ",align=";
        switch (this.getAlignment()) {
            case 0: {
                string = String.valueOf(string) + "left";
                break;
            }
            case 1: {
                string = String.valueOf(string) + "center";
                break;
            }
            case 2: {
                string = String.valueOf(string) + "right";
                break;
            }
        }
        return String.valueOf(string) + ",text=" + this.getText();
    }
}

