/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.toolBar;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import oracle.ewt.EwtComponent;
import oracle.ewt.event.ListenerManager;
import oracle.ewt.toolBar.ToolBarActionListener;
import oracle.ewt.toolBar.ToolBarComponentWrapper;
import oracle.ewt.toolBar.ToolBarEvent;
import oracle.ewt.toolBar.ToolBarItem;
import oracle.ewt.toolBar.ToolBarMouseListener;

public class ToolBar
extends EwtComponent {
    private int _nitems;
    private ToolBarItem[] _items;
    private ToolBarItem _motionItem;
    private ToolBarItem _grabItem;
    private boolean _horizontal;
    private ListenerManager _mouseListeners;
    private ListenerManager _actionListeners;

    public ToolBar() {
        this(4);
    }

    public ToolBar(int n) {
        this._items = new ToolBarItem[n];
        this.setLayout(null);
        this._horizontal = true;
        this.enableEvents(48L);
    }

    public final void addItem(ToolBarItem toolBarItem) {
        this.addItem(toolBarItem, null);
    }

    public void addItem(ToolBarItem toolBarItem, ToolBarItem toolBarItem2) {
        if (toolBarItem.getParent() != null) {
            toolBarItem.getParent().removeItem(toolBarItem);
        }
        Component component = this;
        synchronized (component) {
            int n = toolBarItem2 != null ? this.getItemIndex(toolBarItem2) : -1;
            if (this._nitems == this._items.length) {
                ToolBarItem[] toolBarItemArray = new ToolBarItem[this._nitems * 2];
                System.arraycopy(this._items, 0, toolBarItemArray, 0, this._nitems);
                this._items = toolBarItemArray;
            }
            if (n == -1) {
                this._items[this._nitems] = toolBarItem;
            } else {
                System.arraycopy(this._items, n, this._items, n + 1, this._nitems - n);
                this._items[n] = toolBarItem;
            }
            ++this._nitems;
            toolBarItem.setParent(this);
        }
        component = toolBarItem.getComponent();
        if (component != null) {
            super.add(component, -1);
        }
        this.invalidateCanvas();
    }

    public void removeItem(ToolBarItem toolBarItem) {
        Component component = toolBarItem.getComponent();
        if (component != null) {
            super.remove(component);
        }
        ToolBar toolBar = this;
        synchronized (toolBar) {
            toolBarItem.setParent(null);
            int n = this.getItemIndex(toolBarItem);
            this._items[n] = null;
            --this._nitems;
            if (n < this._nitems) {
                System.arraycopy(this._items, n + 1, this._items, n, this._nitems - n);
            }
            this._items[this._nitems] = null;
        }
        if (toolBarItem.isVisible()) {
            this.invalidateCanvas();
        }
    }

    public void removeAll() {
        ToolBar toolBar = this;
        synchronized (toolBar) {
            int n = 0;
            while (n < this._nitems) {
                this._items[n].setParent(null);
                this._items[n] = null;
                ++n;
            }
            this._nitems = 0;
        }
        super.removeAll();
        this.invalidateCanvas();
    }

    public Component add(Component component) {
        return this.add(component, -1);
    }

    public Component add(Component component, int n) {
        ToolBarItem toolBarItem = n == -1 ? null : this._items[n];
        this.addItem(new ToolBarComponentWrapper(component), toolBarItem);
        return component;
    }

    public Component add(String string, Component component) {
        return this.add(component, -1);
    }

    public void remove(Component component) {
        this.removeItem(this.findComponent(component));
    }

    public ToolBarItem findComponent(Component component) {
        if (component == null) {
            throw new NullPointerException();
        }
        int n = 0;
        while (n < this._nitems) {
            if (this._items[n].getComponent() == component) {
                return this._items[n];
            }
            ++n;
        }
        return null;
    }

    protected void paintCanvasInterior(Graphics graphics) {
        int n = 0;
        while (n < this._nitems) {
            ToolBarItem toolBarItem = this._items[n];
            if (toolBarItem.isVisible()) {
                toolBarItem.paint(graphics);
            }
            ++n;
        }
    }

    public Dimension layoutCanvas() {
        Dimension dimension = this.getInnerSize();
        Point point = new Point(0, 0);
        boolean bl = this.isHorizontal();
        int n = bl ? dimension.height / 2 : dimension.width / 2;
        int n2 = 0;
        while (n2 < this._nitems) {
            ToolBarItem toolBarItem = this._items[n2];
            if (toolBarItem.isVisible()) {
                Dimension dimension2 = toolBarItem.getSize();
                Dimension dimension3 = toolBarItem.getPreferredSize();
                if (dimension2.width != dimension3.width || dimension2.height != dimension3.height) {
                    toolBarItem.setSize(dimension3.width, dimension3.height);
                    dimension2 = toolBarItem.getSize();
                }
                if (bl) {
                    point.y = n - dimension2.height / 2;
                    toolBarItem.setLocation(point.x, point.y);
                    point.x += dimension2.width;
                } else {
                    point.x = n - dimension2.width / 2;
                    toolBarItem.setLocation(point.x, point.y);
                    point.y += dimension2.height;
                }
            }
            ++n2;
        }
        if (bl) {
            return new Dimension(point.x, dimension.height);
        }
        return new Dimension(dimension.width, point.y);
    }

    public ToolBarItem getItemAt(int n, int n2) {
        Point point = this.convertOuterToCanvas(n, n2);
        int n3 = 0;
        while (n3 < this._nitems) {
            if (this._items[n3].inside(point.x, point.y)) {
                return this._items[n3];
            }
            ++n3;
        }
        return null;
    }

    public int getItemCount() {
        return this._nitems;
    }

    public synchronized ToolBarItem[] getItems() {
        ToolBarItem[] toolBarItemArray = new ToolBarItem[this._nitems];
        System.arraycopy(this._items, 0, toolBarItemArray, 0, this._nitems);
        return toolBarItemArray;
    }

    public ToolBarItem getItemById(int n) {
        if (n == -1) {
            throw new IllegalArgumentException();
        }
        int n2 = 0;
        while (n2 < this._nitems) {
            if (this._items[n2].getID() == n) {
                return this._items[n2];
            }
            ++n2;
        }
        return null;
    }

    public ToolBarItem getItem(int n) {
        return this._items[n];
    }

    public int getItemIndex(ToolBarItem toolBarItem) {
        int n = 0;
        while (n < this._nitems) {
            if (toolBarItem == this._items[n]) {
                return n;
            }
            ++n;
        }
        throw new IndexOutOfBoundsException();
    }

    public boolean isHorizontal() {
        return this._horizontal;
    }

    public void setHorizontal(boolean bl) {
        if (this._horizontal != bl) {
            this._horizontal = bl;
            this.invalidateCanvas();
        }
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public synchronized Dimension getMinimumSize() {
        int n = 0;
        int n2 = 0;
        Dimension dimension = null;
        boolean bl = this.isHorizontal();
        int n3 = 0;
        while (n3 < this._nitems) {
            dimension = this._items[n3].getPreferredSize();
            if (bl) {
                n2 = dimension.height > n2 ? dimension.height : n2;
                n += dimension.width;
            } else {
                n = dimension.width > n ? dimension.width : n;
                n2 += dimension.height;
            }
            ++n3;
        }
        Insets insets = this.getInsets();
        return new Dimension(n += insets.left + insets.right, n2 += insets.top + insets.bottom);
    }

    public void addToolBarActionListener(ToolBarActionListener toolBarActionListener) {
        if (this._actionListeners == null) {
            this._actionListeners = new ListenerManager();
        }
        this._actionListeners.addListener(toolBarActionListener);
    }

    public void removeToolBarActionListener(ToolBarActionListener toolBarActionListener) {
        this._actionListeners.removeListener(toolBarActionListener);
    }

    public void addToolBarMouseListener(ToolBarMouseListener toolBarMouseListener) {
        if (this._mouseListeners == null) {
            this._mouseListeners = new ListenerManager();
        }
        this._mouseListeners.addListener(toolBarMouseListener);
    }

    public void removeToolBarMouseListener(ToolBarMouseListener toolBarMouseListener) {
        this._mouseListeners.removeListener(toolBarMouseListener);
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        super.processMouseEvent(mouseEvent);
        if (mouseEvent.isConsumed()) {
            return;
        }
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        switch (mouseEvent.getID()) {
            case 504: {
                this.processMouseEntered(mouseEvent, n, n2);
                return;
            }
            case 505: {
                this.processMouseExited(mouseEvent, n, n2);
                return;
            }
            case 501: {
                this.processMousePressed(mouseEvent, n, n2);
                return;
            }
            case 502: {
                this.processMouseReleased(mouseEvent, n, n2);
                return;
            }
        }
    }

    protected void processMouseMotionEvent(MouseEvent mouseEvent) {
        super.processMouseMotionEvent(mouseEvent);
        if (mouseEvent.isConsumed()) {
            return;
        }
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        switch (mouseEvent.getID()) {
            case 503: {
                this.processMouseMoved(mouseEvent, n, n2);
                return;
            }
            case 506: {
                this.processMouseDragged(mouseEvent, n, n2);
                return;
            }
        }
    }

    protected boolean processMouseMoved(MouseEvent mouseEvent, int n, int n2) {
        ToolBarItem toolBarItem = this.getItemAt(n, n2);
        Point point = this.convertOuterToCanvas(n, n2);
        ToolBarItem toolBarItem2 = this._motionItem;
        if (toolBarItem != toolBarItem2) {
            if (toolBarItem2 != null) {
                toolBarItem2.mouseExited(mouseEvent, point.x, point.y);
                this.processEvent(new ToolBarEvent(this, 2002, toolBarItem2));
            }
            if (toolBarItem != null) {
                toolBarItem.mouseEntered(mouseEvent, point.x, point.y);
                this.processEvent(new ToolBarEvent(this, 2001, toolBarItem));
            }
        }
        if (this._motionItem != null) {
            this._motionItem.mouseMoved(mouseEvent, point.x, point.y);
        }
        return true;
    }

    protected boolean processMouseEntered(MouseEvent mouseEvent, int n, int n2) {
        ToolBarItem toolBarItem = this.getItemAt(n, n2);
        if (toolBarItem != null) {
            this.processEvent(new ToolBarEvent(this, 2001, toolBarItem));
            Point point = this.convertOuterToCanvas(n, n2);
            return toolBarItem.mouseEntered(mouseEvent, point.x, point.y);
        }
        return false;
    }

    protected boolean processMouseExited(MouseEvent mouseEvent, int n, int n2) {
        ToolBarItem toolBarItem = this._motionItem;
        if (toolBarItem != null) {
            this.processEvent(new ToolBarEvent(this, 2002, toolBarItem));
            Point point = this.convertOuterToCanvas(n, n2);
            return toolBarItem.mouseExited(mouseEvent, point.x, point.y);
        }
        return false;
    }

    protected boolean processMousePressed(MouseEvent mouseEvent, int n, int n2) {
        if (this._grabItem == null) {
            this._grabItem = this.getItemAt(n, n2);
            if (this._grabItem != null) {
                Point point = this.convertOuterToCanvas(n, n2);
                return this._grabItem.mousePressed(mouseEvent, point.x, point.y);
            }
        }
        return false;
    }

    public boolean processMouseDragged(MouseEvent mouseEvent, int n, int n2) {
        if (this._grabItem != null) {
            Point point = this.convertOuterToCanvas(n, n2);
            return this._grabItem.mouseDragged(mouseEvent, point.x, point.y);
        }
        return false;
    }

    protected boolean processMouseReleased(MouseEvent mouseEvent, int n, int n2) {
        ToolBarItem toolBarItem = this._grabItem;
        if (toolBarItem != null) {
            this._grabItem = null;
            Point point = this.convertOuterToCanvas(n, n2);
            return toolBarItem.mouseReleased(mouseEvent, point.x, point.y);
        }
        return false;
    }

    protected void processEventImpl(AWTEvent aWTEvent) {
        if (aWTEvent instanceof ToolBarEvent) {
            this.processToolBarEvent((ToolBarEvent)aWTEvent);
            return;
        }
        super.processEventImpl(aWTEvent);
    }

    protected void processToolBarEvent(ToolBarEvent toolBarEvent) {
        Enumeration enumeration;
        ListenerManager listenerManager;
        int n = toolBarEvent.getID();
        if (n == 2000) {
            listenerManager = this._actionListeners;
        } else {
            listenerManager = this._mouseListeners;
            ToolBarItem toolBarItem = this._motionItem = n == 2001 ? toolBarEvent.getItem() : null;
        }
        if (listenerManager != null && (enumeration = listenerManager.getListeners()) != null) {
            while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                switch (toolBarEvent.getID()) {
                    case 2001: {
                        ((ToolBarMouseListener)e).toolBarItemMouseEntered(toolBarEvent);
                        break;
                    }
                    case 2002: {
                        ((ToolBarMouseListener)e).toolBarItemMouseExited(toolBarEvent);
                        break;
                    }
                    case 2000: {
                        ((ToolBarActionListener)e).toolBarItemActionPerformed(toolBarEvent);
                        break;
                    }
                }
            }
        }
    }

    public synchronized void enable() {
        if (!this.isEnabled()) {
            super.enable();
            this.repaintCanvas();
        }
    }

    public synchronized void disable() {
        if (this.isEnabled()) {
            super.disable();
            this.repaintCanvas();
        }
    }
}

