/*
 * Decompiled with CFR 0.152.
 */
package oracle.help.topicWindow;

import java.awt.MenuComponent;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.Vector;
import oracle.ewt.event.ListenerManager;
import oracle.help.HelpBook;
import oracle.help.htmlBrowser.HTMLBrowser;
import oracle.help.htmlBrowser.PopupEvent;
import oracle.help.htmlBrowser.PopupListener;
import oracle.help.htmlBrowser.URLEvent;
import oracle.help.htmlBrowser.URLListener;
import oracle.help.topicWindow.DocumentStackEvent;
import oracle.help.topicWindow.DocumentStackListener;
import oracle.help.topicWindow.StackElement;
import oracle.help.util.MenuDefs;

public class DocumentStack
implements URLListener {
    private HTMLBrowser _browser;
    private ListenerManager _manager;
    private int _currentPosition;
    private Vector _stack = new Vector();
    private boolean _isLink = true;
    private HelpBook _currentBook;

    public DocumentStack(HTMLBrowser hTMLBrowser) {
        this._browser = hTMLBrowser;
        this._currentPosition = 0;
        hTMLBrowser.addURLListener(this);
        hTMLBrowser.addPopupListener(new _popupHandler());
    }

    public void urlChanged(URLEvent uRLEvent) {
        if (this._isLink) {
            this._addElement(this._currentBook, uRLEvent.getURL());
        }
        this._dispatchStackEvent(new DocumentStackEvent(uRLEvent.getURL()));
    }

    public void setURL(HelpBook helpBook, URL uRL) {
        this._addElement(helpBook, uRL);
        this._isLink = false;
        this._browser.setURL(uRL);
        this._isLink = true;
        this._currentBook = helpBook;
    }

    private void _setURL(URL uRL) {
        this._isLink = false;
        this._browser.setURL(uRL);
        this._isLink = true;
    }

    private void _addElement(HelpBook helpBook, URL uRL) {
        if (this._currentPosition < this._stack.size()) {
            this._stack.setSize(this._currentPosition);
        }
        StackElement stackElement = new StackElement();
        stackElement.url = uRL;
        stackElement.book = helpBook;
        this._stack.addElement(stackElement);
        ++this._currentPosition;
    }

    public boolean canGoBack() {
        return this._currentPosition > 1;
    }

    public void goBack() {
        if (this.canGoBack()) {
            --this._currentPosition;
            StackElement stackElement = (StackElement)this._stack.elementAt(this._currentPosition - 1);
            URL uRL = stackElement.url;
            this._isLink = false;
            this._browser.setURL(uRL);
            this._isLink = true;
        }
    }

    public boolean canGoForward() {
        return this._stack.size() > this._currentPosition;
    }

    public void goForward() {
        if (this.canGoForward()) {
            ++this._currentPosition;
            StackElement stackElement = (StackElement)this._stack.elementAt(this._currentPosition - 1);
            URL uRL = stackElement.url;
            this._isLink = false;
            this._browser.setURL(uRL);
            this._isLink = true;
        }
    }

    public URL getURL() {
        if (this._stack.size() == 0) {
            return null;
        }
        StackElement stackElement = (StackElement)this._stack.elementAt(this._currentPosition - 1);
        return stackElement.url;
    }

    public HelpBook getBook() {
        if (this._stack.size() == 0) {
            return null;
        }
        StackElement stackElement = (StackElement)this._stack.elementAt(this._currentPosition - 1);
        return stackElement.book;
    }

    public void addStackListener(DocumentStackListener documentStackListener) {
        if (this._manager == null) {
            this._manager = new ListenerManager();
        }
        this._manager.addListener(documentStackListener);
    }

    public void removeStackListener(DocumentStackListener documentStackListener) {
        this._manager.removeListener(documentStackListener);
    }

    private void _dispatchStackEvent(DocumentStackEvent documentStackEvent) {
        Enumeration enumeration;
        if (this._manager != null && (enumeration = this._manager.getListeners()) != null) {
            while (enumeration.hasMoreElements()) {
                DocumentStackListener documentStackListener = (DocumentStackListener)enumeration.nextElement();
                documentStackListener.documentStackChanged(documentStackEvent);
            }
        }
    }

    static /* synthetic */ HTMLBrowser access$0(DocumentStack documentStack) {
        return documentStack._browser;
    }

    private class _popupHandler
    implements PopupListener,
    ActionListener {
        private PopupMenu _popup;
        private MenuItem _backMenuItem;
        private MenuItem _forwardMenuItem;
        private MenuItem _printMenuItem;

        public void showPopup(PopupEvent popupEvent) {
            MouseEvent mouseEvent = popupEvent.getMouseEvent();
            if (this._popup == null) {
                this._createPopupMenu();
            }
            this._backMenuItem.setEnabled(DocumentStack.this.canGoBack());
            this._forwardMenuItem.setEnabled(DocumentStack.this.canGoForward());
            popupEvent.getComponent().add(this._popup);
            this._popup.addNotify();
            this._popup.show(popupEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == this._backMenuItem) {
                DocumentStack.this.goBack();
            } else if (object == this._forwardMenuItem) {
                DocumentStack.this.goForward();
            } else if (object == this._printMenuItem) {
                DocumentStack documentStack = DocumentStack.this;
                documentStack._browser.print();
            }
            ((MenuComponent)this._popup).getParent().remove(this._popup);
        }

        private void _createPopupMenu() {
            this._popup = new PopupMenu();
            ResourceBundle resourceBundle = ResourceBundle.getBundle("oracle.help.resource.MenuLabels");
            String string = resourceBundle.getString("Back");
            this._backMenuItem = new MenuItem(string);
            this._backMenuItem.setActionCommand("Back");
            String string2 = resourceBundle.getString("Forward");
            this._forwardMenuItem = new MenuItem(string2);
            this._forwardMenuItem.setActionCommand("Forward");
            MenuItem menuItem = new MenuItem("-");
            String string3 = resourceBundle.getString("PrintTopic");
            this._printMenuItem = new MenuItem();
            this._printMenuItem.setActionCommand("PrintTopic");
            MenuDefs.setMenuAttributes(this._printMenuItem, string3);
            this._popup.add(this._backMenuItem);
            this._popup.add(this._forwardMenuItem);
            this._popup.add(menuItem);
            this._popup.add(this._printMenuItem);
            this._backMenuItem.addActionListener(this);
            this._forwardMenuItem.addActionListener(this);
            this._printMenuItem.addActionListener(this);
        }

        _popupHandler() {
            DocumentStack.this = DocumentStack.this;
        }
    }
}

