/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.forms;

import COM.livingston.forms.LEAddDialog;
import COM.livingston.forms.LECmdErrorDialog;
import COM.livingston.forms.LEFormLine;
import COM.livingston.forms.LEFormLineFactory;
import COM.livingston.forms.LETableForm;
import COM.livingston.model.LEDataSpec;
import COM.livingston.model.LENATMap;
import COM.livingston.model.LEPortMaster;
import COM.livingston.model.LETable;
import COM.livingston.ui.LEFont;
import COM.livingston.ui.LEUiUtils;
import COM.livingston.util.LEDebug;
import COM.livingston.util.LEVector;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Label;
import java.awt.Panel;

public class LENATMapForm
extends LETableForm {
    String m_addType;

    boolean addNewEntry(LEDataSpec lEDataSpec, LEDataSpec lEDataSpec2) {
        Panel panel = new Panel();
        panel.setLayout(new BorderLayout());
        LEDataSpec lEDataSpec3 = lEDataSpec2.getSpecFor("type");
        Label label = new Label(String.valueOf(lEDataSpec3.getDescription()) + ": ");
        label.setFont(LEFont.getBoldFont());
        panel.add("West", label);
        Component component = LEFormLineFactory.BuildFormLine(null, null, null, lEDataSpec3);
        panel.add("East", component);
        LEAddDialog lEAddDialog = new LEAddDialog(LEUiUtils.GetBaseFrame(), "Add NAT Map Rule", panel);
        if (lEAddDialog.okay()) {
            this.m_addType = ((LEFormLine)((Object)component)).getValue();
            return true;
        }
        return false;
    }

    void addNewEntryTo(LEPortMaster lEPortMaster) {
        LENATMap lENATMap = (LENATMap)this.getTable(lEPortMaster);
        LEVector lEVector = null;
        if (this.m_addType.equals("addrmap") || this.m_addType.equals("staticaddrmap")) {
            lEVector = lENATMap.add(this.m_addType, "1.2.3.4", "1.2.3.4", false);
        } else if (this.m_addType.equals("statictuportmap")) {
            lEVector = lENATMap.add(this.m_addType, "1.2.3.4:1", "1.2.3.4:1", false);
        }
        if (lEVector != null) {
            new LECmdErrorDialog(LEUiUtils.GetBaseFrame(), lEPortMaster.getConfigFacility(), lEVector);
            this.refresh();
            return;
        }
        this.addEntry(lEPortMaster.getHostname(), lENATMap, Integer.toString(lENATMap.size()));
    }

    void delete(LEPortMaster lEPortMaster, LETable lETable, String string) {
        if (!(lETable instanceof LENATMap)) {
            return;
        }
        LENATMap lENATMap = (LENATMap)lETable;
        try {
            int n = Integer.parseInt(string);
            LEVector lEVector = lENATMap.delete(n);
            if (lEVector != null) {
                new LECmdErrorDialog(LEUiUtils.GetBaseFrame(), lEPortMaster.getConfigFacility(), lEVector);
                return;
            }
        }
        catch (NumberFormatException numberFormatException) {
            LEDebug.getLog().logln(20, numberFormatException);
        }
    }
}

