/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.model;

import COM.livingston.backend.LEDSSException;
import COM.livingston.backend.LEDSSPortMaster;
import COM.livingston.backend.LEPMCommand;
import COM.livingston.model.LEAsyncPort;
import COM.livingston.model.LEBGP;
import COM.livingston.model.LEBGPPeers;
import COM.livingston.model.LEBoards;
import COM.livingston.model.LEChoicenet;
import COM.livingston.model.LEConfig;
import COM.livingston.model.LEDataSpecFactory;
import COM.livingston.model.LEDebugFacility;
import COM.livingston.model.LEEthernets;
import COM.livingston.model.LEFileConfigFacility;
import COM.livingston.model.LEFilters;
import COM.livingston.model.LEGlobal;
import COM.livingston.model.LEHosts;
import COM.livingston.model.LEISDNPort;
import COM.livingston.model.LELines;
import COM.livingston.model.LELocations;
import COM.livingston.model.LEModems;
import COM.livingston.model.LEMonitorFacility;
import COM.livingston.model.LENATMaps;
import COM.livingston.model.LEOSPF;
import COM.livingston.model.LEOSPFAreas;
import COM.livingston.model.LEPMConfigFacility;
import COM.livingston.model.LEPort;
import COM.livingston.model.LEPorts;
import COM.livingston.model.LERadius;
import COM.livingston.model.LERoutes;
import COM.livingston.model.LESNMP;
import COM.livingston.model.LESubInterfaces;
import COM.livingston.model.LESyncPort;
import COM.livingston.model.LESyslog;
import COM.livingston.model.LEUsers;
import COM.livingston.util.LEDebug;
import COM.livingston.util.LEStatusManager;
import COM.livingston.util.LEThreadStatus;
import COM.livingston.util.LEVector;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.Vector;

public class LEPortMaster
extends LEConfig {
    public static final String BGP = "589824";
    public static final String BGP_PEERS = "1441792";
    public static final String BOARDS = "2555904";
    public static final String CHOICENET = "1507328";
    public static final String ETHERNETS = "720896";
    public static final String FILTERS = "filter";
    public static final String GLOBAL = "2162688";
    public static final String HOSTS = "1245184";
    public static final String LINES = "131072";
    public static final String LOCATIONS = "1703936";
    public static final String MODEMS = "196608";
    public static final String NAT_MAPS = "2686976";
    public static final String OSPF = "1048576";
    public static final String OSPF_AREAS = "524288";
    public static final String PORTS = "262144";
    public static final String RADIUS = "2228224";
    public static final String ROUTES = "1310720";
    public static final String SNMP = "1376256";
    public static final String SUB_IS = "2490368";
    public static final String SYSLOG = "327680";
    public static final String USERS = "1835008";
    public static final int KEY_COUNT = 21;
    public static final String DEFAULT_USER = "!root";
    public static final String MOD_IRX_111 = "IRX-111";
    public static final String MOD_IRX_112 = "IRX-112";
    public static final String MOD_IRX_114 = "IRX-114";
    public static final String MOD_IRX_211 = "IRX-211";
    public static final String MOD_OR = "OR";
    public static final String MOD_OR_AP = "OR-AP";
    public static final String MOD_OR_HS = "OR-HS";
    public static final String MOD_OR_LS = "OR-LS";
    public static final String MOD_OR_M = "OR-M";
    public static final String MOD_OR_ST = "OR-ST";
    public static final String MOD_OR_U = "OR-U";
    public static final String MOD_PM2 = "PM-2";
    public static final String MOD_PM25 = "PM-25";
    public static final String MOD_PM2E = "PM-2e";
    public static final String MOD_PM2EI = "PM-2ei";
    public static final String MOD_PM2ER = "PM-2er";
    public static final String MOD_PM2I = "PM-2i";
    public static final String MOD_PM2R = "PM-2r";
    public static final String MOD_PM3 = "PM-3";
    public static final String MOD_PM4 = "PM-4";
    public static final String MOD_UNKNOWN = "";
    static final String SET_PASSWORD = "set pas";
    static final String PM4 = "7.";
    static final String PM3 = "6.";
    static final String IRX = "4.";
    static final String OR = "5.";
    static final String PM25 = "2.5";
    static final String PM2 = "2.2";
    static String[] s_keys = null;
    String m_host;
    String m_user;
    String m_password;
    String m_directory;
    LEDSSPortMaster m_dss;
    LEDebugFacility m_debug;
    LEMonitorFacility m_monitor;
    Vector m_retrieved = new Vector();
    String m_software = "";
    String m_hardware;
    String m_uptime = "";

    public static String[] GetAllPossibleKeys() {
        if (s_keys == null) {
            s_keys = new String[21];
            int n = 0;
            LEPortMaster.s_keys[n++] = BGP;
            LEPortMaster.s_keys[n++] = BGP_PEERS;
            LEPortMaster.s_keys[n++] = BOARDS;
            LEPortMaster.s_keys[n++] = CHOICENET;
            LEPortMaster.s_keys[n++] = ETHERNETS;
            LEPortMaster.s_keys[n++] = FILTERS;
            LEPortMaster.s_keys[n++] = GLOBAL;
            LEPortMaster.s_keys[n++] = HOSTS;
            LEPortMaster.s_keys[n++] = LINES;
            LEPortMaster.s_keys[n++] = LOCATIONS;
            LEPortMaster.s_keys[n++] = MODEMS;
            LEPortMaster.s_keys[n++] = NAT_MAPS;
            LEPortMaster.s_keys[n++] = OSPF;
            LEPortMaster.s_keys[n++] = OSPF_AREAS;
            LEPortMaster.s_keys[n++] = PORTS;
            LEPortMaster.s_keys[n++] = RADIUS;
            LEPortMaster.s_keys[n++] = ROUTES;
            LEPortMaster.s_keys[n++] = SNMP;
            LEPortMaster.s_keys[n++] = SUB_IS;
            LEPortMaster.s_keys[n++] = SYSLOG;
            LEPortMaster.s_keys[n++] = USERS;
        }
        return s_keys;
    }

    public LEPortMaster(String string, String string2, String string3) throws LEDSSException, IOException {
        super(null);
        this.m_host = string;
        this.m_user = string2;
        this.m_directory = null;
        this.m_password = string3;
        this.m_facility = new LEPMConfigFacility(this);
        this.m_dss = string2.equals(DEFAULT_USER) ? new LEDSSPortMaster(string, string3) : new LEDSSPortMaster(string, string2, string3);
        if (this.m_dss.supportsEntities()) {
            this.m_debug = new LEDebugFacility(this.m_dss);
        }
        if (this.m_dss.supportsEntities()) {
            this.m_monitor = new LEMonitorFacility(this.m_dss);
        }
        try {
            this.setSpec(LEDataSpecFactory.GetPortMasterSpec());
        }
        catch (IOException iOException) {
            LEDebug.getLog().logln(20, iOException);
        }
        this.ping();
    }

    public LEPortMaster(String string, String string2) throws LEDSSException, IOException {
        super(null);
        this.m_host = string2;
        this.m_user = null;
        this.m_password = null;
        this.m_directory = string;
        this.m_facility = new LEFileConfigFacility(this, this.m_directory, this.m_host);
    }

    public boolean isConnected() {
        if (this.m_directory == null) {
            if (this.m_dss == null) {
                return false;
            }
            return this.m_dss.isConnected();
        }
        return true;
    }

    public void disconnect() {
        if (this.isConnected()) {
            if (this.m_debug != null) {
                this.m_debug.shutdown();
            }
            if (this.m_monitor != null) {
                this.m_monitor.shutdown();
            }
        }
        if (this.m_dss != null) {
            this.m_dss.disconnect();
        }
        this.m_debug = null;
        this.m_monitor = null;
    }

    public boolean reconnect() {
        if (this.m_dss == null) {
            return false;
        }
        if (this.isConnected()) {
            return true;
        }
        boolean bl = this.m_dss.reconnect();
        if (bl) {
            this.purgeCache();
        }
        return bl;
    }

    public void reboot() {
        if (this.m_dss != null) {
            this.execute("reboot");
        }
    }

    public String getHostname() {
        return this.m_host;
    }

    public String getUsername() {
        return this.m_user;
    }

    public String getPassword() {
        return this.m_password;
    }

    public String getUpTime() {
        return this.m_uptime;
    }

    public String getSoftwareVersion() {
        return this.m_software;
    }

    public String getHardwareType() {
        return this.m_hardware;
    }

    public LEDebugFacility getDebugFacility() {
        return this.m_debug;
    }

    public LEMonitorFacility getMonitorFacility() {
        return this.m_monitor;
    }

    public LEDSSPortMaster getDSS() {
        return this.m_dss;
    }

    public Object get(String string) {
        Object v = this.m_fields.get(string);
        if (v == null && !this.m_retrieved.contains(string) && this.load(string)) {
            this.m_retrieved.addElement(string);
            v = this.m_fields.get(string);
        }
        return v;
    }

    public Object fetch(String string) {
        if (this.m_fields.containsKey(string)) {
            this.load(string);
        }
        return this.get(string);
    }

    public LEPMCommand execute(String string) {
        String string2;
        if (this.m_facility == null || !this.isConnected()) {
            LEPMCommand lEPMCommand = new LEPMCommand(string);
            lEPMCommand.setResult("No connection");
            lEPMCommand.setStatus(false);
            return lEPMCommand;
        }
        LEPMCommand lEPMCommand = this.m_facility.execute(string);
        if (LEPMCommand.IsReboot(string)) {
            this.purgeCache();
        } else if (string.length() > 6 && (string2 = string.substring(0, 7)).equalsIgnoreCase(SET_PASSWORD)) {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            String string3 = stringTokenizer.nextToken();
            string3 = stringTokenizer.nextToken();
            this.m_password = stringTokenizer.nextToken();
            this.m_dss.setPassword(this.m_password);
        }
        LEStatusManager.SetStatus(LEThreadStatus.NO_MESSAGE);
        return lEPMCommand;
    }

    public boolean ping() {
        if (this.m_dss == null) {
            return false;
        }
        boolean bl = false;
        if (this.m_dss.supportsEntities()) {
            LEPMCommand lEPMCommand = this.execute("version");
            if (lEPMCommand.getStatus()) {
                bl = true;
                this.parseVersion(lEPMCommand.getResult());
            }
        } else if (this.load(GLOBAL)) {
            bl = true;
        }
        return bl;
    }

    public void purgeCache() {
        this.m_retrieved.removeAllElements();
        this.get(GLOBAL);
        if (this.m_dss.supportsEntities()) {
            this.m_debug = new LEDebugFacility(this.m_dss);
            this.m_monitor = new LEMonitorFacility(this.m_dss);
            return;
        }
        this.m_debug = null;
    }

    public boolean getCommands(LEVector lEVector) {
        String[] stringArray = LEPortMaster.GetAllPossibleKeys();
        int n = 0;
        while (n < stringArray.length) {
            this.get(stringArray[n]);
            ++n;
        }
        return super.getCommands(lEVector);
    }

    void refresh(LEConfig lEConfig) {
        String string = this.getKeyFor(lEConfig);
        if (string != null) {
            this.fetch(string);
        }
    }

    void parseVersion(String string) {
        if (string == null) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        boolean bl = false;
        while (stringTokenizer.hasMoreElements()) {
            String string2 = stringTokenizer.nextToken();
            if (bl) {
                stringBuffer.append(' ');
                stringBuffer.append(string2);
                continue;
            }
            if (string2.equals("is")) {
                bl = true;
                stringBuffer.append(stringTokenizer.nextToken());
                continue;
            }
            if (string2.equals("PortMaster")) {
                string2 = stringTokenizer.nextToken();
                if (this.m_hardware != null) continue;
                if (string2.equals(MOD_PM3) || string2.equals(MOD_PM4) || string2.equals(MOD_PM25)) {
                    this.m_hardware = string2;
                    continue;
                }
                this.m_hardware = this.determineModel();
                continue;
            }
            if (!string2.equals("ComOS")) continue;
            this.m_software = stringTokenizer.nextToken();
        }
        this.m_uptime = new String(stringBuffer);
        int n = this.m_uptime.length();
        if (n > 0) {
            this.m_uptime = this.m_uptime.substring(0, n - 1);
        }
    }

    void formatUpTime(int n) {
        int n2 = n / 1440;
        int n3 = n % 1440 / 60;
        int n4 = n % 60;
        StringBuffer stringBuffer = new StringBuffer();
        if (n2 > 0) {
            stringBuffer.append(n2);
            stringBuffer.append(" day");
            if (n2 > 1) {
                stringBuffer.append('s');
            }
            stringBuffer.append(' ');
        }
        if (n3 > 0) {
            stringBuffer.append(n3);
            stringBuffer.append(" hour");
            if (n3 > 1) {
                stringBuffer.append('s');
            }
            stringBuffer.append(' ');
        }
        stringBuffer.append(n4);
        stringBuffer.append(" minute");
        if (n4 > 1) {
            stringBuffer.append('s');
        }
        this.m_uptime = new String(stringBuffer);
    }

    boolean load(String string) {
        LEStatusManager.SetStatus("Getting " + this.getDescriptionFor(string) + " from " + this.m_host);
        boolean bl = this.m_facility.getConfig(string);
        if (bl && string.equals(GLOBAL)) {
            LEGlobal lEGlobal = (LEGlobal)this.get(GLOBAL);
            String string2 = (String)lEGlobal.get("145");
            if (string2 != null && string2.length() > 0) {
                this.m_software = string2;
            }
            if (this.m_hardware == null) {
                this.m_hardware = this.determineModel();
            }
            string2 = (String)lEGlobal.get("36");
            try {
                int n = Integer.parseInt(string2);
                this.formatUpTime(n);
            }
            catch (Exception exception) {
                LEDebug.getLog().logln(20, exception);
            }
        }
        LEStatusManager.StatusComplete();
        return bl;
    }

    String determineModel() {
        LEGlobal lEGlobal = (LEGlobal)this.get(GLOBAL);
        if (lEGlobal == null) {
            return MOD_UNKNOWN;
        }
        String string = (String)lEGlobal.get("146");
        if (string == null || string.length() == 0) {
            return MOD_UNKNOWN;
        }
        if (string.startsWith(PM3)) {
            return MOD_PM3;
        }
        if (string.startsWith(PM4)) {
            return MOD_PM4;
        }
        if (string.startsWith(PM25)) {
            return MOD_PM25;
        }
        LEPorts lEPorts = (LEPorts)this.get(PORTS);
        if (lEPorts == null) {
            return MOD_UNKNOWN;
        }
        if (string.startsWith(IRX)) {
            LEPort lEPort = lEPorts.getPort("S4");
            if (lEPort != null) {
                return MOD_IRX_114;
            }
            lEPort = lEPorts.getPort("S2");
            if (lEPort != null) {
                return MOD_IRX_112;
            }
            LEEthernets lEEthernets = (LEEthernets)this.get(ETHERNETS);
            if (lEEthernets != null && lEEthernets.get("ether1") != null) {
                return MOD_IRX_211;
            }
            return MOD_IRX_111;
        }
        if (string.startsWith(OR)) {
            LEPort lEPort = lEPorts.getPort("S1");
            if (lEPort != null) {
                if (lEPort instanceof LEAsyncPort) {
                    return MOD_OR_M;
                }
                if (lEPort instanceof LEISDNPort) {
                    String string2 = (String)lEGlobal.get("145");
                    if (string2.indexOf("AP") != -1) {
                        return MOD_OR_AP;
                    }
                    return MOD_OR_U;
                }
            }
            if ((lEPort = lEPorts.getPort("W1")) instanceof LESyncPort) {
                return MOD_OR_HS;
            }
            return MOD_OR;
        }
        if (string.startsWith(PM2)) {
            boolean bl = false;
            LEPort lEPort = lEPorts.getPort("S10");
            if (lEPort != null) {
                bl = true;
            } else {
                lEPort = lEPorts.getPort("S20");
                if (lEPort != null) {
                    bl = true;
                }
            }
            lEPort = lEPorts.getPort("P0");
            if (lEPort != null) {
                if (bl) {
                    return MOD_PM2E;
                }
                return MOD_PM2;
            }
            lEPort = lEPorts.getPort("W1");
            if (lEPort != null) {
                if (bl) {
                    return MOD_PM2ER;
                }
                return MOD_PM2R;
            }
            lEPort = lEPorts.getPort("C0");
            if (lEPort != null) {
                if (bl) {
                    return MOD_PM2EI;
                }
                return MOD_PM2I;
            }
            return MOD_PM2;
        }
        return MOD_UNKNOWN;
    }

    LEConfig createConfig(String string) {
        LEConfig lEConfig = string.equals(BGP) ? new LEBGP(this.m_facility) : (string.equals(BGP_PEERS) ? new LEBGPPeers(this.m_facility) : (string.equals(GLOBAL) ? new LEGlobal(this.m_facility) : (string.equals(RADIUS) ? new LERadius(this.m_facility) : (string.equals(CHOICENET) ? new LEChoicenet(this.m_facility) : (string.equals(FILTERS) ? new LEFilters(this.m_facility) : (string.equals(PORTS) ? new LEPorts(this.m_facility) : (string.equals(USERS) ? new LEUsers(this.m_facility) : (string.equals(LOCATIONS) ? new LELocations(this.m_facility) : (string.equals(ETHERNETS) ? new LEEthernets(this.m_facility) : (string.equals(SYSLOG) ? new LESyslog(this.m_facility) : (string.equals(SNMP) ? new LESNMP(this.m_facility) : (string.equals(OSPF) ? new LEOSPF(this.m_facility) : (string.equals(OSPF_AREAS) ? new LEOSPFAreas(this.m_facility) : (string.equals(ROUTES) ? new LERoutes(this.m_facility) : (string.equals(HOSTS) ? new LEHosts(this.m_facility) : (string.equals(MODEMS) ? new LEModems(this.m_facility) : (string.equals(LINES) ? new LELines(this.m_facility) : (string.equals(SUB_IS) ? new LESubInterfaces(this.m_facility) : (string.equals(BOARDS) ? new LEBoards(this.m_facility) : (string.equals(NAT_MAPS) ? new LENATMaps(this.m_facility) : new LEConfig(this.m_facility)))))))))))))))))))));
        return lEConfig;
    }
}

