/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.model;

import COM.livingston.model.LEConfig;
import COM.livingston.model.LEConfigFacility;
import COM.livingston.model.LEDLCIList;
import COM.livingston.model.LEDLCITable;
import COM.livingston.model.LEPort;
import COM.livingston.util.LEVector;

public class LESyncPort
extends LEPort {
    public static final String COMPRESSION = Integer.toString(290);
    public static final String DESTINATION = Integer.toString(74);
    public static final String DLCI_LIST = "dlci";
    public static final String IP_DLCI_TAB = Integer.toString(305);
    public static final String IPX_DLCI_TAB = Integer.toString(306);
    public static final String GROUP = Integer.toString(129);
    public static final String HANGUP = Integer.toString(332);
    public static final String IDLE_TIMEOUT = Integer.toString(297);
    public static final String INPUT_FILTER = Integer.toString(193);
    public static final String IPX_NETWORK = Integer.toString(189);
    public static final String LOCAL_IP = Integer.toString(177);
    public static final String LMI_TIMER = Integer.toString(319);
    public static final String LMI_TYPE = Integer.toString(318);
    public static final String MODEM_CONTROL = Integer.toString(316);
    public static final String MTU = Integer.toString(295);
    public static final String NAT_TCP_TIMEOUT = "353";
    public static final String NAT_OTHER_TIMEOUT = "354";
    public static final String NAT_FAIL_ACTION = "355";
    public static final String NAT_IN_MAP = "356";
    public static final String NAT_PROXY_IN_MAP = "357";
    public static final String NAT_OUT_MAP = "358";
    public static final String NAT_PROXY_OUT_MAP = "359";
    public static final String NAT_LOG_FAILURE = "360";
    public static final String NAT_LOG_SUCCESS = "361";
    public static final String NAT_LOG_SYSLOG = "362";
    public static final String NAT_LOG_CONSOLE = "363";
    public static final String NETMASK = Integer.toString(15);
    public static final String NETWORK_TYPE = Integer.toString(312);
    public static final String OSPF = Integer.toString(181);
    public static final String OUTPUT_FILTER = Integer.toString(194);
    public static final String PROTOCOL = Integer.toString(289);
    public static final String RIP_BROAD = Integer.toString(187);
    public static final String RIP_LISTEN = Integer.toString(188);
    public static final String SPEED = Integer.toString(130);
    public static final int KEY_COUNT = 34;
    public static final String LMI = "lmi";
    public static final String ANNEXD = "annex-d";
    public static final String NONE = "none";
    public static final String PPP = "ppp";
    public static final String FRAME = "frame";
    static String[] s_keys = null;

    public static String[] GetAllPossibleKeys() {
        if (s_keys == null) {
            s_keys = new String[34];
            int n = 0;
            LESyncPort.s_keys[n++] = COMPRESSION;
            LESyncPort.s_keys[n++] = DESTINATION;
            LESyncPort.s_keys[n++] = DLCI_LIST;
            LESyncPort.s_keys[n++] = GROUP;
            LESyncPort.s_keys[n++] = HANGUP;
            LESyncPort.s_keys[n++] = IDLE_TIMEOUT;
            LESyncPort.s_keys[n++] = INPUT_FILTER;
            LESyncPort.s_keys[n++] = IP_DLCI_TAB;
            LESyncPort.s_keys[n++] = IPX_DLCI_TAB;
            LESyncPort.s_keys[n++] = IPX_NETWORK;
            LESyncPort.s_keys[n++] = LMI_TYPE;
            LESyncPort.s_keys[n++] = LMI_TIMER;
            LESyncPort.s_keys[n++] = LOCAL_IP;
            LESyncPort.s_keys[n++] = MODEM_CONTROL;
            LESyncPort.s_keys[n++] = MTU;
            LESyncPort.s_keys[n++] = NAT_TCP_TIMEOUT;
            LESyncPort.s_keys[n++] = NAT_OTHER_TIMEOUT;
            LESyncPort.s_keys[n++] = NAT_FAIL_ACTION;
            LESyncPort.s_keys[n++] = NAT_IN_MAP;
            LESyncPort.s_keys[n++] = NAT_PROXY_IN_MAP;
            LESyncPort.s_keys[n++] = NAT_OUT_MAP;
            LESyncPort.s_keys[n++] = NAT_PROXY_OUT_MAP;
            LESyncPort.s_keys[n++] = NAT_LOG_FAILURE;
            LESyncPort.s_keys[n++] = NAT_LOG_SUCCESS;
            LESyncPort.s_keys[n++] = NAT_LOG_SYSLOG;
            LESyncPort.s_keys[n++] = NAT_LOG_CONSOLE;
            LESyncPort.s_keys[n++] = NETMASK;
            LESyncPort.s_keys[n++] = NETWORK_TYPE;
            LESyncPort.s_keys[n++] = OUTPUT_FILTER;
            LESyncPort.s_keys[n++] = OSPF;
            LESyncPort.s_keys[n++] = PROTOCOL;
            LESyncPort.s_keys[n++] = RIP_BROAD;
            LESyncPort.s_keys[n++] = RIP_LISTEN;
            LESyncPort.s_keys[n++] = SPEED;
        }
        return s_keys;
    }

    public LESyncPort(LEConfigFacility lEConfigFacility, String string, String string2) {
        super(lEConfigFacility, string, string2);
    }

    public Object clone() {
        LESyncPort lESyncPort = new LESyncPort(this.m_facility, this.m_board, this.m_name);
        lESyncPort.copy(this);
        return lESyncPort;
    }

    LEConfig createConfig(String string) {
        if (string.equals(IP_DLCI_TAB)) {
            return new LEDLCITable(this.m_facility, this.m_board, this.m_name, "ipdlci");
        }
        if (string.equals(IPX_DLCI_TAB)) {
            return new LEDLCITable(this.m_facility, this.m_board, this.m_name, "ipxdlci");
        }
        return new LEDLCIList(this.m_facility, this.m_name);
    }

    boolean generateCommands(LEVector lEVector, LEVector lEVector2) {
        boolean bl = lEVector == null;
        int n = lEVector2.size();
        if (bl || lEVector.contains(NETWORK_TYPE)) {
            this.makeTypeCommand(lEVector2, null, (String)this.get(NETWORK_TYPE), null);
        }
        if (bl || lEVector.contains(COMPRESSION)) {
            this.makeSetCommand(lEVector2, this.m_name, COMPRESSION, "compression");
        }
        if (bl || lEVector.contains(DESTINATION)) {
            this.makeSetCommand(lEVector2, this.m_name, DESTINATION, "destination");
        }
        if (bl || lEVector.contains(GROUP)) {
            this.makeSetCommand(lEVector2, this.m_name, GROUP, "group");
        }
        if (bl || lEVector.contains(HANGUP)) {
            this.makeSetCommand(lEVector2, this.m_name, HANGUP, "hangup");
        }
        if (bl || lEVector.contains(IDLE_TIMEOUT)) {
            this.makeSetCommand(lEVector2, this.m_name, IDLE_TIMEOUT, "idletime");
        }
        if (bl || lEVector.contains(INPUT_FILTER)) {
            this.makeSetCommand(lEVector2, this.m_name, INPUT_FILTER, "ifilter");
        }
        if (bl || lEVector.contains(IPX_NETWORK)) {
            this.makeSetCommand(lEVector2, this.m_name, IPX_NETWORK, "ipxnet");
        }
        if (bl || lEVector.contains(LMI_TYPE) || lEVector.contains(LMI_TIMER)) {
            String string = (String)this.get(LMI_TYPE);
            String string2 = (String)this.get(LMI_TIMER);
            if (string.equals(NONE)) {
                string = LMI;
                string2 = "0";
            }
            if (string != null && string.length() > 0 && string2 != null && string2.length() > 0) {
                StringBuffer stringBuffer = new StringBuffer("set ");
                stringBuffer.append(this.m_name);
                stringBuffer.append(" ");
                stringBuffer.append(string);
                stringBuffer.append(" ");
                stringBuffer.append(string2);
                lEVector2.addElement(new String(stringBuffer));
            }
        }
        if (bl || lEVector.contains(LOCAL_IP)) {
            this.makeSetCommand(lEVector2, this.m_name, LOCAL_IP, "address");
        }
        if (bl || lEVector.contains(MODEM_CONTROL)) {
            this.makeSetCommand(lEVector2, this.m_name, MODEM_CONTROL, "cd");
        }
        if (bl || lEVector.contains(MTU)) {
            this.makeSetCommand(lEVector2, this.m_name, MTU, "mtu");
        }
        if (bl || lEVector.contains(NAT_TCP_TIMEOUT)) {
            this.makeNATTimeOutCommand(lEVector2, this.m_name, NAT_TCP_TIMEOUT, NAT_TCP_TIMEOUT);
        }
        if (bl || lEVector.contains(NAT_OTHER_TIMEOUT)) {
            this.makeNATTimeOutCommand(lEVector2, this.m_name, NAT_OTHER_TIMEOUT, NAT_OTHER_TIMEOUT);
        }
        if (bl || lEVector.contains(NAT_FAIL_ACTION)) {
            this.makeNATFailActionCommand(lEVector2, this.m_name, NAT_FAIL_ACTION);
        }
        if (bl || lEVector.contains(NAT_IN_MAP)) {
            this.makeNATMapCommand(lEVector2, this.m_name, NAT_IN_MAP, true, false);
        }
        if (bl || lEVector.contains(NAT_PROXY_IN_MAP)) {
            this.makeNATMapCommand(lEVector2, this.m_name, NAT_PROXY_IN_MAP, true, true);
        }
        if (bl || lEVector.contains(NAT_OUT_MAP)) {
            this.makeNATMapCommand(lEVector2, this.m_name, NAT_OUT_MAP, false, false);
        }
        if (bl || lEVector.contains(NAT_PROXY_OUT_MAP)) {
            this.makeNATMapCommand(lEVector2, this.m_name, NAT_PROXY_OUT_MAP, false, true);
        }
        if (bl || lEVector.contains(NAT_LOG_FAILURE)) {
            this.makeNATLogCommand(lEVector2, this.m_name, NAT_LOG_FAILURE, NAT_LOG_FAILURE);
        }
        if (bl || lEVector.contains(NAT_LOG_SUCCESS)) {
            this.makeNATLogCommand(lEVector2, this.m_name, NAT_LOG_SUCCESS, NAT_LOG_SUCCESS);
        }
        if (bl || lEVector.contains(NAT_LOG_SYSLOG)) {
            this.makeNATLogCommand(lEVector2, this.m_name, NAT_LOG_SYSLOG, NAT_LOG_SYSLOG);
        }
        if (bl || lEVector.contains(NAT_LOG_CONSOLE)) {
            this.makeNATLogCommand(lEVector2, this.m_name, NAT_LOG_CONSOLE, NAT_LOG_CONSOLE);
        }
        if (bl || lEVector.contains(NETMASK)) {
            this.makeSetCommand(lEVector2, this.m_name, NETMASK, "netmask");
        }
        if (bl || lEVector.contains(OUTPUT_FILTER)) {
            this.makeSetCommand(lEVector2, this.m_name, OUTPUT_FILTER, "ofilter");
        }
        if (bl || lEVector.contains(OSPF)) {
            this.makeSetCommand(lEVector2, this.m_name, OSPF, "ospf");
        }
        if (bl || lEVector.contains(PROTOCOL)) {
            this.makeSetCommand(lEVector2, this.m_name, PROTOCOL, "protocol");
        }
        if (bl || lEVector.contains(RIP_BROAD) || lEVector.contains(RIP_LISTEN)) {
            this.makeRIPCommand(lEVector2, this.m_name, "rip", (String)this.get(RIP_BROAD), (String)this.get(RIP_LISTEN));
        }
        return lEVector2.size() > n;
    }
}

