/*
 * Decompiled with CFR 0.152.
 */
import COM.livingston.backend.LEDSSPMAuthFailureException;
import COM.livingston.backend.LEDSSPortMaster;
import COM.livingston.model.LEConfig;
import COM.livingston.model.LEPortMaster;
import COM.livingston.ui.LEAboutDialog;
import COM.livingston.ui.LEActionClient;
import COM.livingston.ui.LEActionDialog;
import COM.livingston.ui.LEBorderPanel;
import COM.livingston.ui.LEClipboard;
import COM.livingston.ui.LEColor;
import COM.livingston.ui.LEConnectDialog;
import COM.livingston.ui.LEErrorDialog;
import COM.livingston.ui.LEFont;
import COM.livingston.ui.LEHelpBar;
import COM.livingston.ui.LELEDs;
import COM.livingston.ui.LELoginClient;
import COM.livingston.ui.LEMLEvent;
import COM.livingston.ui.LEMLListener;
import COM.livingston.ui.LEPathEvent;
import COM.livingston.ui.LEPathListener;
import COM.livingston.ui.LEScrollPanel;
import COM.livingston.ui.LESplitterPanel;
import COM.livingston.ui.LEStatusBar;
import COM.livingston.ui.LETitleBar;
import COM.livingston.ui.LETreeEvent;
import COM.livingston.ui.LETreeItem;
import COM.livingston.ui.LETreeListener;
import COM.livingston.ui.LEUiUtils;
import COM.livingston.util.LEAppInfo;
import COM.livingston.util.LEDebug;
import COM.livingston.util.LEProperties;
import COM.livingston.util.LEResource;
import COM.livingston.util.LEStatusManager;
import COM.livingston.util.LEVector;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Vector;
import oracle.help.Book;
import oracle.help.Help;

public class LEConsole
extends Frame
implements LEActionClient,
LELoginClient,
LETreeListener,
LEMLListener,
LEPathListener,
LEViewListener,
ActionListener,
WindowListener,
Runnable {
    public static final String ACTION_ABOUT = "about";
    public static final String ACTION_CONNECT = "connect";
    public static final String ACTION_DISCONNECT = "disconnect";
    public static final String ACTION_EXIT = "exit";
    public static final String ACTION_HELP_CONTENTS = "help_contents";
    public static final String ACTION_HELP_CURRENT = "help_current";
    public static final String ACTION_HELP_SEARCH = "help_search";
    public static final String ACTION_REBOOT = "reboot";
    public static final String ACTION_RECONNECT = "reconnect";
    public static final String ACTION_REMOVE = "remove";
    public static final String ACTION_SUBWINDOW = "SUB";
    public static final String ACTION_UPDATE_START = "update_start";
    public static final String ACTION_UPDATE_END = "update_end";
    public static final String PROPERTIES_FILE = "pmvprops.cfg";
    static final String PROP_MAIN_X = "main_x";
    static final String PROP_MAIN_Y = "main_y";
    static final String PROP_MAIN_W = "main_w";
    static final String PROP_MAIN_H = "main_h";
    static final String PROP_TREE_W = "tree_w";
    static final String PROP_GRID_H = "grid_h";
    static LEConsole s_console;
    static Image s_main32;
    static Image s_main16;
    static String s_path;
    MenuBar m_menubar;
    Menu m_windows;
    MenuItem m_disconn;
    MenuItem m_remove;
    MenuItem m_reboot;
    MenuItem m_recon;
    LEStatusBar m_statusbar;
    LEHelpBar m_helpbar;
    LEBorderPanel m_work;
    LEBorderPanel m_treePanel;
    LEControlTree m_tree;
    LEPMGrid m_grid;
    LEPMPathBar m_pathBar;
    LEView m_view;
    Panel m_workBottom;
    Component m_workMain;
    LEClipboard m_cb;
    Book m_book;
    Help m_help;
    Button m_dummy;
    LEPortMaster[] m_selPMs = new LEPortMaster[0];
    String m_hostname;
    String m_password;
    String m_username;
    LEPortMaster m_pm;
    Rectangle m_bounds;
    int m_treeWidth = 150;
    int m_gridHeight = 150;
    LEVector m_subwins = new LEVector();
    static /* synthetic */ Class class$pmvhlp$PMVisionHelp;

    public static void Display() {
        if (s_console == null) {
            new LEConsole();
        }
    }

    public static LEConsole GetConsole() {
        return s_console;
    }

    public LEConsole() {
        super(LEAppInfo.getAppTitle());
        LEUiUtils.SetBaseFrame(this);
        LEColor.CheckColorFlags();
        LEProperties.SetPropertyFile(LEAppInfo.getUserAppDirPath(PROPERTIES_FILE));
        this.loadProperties();
        s_console = this;
        this.addWindowListener(this);
        this.setLayout(new BorderLayout(5, 5));
        ((Component)this).setBackground(LEColor.getBackground());
        this.m_menubar = this.createMenuBar();
        this.setMenuBar(this.m_menubar);
        Panel panel = new Panel();
        panel.setLayout(new GridLayout(1, 2, 10, 10));
        this.m_statusbar = new LEStatusBar(2, LEStatusManager.GetManager());
        this.m_statusbar.setStatusText(LEAppInfo.getAppTitle());
        panel.add(this.m_statusbar);
        this.m_helpbar = new LEHelpBar(2);
        panel.add(this.m_helpbar);
        this.add("South", panel);
        LESplitterPanel lESplitterPanel = new LESplitterPanel();
        this.m_treePanel = new LEBorderPanel(2);
        this.m_treePanel.setLayout(new BorderLayout(0, 0));
        this.m_treePanel.setInsets(1, 1, 1, 1);
        this.m_tree = new LEControlTree();
        this.m_tree.addListener(this);
        this.m_treePanel.add("Center", this.m_tree);
        lESplitterPanel.addColumn(this.m_treeWidth);
        lESplitterPanel.addComponent((Component)this.m_treePanel, 0);
        this.m_grid = new LEPMGrid();
        this.m_grid.addListener(this);
        lESplitterPanel.addColumn(0);
        new LEBorderPanel(2);
        LEScrollPanel lEScrollPanel = new LEScrollPanel(this.m_grid);
        lESplitterPanel.addComponent((Component)lEScrollPanel, this.m_gridHeight);
        this.m_pathBar = new LEPMPathBar();
        this.m_pathBar.addListener(this);
        this.m_work = new LEBorderPanel(2);
        this.m_work.setInsets(0, 0, 0, 0);
        this.m_work.setLayout(new BorderLayout(0, 0));
        this.m_work.add("North", this.m_pathBar);
        lESplitterPanel.addComponent((Component)this.m_work, 0);
        this.add("Center", lESplitterPanel);
        this.m_cb.watchContainer(this.m_work);
        this.m_dummy = new Button();
        this.m_dummy.addActionListener(this);
        ((Component)this).setVisible(true);
        String string = LEAppInfo.getFlag("-g");
        if (string != null) {
            try {
                int n = Integer.parseInt(string);
                LEDebug.getLog().setLogLevel(n);
            }
            catch (NumberFormatException numberFormatException) {
                LEDebug.getLog().logln(20, "Bad argument for log level: " + string);
            }
        }
        try {
            this.m_book = Help.createBook((Class)(class$pmvhlp$PMVisionHelp != null ? class$pmvhlp$PMVisionHelp : (class$pmvhlp$PMVisionHelp = LEConsole.class$("pmvhlp.PMVisionHelp"))), (String)".", (String)"Amberhlp", (String)"PMVision Help");
            if (this.m_book != null) {
                this.m_help = new Help();
                this.m_help.addBook(this.m_book);
                return;
            }
        }
        catch (Throwable throwable) {
            LEDebug.getLog().logln(20, throwable);
            LEDebug.getLog().logln(20, "Help system disabled");
        }
    }

    public void addNotify() {
        Object object;
        Object object2;
        super.addNotify();
        LEFont.setDefaultFont(this.getFont());
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        if (this.m_bounds != null) {
            n = this.m_bounds.x;
            n2 = this.m_bounds.y;
            n3 = this.m_bounds.width;
            n4 = this.m_bounds.height;
        }
        if (n3 == 0 || n4 == 0) {
            object2 = Toolkit.getDefaultToolkit().getScreenSize();
            n3 = ((Dimension)object2).width;
            n4 = ((Dimension)object2).height - 30;
        }
        ((Component)this).setLocation(n, n2);
        ((Component)this).setSize(n3, n4);
        LELEDs.Initialize();
        try {
            s_main32 = LEResource.GetImage("lucent_32.gif");
            s_main16 = LEResource.GetImage("lucent_16.gif");
            if (s_main32 != null) {
                this.setIconImage(s_main32);
            }
            object2 = LEResource.GetImage("tree-col.gif");
            object = LEResource.GetImage("tree-exp.gif");
            if (object2 instanceof Image && object instanceof Image) {
                this.m_tree.setDefaultImages((Image)object2, (Image)object);
            }
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
        }
        object2 = LEAppInfo.getFlag("-h");
        object = LEAppInfo.getFlag("-u");
        String string = LEAppInfo.getFlag("-p");
        if (object2 != null && string != null) {
            if (object == null) {
                object = "!root";
            }
            this.loginTo((String)object2, (String)object, string);
        } else if (object2 != null) {
            if (object == null) {
                object = "!root";
            }
            LEConnectDialog.Show(this, this, (String)object2, (String)object, string);
        }
        Vector vector = this.m_tree.getRoots();
        if (vector.size() > 0) {
            this.m_tree.select((LETreeItem)vector.elementAt(0), true);
        }
    }

    public void lock() {
        this.m_tree.setEnabled(false);
        this.m_pathBar.setEnabled(false);
        this.m_grid.setEnabled(false);
    }

    public void unlock() {
        this.m_tree.setEnabled(true);
        this.m_pathBar.setEnabled(true);
        this.m_grid.setEnabled(true);
    }

    public void setBusy() {
        this.lock();
        ((Component)this).setCursor(Cursor.getPredefinedCursor(3));
    }

    public void setIdle() {
        this.unlock();
        ((Component)this).setCursor(Cursor.getDefaultCursor());
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.goodbye();
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(ACTION_ABOUT)) {
            LEAboutDialog.Show(this);
            return;
        }
        if (string.equals(ACTION_CONNECT)) {
            LEConnectDialog.Show(this, this);
            return;
        }
        if (string.equals(ACTION_DISCONNECT)) {
            this.m_grid.deleteSelectedPMs();
            return;
        }
        if (string.equals(ACTION_EXIT)) {
            this.goodbye();
            return;
        }
        if (string.equals(ACTION_HELP_CONTENTS)) {
            if (this.m_help != null) {
                this.m_help.showContents();
                return;
            }
        } else if (string.equals(ACTION_HELP_CURRENT)) {
            if (this.m_help != null) {
                String string2 = this.getHelpTopic();
                try {
                    if (string2 == null) {
                        this.m_help.showContents();
                        return;
                    }
                    this.m_help.showTopic(this.m_book, string2);
                    return;
                }
                catch (Exception exception) {
                    String string3 = string2 == null ? "Error in help subsystem" : "No help found for topic: " + string2;
                    new LEErrorDialog((Frame)this, string3);
                    return;
                }
            }
        } else if (string.equals(ACTION_HELP_SEARCH)) {
            if (this.m_help != null) {
                this.m_help.showSearch();
                return;
            }
        } else {
            if (string.equals(ACTION_REBOOT)) {
                this.m_grid.rebootSelectedPMs();
                return;
            }
            if (string.equals(ACTION_RECONNECT)) {
                this.m_grid.reconnectSelectedPMs();
                return;
            }
            if (string.equals(ACTION_REMOVE)) {
                this.m_grid.removeSelectedPMs();
                return;
            }
            if (string.equals(ACTION_UPDATE_START)) {
                this.actionUpdateStart();
                return;
            }
            if (string.equals(ACTION_UPDATE_END)) {
                this.actionUpdateEnd();
                return;
            }
            if (string.startsWith(ACTION_SUBWINDOW)) {
                try {
                    int n = Integer.parseInt(string.substring(3));
                    Frame frame = (Frame)this.m_subwins.elementAt(n);
                    frame.toFront();
                    return;
                }
                catch (Exception exception) {
                    LEDebug.getLog().logln(20, exception);
                    return;
                }
            }
            LEDebug.getLog().logln(20, "Unknown LEConsole Action: " + string);
        }
    }

    public void loginTo(String string, String string2, String string3) {
        Object object;
        if (this.m_grid != null && (object = this.m_grid.getPortMaster(string)) != null) {
            if (((LEPortMaster)object).isConnected()) {
                String string4 = String.valueOf(LEAppInfo.getAppName()) + " is already connected to " + string;
                new LEErrorDialog((Frame)this, string4);
                string = null;
            } else if (string2.equals(((LEPortMaster)object).getUsername()) && string3.equals(((LEPortMaster)object).getPassword())) {
                new LEReconnectThread((LEPortMaster)object);
                string = null;
            } else {
                this.m_grid.removePM((LEPortMaster)object);
            }
        }
        if (string != null) {
            this.m_hostname = string;
            this.m_password = string3;
            this.m_username = string2;
            object = new LEActionDialog((Frame)this, "Connecting", this, LEStatusManager.GetManager());
            new Thread((Runnable)object).start();
            ((Component)object).setVisible(true);
        }
    }

    public void actionStart(LEActionDialog lEActionDialog) {
        this.setBusy();
        try {
            LEStatusBar lEStatusBar = lEActionDialog.getStatusBar();
            lEStatusBar.setStatusText("Connecting to " + this.m_hostname + "...");
            this.m_pm = new LEPortMaster(this.m_hostname, this.m_username, this.m_password);
            if (this.m_hostname == null) {
                this.m_pm.disconnect();
                this.m_pm = null;
                return;
            }
            LEDSSPortMaster lEDSSPortMaster = this.m_pm.getDSS();
            if (lEDSSPortMaster == null || !lEDSSPortMaster.isConnected()) {
                new LEErrorDialog((Frame)this, new String("Failed to connect to " + this.m_hostname));
                this.m_pm = null;
            }
            return;
        }
        catch (LEDSSPMAuthFailureException lEDSSPMAuthFailureException) {
            this.m_pm = null;
            new LEErrorDialog((Frame)this, new String("Invalid password!"));
            return;
        }
        catch (Exception exception) {
            this.m_pm = null;
            LEDebug.getLog().logln(20, exception);
            if (this.m_hostname != null) {
                new LEErrorDialog((Frame)this, exception.getMessage());
            }
            return;
        }
    }

    public void actionDone(LEActionDialog lEActionDialog) {
        if (this.m_pm != null) {
            this.m_grid.addPortMaster(this.m_hostname, this.m_pm);
        }
        this.m_statusbar.setStatusText("");
        this.actionCancel(lEActionDialog);
    }

    public synchronized void actionCancel(LEActionDialog lEActionDialog) {
        this.m_pm = null;
        this.m_hostname = null;
        this.m_password = null;
        this.setIdle();
    }

    public void onLETreeEvent(LETreeEvent lETreeEvent) {
        if (lETreeEvent.m_id == 1) {
            this.m_pathBar.setPath(this.m_tree);
            this.updateView();
        }
    }

    public void onLEMLEvent(LEMLEvent lEMLEvent) {
        if (lEMLEvent.getType() == 3) {
            this.m_selPMs = this.m_grid.getSelectedPMs();
            if (this.m_selPMs.length > 0) {
                this.m_disconn.setEnabled(true);
                this.m_remove.setEnabled(true);
                this.m_reboot.setEnabled(true);
                this.m_recon.setEnabled(true);
            } else {
                this.m_disconn.setEnabled(false);
                this.m_remove.setEnabled(false);
                this.m_reboot.setEnabled(false);
                this.m_recon.setEnabled(false);
            }
            this.updateSelection();
        }
    }

    public void onLEPathEvent(LEPathEvent lEPathEvent) {
        LETreeItem lETreeItem = (LETreeItem)lEPathEvent.getItem().getData();
        this.m_tree.select(lETreeItem, true);
    }

    public void onLEViewEvent(LEViewEvent lEViewEvent) {
        Frame frame;
        int n = lEViewEvent.getId();
        if (n == 1) {
            LEConfig lEConfig = lEViewEvent.getConfig();
            String string = (String)lEViewEvent.getData();
            this.m_tree.selectChild(lEConfig, string, string, true);
            return;
        }
        if (n == 2) {
            this.m_tree.selectParent((String)lEViewEvent.getData(), true);
            return;
        }
        if (n == 3) {
            this.m_tree.selectItem((LEVector)lEViewEvent.getData(), true);
            return;
        }
        if (n == 8) {
            this.lock();
            return;
        }
        if (n == 9) {
            this.unlock();
            return;
        }
        if (n == 10) {
            Frame frame2 = (Frame)lEViewEvent.getData();
            this.m_subwins.addElement(frame2);
            this.fillWindowsMenu();
            return;
        }
        if (n == 11 && this.m_subwins.removeElement(frame = (Frame)lEViewEvent.getData())) {
            this.fillWindowsMenu();
        }
    }

    public void updateSelection() {
        if (this.m_view != null) {
            this.setBusy();
            try {
                this.m_statusbar.setStatusText("Building display...");
                this.m_view.setSelection(this.m_selPMs);
            }
            catch (Exception exception) {
                LEDebug.getLog().logln(20, exception);
            }
            this.m_statusbar.setStatusText(null);
            this.setIdle();
            return;
        }
        this.updateView();
    }

    public void updateView() {
        try {
            ActionEvent actionEvent = new ActionEvent(this.m_dummy, 1001, ACTION_UPDATE_START);
            Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(actionEvent);
            return;
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
            this.actionUpdateStart();
            return;
        }
    }

    public void actionUpdateStart() {
        block9: {
            this.setBusy();
            try {
                Thread.currentThread();
                Thread.yield();
                if (this.m_view != null) {
                    this.m_view.deleteListener(this);
                    try {
                        this.m_view.going();
                    }
                    catch (Exception exception) {
                        LEDebug.getLog().logln(20, exception);
                    }
                }
                if (this.m_workMain != null) {
                    this.m_workMain.setVisible(false);
                    this.m_work.remove(this.m_workMain);
                    this.m_workMain = null;
                }
                if (this.m_workBottom != null) {
                    this.m_workBottom.setVisible(false);
                    this.m_work.remove(this.m_workBottom);
                    this.m_workBottom = null;
                }
                if (this.m_view == null) break block9;
                try {
                    this.m_view.gone();
                }
                catch (Exception exception) {
                    LEDebug.getLog().logln(20, exception);
                }
                this.m_view = null;
                LEClipboard.GetClipboard().reset();
            }
            catch (Exception exception) {
                LEDebug.getLog().logln(20, exception);
                this.m_view = null;
            }
        }
        Thread thread = new Thread(this);
        thread.setName("Console Update");
        thread.start();
    }

    public void run() {
        try {
            this.m_view = LEViewFactory.GetView(this.m_tree, this.m_selPMs);
            ActionEvent actionEvent = new ActionEvent(this.m_dummy, 1001, ACTION_UPDATE_END);
            Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(actionEvent);
            return;
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
            this.actionUpdateEnd();
            return;
        }
    }

    public void actionUpdateEnd() {
        try {
            Thread.currentThread();
            Thread.yield();
            if (this.m_view != null) {
                Component component;
                this.m_view.addListener(this);
                this.m_workMain = this.m_view.getMainPanel();
                if (this.m_workMain != null) {
                    this.m_work.add("Center", this.m_workMain);
                }
                if ((component = this.m_view.getBottomPanel()) != null) {
                    this.m_workBottom = new Panel();
                    this.m_workBottom.setLayout(new BorderLayout(5, 5));
                    this.m_workBottom.add("North", new LETitleBar());
                    this.m_workBottom.add("Center", component);
                    this.m_work.add("South", this.m_workBottom);
                }
            }
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
        }
        this.m_work.invalidate();
        this.m_work.validate();
        this.m_statusbar.setStatusText(null);
        this.setIdle();
    }

    String getHelpTopic() {
        String string = null;
        String string2 = null;
        LETreeItem lETreeItem = this.m_tree.getSelectedItem();
        while (lETreeItem != null) {
            String string3 = lETreeItem.m_label;
            if (string3.equals("Boards")) {
                if (string2 == null) {
                    string = "Configure_Boards";
                } else if (string2.equals("Lines")) {
                    string = "Configure_Boards_Lines";
                } else if (string2.equals("Ethernets")) {
                    string = "Configure_Boards_Ethernets";
                } else if (string2.equals("Ports")) {
                    string = "Configure_Boards_Ports";
                } else if (string2.equals("Async Ports")) {
                    string = "Configure_Boards_Async_Ports";
                } else if (string2.equals("ISDN Ports")) {
                    string = "Configure_Boards_ISDN_Ports";
                } else if (string2.equals("Parallel Ports")) {
                    string = "Configure_Boards_Parallel_Ports";
                } else if (string2.equals("Modems")) {
                    string = "Configure_Boards_Modems";
                }
            } else if (string3.equals("Lines")) {
                string2 = string3;
            } else if (string3.equals("Groups")) {
                string = "Configure_Boards_Lines_Groups";
            } else if (string3.equals("Ethernets")) {
                string2 = string3;
            } else if (string3.equals("Ports") && string2 == null) {
                string2 = string3;
            } else if (string3.equals("Async Ports")) {
                string2 = string3;
            } else if (string3.equals("ISDN Ports")) {
                string2 = string3;
            } else if (string3.equals("Parallel Ports")) {
                string2 = string3;
            } else if (string3.equals("Sync Ports")) {
                string = "Configure_Ports_Sync";
            } else if (string3.equals("Modems")) {
                string2 = string3;
            } else if (string3.equals("Global")) {
                string = "Configure_Global";
            } else if (string3.equals("Modems")) {
                string = "Configure_Modems";
            } else if (string3.equals("RADIUS")) {
                string = "Configure_RADIUS";
            } else if (string3.equals("ChoiceNet")) {
                string = "Configure_ChoiceNet";
            } else if (string3.equals("SNMP")) {
                string = "Configure_SNMP";
            } else if (string3.equals("OSPF")) {
                string = "Configure_OSPF";
            } else if (string3.equals("OSPF Areas")) {
                string = "Configure_OSPF_Areas";
            } else if (string3.equals("BGP")) {
                string = "Configure_BGP";
            } else if (string3.equals("BGP Peers")) {
                string = "Configure_BGP_Peers";
            } else if (string3.equals("Locations")) {
                string = "Configure_Locations";
            } else if (string3.equals("Users")) {
                string = "Configure_Users_Panel";
            } else if (string3.equals("Filters")) {
                string = "Configure_Filters_Panel";
            } else if (string3.equals("Routes")) {
                string = "Configure_Routes";
            } else if (string3.equals("Hosts")) {
                string = "Configure_Hosts";
            } else if (string3.equals("Syslog")) {
                string = "Configure_Syslog";
            } else if (string3.equals("SubInterfaces")) {
                string = "Configure_Subinterfaces";
            } else if (string3.equals("NAT Maps")) {
                string = "Configure_Nat_Map";
            } else if (string3.equals("Monitor")) {
                if (string2 == null) {
                    string = "Monitor_Panel";
                } else if (string2.equals("Lines")) {
                    string = "Monitor_Lines";
                }
            } else if (string3.equals("Graph")) {
                if (string2 == null) {
                    string = "Graph_Panel";
                } else if (string2.equals("Modems")) {
                    string = "Modems";
                }
            } else if (string3.equals("Chassis")) {
                string = "Chassis";
            } else if (string3.equals("Modem Summary")) {
                string = "Modem_Summary";
            } else if (string3.equals("Modem Details")) {
                string = "Modem_Details";
            } else if (string3.equals("Session Summary")) {
                string = "Session_Summary";
            } else if (string3.equals("Session Details")) {
                string = "Session_Details";
            } else if (string3.equals("Interfaces")) {
                string = "Monitor_Interfaces";
            } else if (string3.equals("Sessions")) {
                string = "Sessions";
            } else if (string3.equals("Diagnose")) {
                string = "Diagonse_Panel";
            } else if (string3.equals("Debug")) {
                string = "Debug";
            } else if (string3.equals("Maintain")) {
                string = "Maintain_Panel";
            } else if (string3.equals("Back Up")) {
                string = "Maintain_Backup";
            } else if (string3.equals("Restore")) {
                string = "Maintain_Restore";
            } else if (string3.equals("Upgrade")) {
                string = "Maintain_Upgrade";
            } else if (string3.equals("Command")) {
                string = "Command_Panel";
            } else if (string3.equals("Configure")) {
                if (string2 == null) {
                    string = "Configure_Panel";
                } else if (string2.equals("Lines")) {
                    string = "Configure_ISDN_PRI_Lines";
                } else if (string2.equals("Ethernets")) {
                    string = "Configure_Ethernets";
                } else if (string2.equals("Ports")) {
                    string = "Configure_Ports_Panel";
                } else if (string2.equals("Async Ports")) {
                    string = "Configure_Ports_Async";
                } else if (string2.equals("ISDN Ports")) {
                    string = "Configure_Ports_ISDN";
                } else if (string2.equals("Parallel Ports")) {
                    string = "Configure_Ports_Parallel";
                } else if (string2.equals("Modems")) {
                    string = "Configure_Modems";
                }
            }
            lETreeItem = string == null ? lETreeItem.m_parent : null;
        }
        return string;
    }

    MenuBar createMenuBar() {
        MenuBar menuBar = new MenuBar();
        Menu menu = new Menu("File");
        MenuItem menuItem = new MenuItem("Exit");
        menuItem.setActionCommand(ACTION_EXIT);
        menu.add(menuItem);
        menuItem.addActionListener(this);
        menuBar.add(menu);
        Menu menu2 = new Menu("Edit");
        MenuItem menuItem2 = new MenuItem("Cut");
        MenuItem menuItem3 = new MenuItem("Copy");
        MenuItem menuItem4 = new MenuItem("Paste");
        MenuItem menuItem5 = new MenuItem("Delete");
        menu2.add(menuItem2);
        menu2.add(menuItem3);
        menu2.add(menuItem4);
        menu2.add(menuItem5);
        this.m_cb = LEClipboard.GetClipboard();
        this.m_cb.setMenuItems(menuItem2, menuItem3, menuItem4, menuItem5);
        this.m_cb.reset();
        menuBar.add(menu2);
        menu = new Menu("PortMaster");
        menuItem = new MenuItem("Connect...");
        menu.add(menuItem);
        menuItem.setActionCommand(ACTION_CONNECT);
        menuItem.addActionListener(this);
        this.m_recon = new MenuItem("Reconnect");
        this.m_recon.setActionCommand(ACTION_RECONNECT);
        this.m_recon.setEnabled(false);
        this.m_recon.addActionListener(this);
        menu.add(this.m_recon);
        this.m_disconn = new MenuItem("Disconnect");
        this.m_disconn.setActionCommand(ACTION_DISCONNECT);
        this.m_disconn.setEnabled(false);
        this.m_disconn.addActionListener(this);
        menu.add(this.m_disconn);
        this.m_remove = new MenuItem("Remove");
        this.m_remove.setActionCommand(ACTION_REMOVE);
        this.m_remove.setEnabled(false);
        this.m_remove.addActionListener(this);
        menu.add(this.m_remove);
        menu.addSeparator();
        this.m_reboot = new MenuItem("Reboot");
        this.m_reboot.setActionCommand(ACTION_REBOOT);
        this.m_reboot.setEnabled(false);
        this.m_reboot.addActionListener(this);
        menu.add(this.m_reboot);
        menuBar.add(menu);
        this.m_windows = new Menu("Windows");
        menuBar.add(this.m_windows);
        menu = new Menu("Help");
        menuItem = new MenuItem("Help on Current Panel...");
        menu.add(menuItem);
        menuItem.setActionCommand(ACTION_HELP_CURRENT);
        menuItem.addActionListener(this);
        menuItem = new MenuItem("Help Contents...");
        menu.add(menuItem);
        menuItem.setActionCommand(ACTION_HELP_CONTENTS);
        menuItem.addActionListener(this);
        menuItem = new MenuItem("Search for Help on...");
        menu.add(menuItem);
        menuItem.setActionCommand(ACTION_HELP_SEARCH);
        menuItem.addActionListener(this);
        menu.addSeparator();
        menuItem = new MenuItem("About " + LEAppInfo.getAppName() + "...");
        menuItem.setActionCommand(ACTION_ABOUT);
        menuItem.addActionListener(this);
        menu.add(menuItem);
        menuBar.add(menu);
        return menuBar;
    }

    void loadProperties() {
        try {
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            String string = LEProperties.GetProperty(PROP_MAIN_X);
            if (string != null) {
                n = Integer.parseInt(string);
            }
            if ((string = LEProperties.GetProperty(PROP_MAIN_Y)) != null) {
                n2 = Integer.parseInt(string);
            }
            if ((string = LEProperties.GetProperty(PROP_MAIN_W)) != null) {
                n3 = Integer.parseInt(string);
            }
            if ((string = LEProperties.GetProperty(PROP_MAIN_H)) != null) {
                n4 = Integer.parseInt(string);
            }
            this.m_bounds = new Rectangle(n, n2, n3, n4);
            string = LEProperties.GetProperty(PROP_TREE_W);
            if (string != null) {
                this.m_treeWidth = Integer.parseInt(string);
            }
            if ((string = LEProperties.GetProperty(PROP_GRID_H)) != null) {
                this.m_gridHeight = Integer.parseInt(string);
                return;
            }
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
        }
    }

    void saveProperties() {
        Rectangle rectangle = this.getBounds();
        LEProperties.SetProperty(PROP_MAIN_X, Integer.toString(rectangle.x));
        LEProperties.SetProperty(PROP_MAIN_Y, Integer.toString(rectangle.y));
        LEProperties.SetProperty(PROP_MAIN_W, Integer.toString(rectangle.width));
        if (LEAppInfo.isUnix()) {
            LEProperties.SetProperty(PROP_MAIN_H, Integer.toString(rectangle.height));
        } else {
            LEProperties.SetProperty(PROP_MAIN_H, Integer.toString(rectangle.height + 19));
        }
        Dimension dimension = this.m_treePanel.getSize();
        if (dimension.width < 0) {
            LEProperties.SetProperty(PROP_TREE_W, "0");
        } else {
            LEProperties.SetProperty(PROP_TREE_W, Integer.toString(dimension.width));
        }
        dimension = this.m_grid.getSize();
        if (dimension.height < 0) {
            LEProperties.SetProperty(PROP_GRID_H, "0");
        } else {
            LEProperties.SetProperty(PROP_GRID_H, Integer.toString(dimension.height));
        }
        LEProperties.SaveProperties();
    }

    void goodbye() {
        this.saveProperties();
        this.m_grid.shutdown();
        ((Component)this).setVisible(false);
        System.exit(0);
    }

    void fillWindowsMenu() {
        this.m_windows.removeAll();
        int n = this.m_subwins.size();
        int n2 = 0;
        while (n2 < n) {
            Frame frame = (Frame)this.m_subwins.elementAt(n2);
            MenuItem menuItem = new MenuItem(frame.getTitle());
            menuItem.setActionCommand(ACTION_SUBWINDOW + n2);
            menuItem.addActionListener(this);
            this.m_windows.add(menuItem);
            ++n2;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

