/*
 * Decompiled with CFR 0.152.
 */
import COM.livingston.model.LEBoard;
import COM.livingston.model.LEBoards;
import COM.livingston.model.LEPortMaster;
import COM.livingston.util.LEVector;
import java.awt.BorderLayout;
import java.awt.Choice;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

public abstract class LEMonitorDetailPanel
extends LEMonitorPanel
implements ItemListener {
    Choice m_pm_choice;
    Choice m_brd_choice;
    Panel m_mainPanel;
    Panel m_selectionPanel;
    LEPortMaster m_selected_pm;
    String m_selected_brd;
    static String s_host = null;
    static String s_board = null;

    public static void Display(String string, String string2) {
        s_host = string;
        s_board = string2;
    }

    public void initialize(int n, int n2, int n3) {
        super.initialize(n, n2, n3);
        this.m_mainPanel = new Panel(new BorderLayout());
        this.m_selectionPanel = this.createSelectionPanel();
        this.m_mainPanel.add("North", this.m_selectionPanel);
        this.m_mainPanel.add("Center", this.m_scroll);
    }

    public synchronized void setSelection(LEPortMaster[] lEPortMasterArray) {
        this.m_pms = lEPortMasterArray;
        boolean bl = false;
        int n = 0;
        while (n < this.m_pms.length) {
            if (this.m_pms[n] == this.m_selected_pm) {
                bl = true;
            }
            ++n;
        }
        this.updatePMChoice(this.m_pms);
        if (!bl) {
            if (this.m_selected_pm != null) {
                this.stopMonitoring(this.m_selected_pm, this.m_selected_brd);
                this.m_selected_pm = null;
                this.m_selected_brd = null;
            }
            if (s_host != null) {
                int n2 = 0;
                while (n2 < this.m_pms.length) {
                    if (this.m_pms[n2].getHostname().equals(s_host)) {
                        this.m_selected_pm = this.m_pms[n2];
                    }
                    ++n2;
                }
            }
            if (this.m_selected_pm == null && this.m_pms.length > 0) {
                this.m_selected_pm = this.m_pms[0];
            }
            this.updateBoardChoice(this.m_selected_pm);
            if (s_board != null) {
                this.m_brd_choice.select(s_board);
            }
            this.m_selected_brd = this.m_brd_choice.getSelectedItem();
            if (this.m_selected_pm != null) {
                this.m_pm_choice.select(this.m_selected_pm.getHostname());
                this.startMonitoring(this.m_selected_pm, this.m_selected_brd);
            }
        }
        s_host = null;
        s_board = null;
        this.m_selectionPanel.invalidate();
        this.m_selectionPanel.validate();
    }

    public Component getMainPanel() {
        return this.m_mainPanel;
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        int n = this.m_pm_choice.getSelectedIndex();
        String string = this.m_brd_choice.getSelectedItem();
        LEPortMaster lEPortMaster = this.m_pms[n];
        if (lEPortMaster.getHardwareType().equals("PM-4")) {
            this.m_brd_choice.setEnabled(true);
        } else {
            this.m_brd_choice.setEnabled(false);
        }
        if (lEPortMaster != this.m_selected_pm) {
            if (this.m_selected_pm != null) {
                this.stopMonitoring(this.m_selected_pm, this.m_selected_brd);
            }
            this.m_selected_pm = lEPortMaster;
            this.updateBoardChoice(this.m_selected_pm);
            this.m_selected_brd = this.m_brd_choice.getSelectedItem();
            this.m_selectionPanel.invalidate();
            this.m_selectionPanel.validate();
            this.startMonitoring(this.m_selected_pm, this.m_selected_brd);
            return;
        }
        if (string != null && !string.equals(this.m_selected_brd)) {
            this.stopMonitoring(this.m_selected_pm, this.m_selected_brd);
            this.m_selected_brd = string;
            this.startMonitoring(this.m_selected_pm, this.m_selected_brd);
        }
    }

    private Panel createSelectionPanel() {
        Panel panel = new Panel();
        Label label = new Label("Board");
        Panel panel2 = new Panel(new FlowLayout(0));
        this.m_pm_choice = new Choice();
        this.m_pm_choice.addItemListener(this);
        this.m_brd_choice = new Choice();
        panel.add(this.m_pm_choice);
        panel2.add(label);
        panel2.add(this.m_brd_choice);
        panel.add(panel2);
        return panel;
    }

    private void updateBoardChoice(LEPortMaster lEPortMaster) {
        this.m_brd_choice.removeItemListener(this);
        this.m_brd_choice.removeAll();
        if (lEPortMaster == null) {
            return;
        }
        LEBoards lEBoards = (LEBoards)lEPortMaster.get("2555904");
        if (lEBoards != null) {
            LEVector lEVector = lEBoards.getKeys();
            int n = lEVector.size();
            String string = null;
            int n2 = 0;
            while (n2 < n) {
                LEBoard lEBoard = (LEBoard)lEBoards.get((String)lEVector.elementAt(n2));
                String string2 = (String)lEBoard.get(LEBoard.BOARD_TYPE);
                if (this.isValidBoardType(string2)) {
                    String string3 = (String)lEVector.elementAt(n2);
                    this.m_brd_choice.add(string3);
                    if (string == null) {
                        string = string3;
                    }
                }
                ++n2;
            }
            this.m_brd_choice.select(string);
        }
        this.m_brd_choice.addItemListener(this);
    }

    private void updatePMChoice(LEPortMaster[] lEPortMasterArray) {
        this.m_pm_choice.removeItemListener(this);
        this.m_pm_choice.removeAll();
        if (lEPortMasterArray.length == 0) {
            return;
        }
        int n = 0;
        while (n < lEPortMasterArray.length) {
            this.m_pm_choice.add(lEPortMasterArray[n].getHostname());
            ++n;
        }
        this.m_pm_choice.addItemListener(this);
    }

    void startMonitoring(LEPortMaster lEPortMaster) {
        this.startMonitoring(lEPortMaster, this.m_selected_brd);
    }

    void stopMonitoring(LEPortMaster lEPortMaster) {
        this.stopMonitoring(lEPortMaster, this.m_selected_brd);
    }

    abstract boolean isValidBoardType(String var1);
}

