/*
 * Decompiled with CFR 0.152.
 */
import COM.livingston.backend.LEDSSFlatFile;
import COM.livingston.backend.LEPMCommand;
import COM.livingston.forms.LERebootDialog;
import COM.livingston.model.LEPortMaster;
import COM.livingston.ui.LEBorderPanel;
import COM.livingston.ui.LEColor;
import COM.livingston.ui.LEConfirmClient;
import COM.livingston.ui.LEConfirmDialog;
import COM.livingston.ui.LEErrorDialog;
import COM.livingston.ui.LEFont;
import COM.livingston.ui.LETextArea;
import COM.livingston.ui.LETextField;
import COM.livingston.ui.LEUiUtils;
import COM.livingston.util.LEAppInfo;
import COM.livingston.util.LEDebug;
import COM.livingston.util.LEStatusManager;
import COM.livingston.util.LEVector;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;

public class LERestoreView
extends LEBorderPanel
implements LEView,
LEConfirmClient,
Runnable,
ActionListener {
    public static final String NEWLINE = new String("\n");
    public static final String SUCCESS = new String("Command succeded");
    public static final String FAILURE = new String("Command failed");
    public static final String NOSAVE = new String("Save disabled");
    static Insets s_defInsets = new Insets(3, 5, 3, 5);
    Label m_boxes;
    Button m_restore;
    Button m_cancel;
    Button m_browse;
    Button m_logBrowse;
    TextField m_path;
    TextField m_logPath;
    LETextArea m_log;
    Panel m_buttons;
    LEVector m_pms;
    File m_file;
    PrintWriter m_prw;
    LEViewListener m_listener;
    boolean m_cancelFlag;
    LERebootDialog m_rebootdlg;

    public LERestoreView() {
        this.setInsets(5, 5, 5, 5);
        this.setLayout(new BorderLayout(0, 0));
        Panel panel = new Panel();
        this.createMain(panel);
        this.add("Center", panel);
    }

    public void setSelection(LEPortMaster[] lEPortMasterArray) {
        this.m_pms = new LEVector();
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < lEPortMasterArray.length) {
            if (n > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(lEPortMasterArray[n].getHostname());
            this.m_pms.addElement(lEPortMasterArray[n]);
            ++n;
        }
        this.m_boxes.setText(new String(stringBuffer));
    }

    public Component getMainPanel() {
        return this;
    }

    public Component getBottomPanel() {
        if (this.m_buttons == null) {
            this.m_buttons = new Panel();
            this.m_buttons.setLayout(new FlowLayout(1));
            Panel panel = new Panel();
            panel.setLayout(new GridLayout(1, 2, 10, 10));
            this.m_restore = new Button("Restore");
            panel.add(this.m_restore);
            this.m_restore.addActionListener(this);
            this.m_cancel = new Button("Cancel");
            panel.add(this.m_cancel);
            this.m_cancel.addActionListener(this);
            this.m_cancel.setEnabled(false);
            this.m_buttons.add(panel);
        }
        return this.m_buttons;
    }

    public void going() {
    }

    public void gone() {
        if (this.m_prw != null) {
            this.m_prw.close();
        }
        this.m_file = null;
        this.m_prw = null;
    }

    public void addListener(LEViewListener lEViewListener) {
        this.m_listener = lEViewListener;
    }

    public void deleteListener(LEViewListener lEViewListener) {
        if (this.m_listener == lEViewListener) {
            this.m_listener = null;
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.m_cancel) {
            this.m_cancelFlag = true;
            this.m_cancel.setEnabled(false);
            return;
        }
        if (object == this.m_restore) {
            if (LEAppInfo.DemoMode()) {
                new LEErrorDialog(LEUiUtils.GetBaseFrame(), "This feature is disabled in demo mode.");
                return;
            }
            this.confirmLogFile();
            return;
        }
        if (object == this.m_browse) {
            this.browse("Restore Configuration", this.m_path);
            return;
        }
        if (object == this.m_logBrowse) {
            this.browse("Restore Log File", this.m_logPath);
        }
    }

    public void confirmAction(String string, Object object) {
        if (string.equals(LEConfirmDialog.YES)) {
            this.setLogFile((File)object);
            return;
        }
        this.cancelAction(object);
    }

    public void cancelAction(Object object) {
        this.m_file = null;
        this.m_prw = null;
        ((TextComponent)this.m_logPath).setText("");
    }

    public void run() {
        try {
            this.m_cancelFlag = false;
            String string = this.m_path.getText();
            File file = new File(string);
            LEDSSFlatFile lEDSSFlatFile = new LEDSSFlatFile(string, 0);
            lEDSSFlatFile.connect();
            LEStatusManager.SetStatus("Loading commands from " + file.getAbsolutePath());
            LEVector lEVector = lEDSSFlatFile.getCommands();
            String string2 = (String)lEVector.elementAt(lEVector.size() - 1);
            if (!string2.equals("save all")) {
                lEVector.addElement("save all");
            }
            this.m_rebootdlg = null;
            if (this.needsReboot(lEVector)) {
                String[] stringArray = new String[]{"Restoring from this file requires a rebooting of the PortMaster.", "Choosing not to reboot may cause some commands to fail."};
                this.m_rebootdlg = new LERebootDialog(LEUiUtils.getFrame(this), stringArray, true);
            }
            if (!(this.m_cancelFlag || this.m_rebootdlg != null && this.m_rebootdlg.isCanceled())) {
                int n = this.m_pms.size();
                int n2 = 0;
                while (n2 < n) {
                    this.restorePM((LEPortMaster)this.m_pms.elementAt(n2), string, lEVector);
                    ++n2;
                }
            }
            lEDSSFlatFile.disconnect();
        }
        catch (IOException iOException) {
            LEDebug.getLog().logln(20, iOException);
            new LEErrorDialog(LEUiUtils.getFrame(this), iOException.getMessage());
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
        }
        LEStatusManager.StatusComplete();
        this.unlock();
    }

    void lock() {
        this.m_restore.setEnabled(false);
        this.m_cancel.setEnabled(true);
        this.m_browse.setEnabled(false);
        this.m_logBrowse.setEnabled(false);
        this.m_path.setEnabled(false);
        this.m_logPath.setEnabled(false);
        if (this.m_listener != null) {
            this.m_listener.onLEViewEvent(new LEViewEvent(8, null));
        }
    }

    void unlock() {
        if (this.m_listener != null) {
            this.m_listener.onLEViewEvent(new LEViewEvent(9, null));
        }
        this.m_restore.setEnabled(true);
        this.m_cancel.setEnabled(false);
        this.m_browse.setEnabled(true);
        this.m_logBrowse.setEnabled(true);
        this.m_path.setEnabled(true);
        this.m_logPath.setEnabled(true);
    }

    void restore() {
        if (this.m_pms.size() == 0) {
            return;
        }
        String string = this.m_path.getText();
        if (string == null || string.length() < 1) {
            new LEErrorDialog(LEUiUtils.getFrame(this), "A file must be specified!");
            return;
        }
        File file = new File(string);
        if (!file.exists()) {
            new LEErrorDialog(LEUiUtils.getFrame(this), String.valueOf(file.getAbsolutePath()) + " does not exist!");
            return;
        }
        this.lock();
        new Thread(this).start();
    }

    void restorePM(LEPortMaster lEPortMaster, String string, LEVector lEVector) {
        block11: {
            String string2 = "Restoring to " + lEPortMaster.getHostname() + " from " + string;
            LEStatusManager.SetStatus(string2);
            this.m_log.append(string2);
            this.m_log.append(NEWLINE);
            this.m_log.append(NEWLINE);
            if (this.m_prw != null) {
                this.m_prw.println(string2);
                this.m_prw.println();
            }
            try {
                int n = lEVector.size();
                int n2 = 0;
                while (!this.m_cancelFlag && n2 < n) {
                    String string3 = (String)lEVector.elementAt(n2);
                    if (!LEPMCommand.IsReboot(string3) || this.m_rebootdlg == null || this.m_rebootdlg.shouldReboot()) {
                        this.m_log.append(string3);
                        this.m_log.append(NEWLINE);
                        if (this.m_prw != null) {
                            this.m_prw.println(string3);
                        }
                        if (string3.length() > 0 && string3.charAt(0) != '#') {
                            String string4;
                            LEPMCommand lEPMCommand = lEPortMaster.execute(string3);
                            String string5 = lEPMCommand != null ? ((string4 = lEPMCommand.getResult()).length() > 0 ? string4 : (lEPMCommand.getStatus() ? SUCCESS : FAILURE)) : FAILURE;
                            this.m_log.append(string5);
                            this.m_log.append(NEWLINE);
                            if (this.m_prw != null) {
                                this.m_prw.println(string5);
                            }
                        }
                    }
                    ++n2;
                }
                if (this.m_cancelFlag) {
                    this.m_log.append(NEWLINE);
                    this.m_log.append("Restore canceled");
                    this.m_log.append(NEWLINE);
                    if (this.m_prw != null) {
                        this.m_prw.println();
                        this.m_prw.println("Restore canceled");
                    }
                }
                lEPortMaster.purgeCache();
            }
            catch (Exception exception) {
                this.m_log.append(exception.getMessage());
                if (this.m_prw == null) break block11;
                this.m_prw.println(exception.getMessage());
            }
        }
        this.m_log.append(NEWLINE);
        if (this.m_prw != null) {
            this.m_prw.println();
        }
    }

    void browse(String string, TextField textField) {
        FileDialog fileDialog = new FileDialog(LEUiUtils.getFrame(this), string, 0);
        String string2 = LEAppInfo.getLastDirectory();
        if (string2 != null) {
            fileDialog.setDirectory(string2);
        }
        fileDialog.show();
        string2 = fileDialog.getDirectory();
        String string3 = fileDialog.getFile();
        if (string3 != null) {
            String string4 = LEAppInfo.createFullPath(string2, string3);
            ((TextComponent)textField).setText(string4);
            LEAppInfo.setLastDirectory(string2);
        }
    }

    void createMain(Panel panel) {
        GridBagLayout gridBagLayout = new GridBagLayout();
        panel.setLayout(gridBagLayout);
        Font font = LEFont.getBoldFont();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = s_defInsets;
        Label label = new Label("PortMaster(s):");
        label.setFont(font);
        panel.add(label);
        gridBagLayout.setConstraints(label, gridBagConstraints);
        label = this.m_boxes = new Label();
        panel.add(label);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        label = new Label("Restore from File:");
        label.setFont(font);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.fill = 0;
        panel.add(label);
        gridBagLayout.setConstraints(label, gridBagConstraints);
        Panel panel2 = new Panel();
        panel2.setLayout(new BorderLayout(5, 5));
        this.m_path = new TextField();
        panel2.add("Center", this.m_path);
        ((Component)this.m_path).setBackground(LEColor.getTextBackground());
        this.m_browse = new Button("Browse...");
        panel2.add("East", this.m_browse);
        this.m_browse.addActionListener(this);
        ++gridBagConstraints.gridx;
        gridBagConstraints.fill = 2;
        panel.add(panel2);
        gridBagLayout.setConstraints(panel2, gridBagConstraints);
        label = new Label("Log to File: ");
        label.setFont(font);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.fill = 0;
        panel.add(label);
        gridBagLayout.setConstraints(label, gridBagConstraints);
        panel2 = new Panel();
        panel2.setLayout(new BorderLayout(5, 5));
        this.m_logPath = new LETextField();
        panel2.add("Center", this.m_logPath);
        this.m_logBrowse = new Button("Browse...");
        panel2.add("East", this.m_logBrowse);
        this.m_logBrowse.addActionListener(this);
        ++gridBagConstraints.gridx;
        gridBagConstraints.fill = 2;
        panel.add(panel2);
        gridBagLayout.setConstraints(panel2, gridBagConstraints);
        label = new Label("Restore Log:");
        label.setFont(font);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.fill = 0;
        panel.add(label);
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.m_log = new LETextArea();
        this.m_log.setEditable(false);
        ++gridBagConstraints.gridx;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        panel.add(this.m_log);
        gridBagLayout.setConstraints(this.m_log, gridBagConstraints);
    }

    void confirmLogFile() {
        String string = this.m_logPath.getText();
        if (string.length() == 0) {
            if (this.m_prw != null) {
                this.m_prw.close();
            }
            this.m_file = null;
            this.m_prw = null;
            this.restore();
            return;
        }
        File file = new File(string);
        if (this.m_file == null || !file.getAbsolutePath().equals(this.m_file.getAbsolutePath())) {
            if (file.exists()) {
                String[] stringArray = new String[]{LEConfirmDialog.YES, LEConfirmDialog.NO};
                LEConfirmDialog lEConfirmDialog = new LEConfirmDialog(LEUiUtils.getFrame(this), (LEConfirmClient)this, String.valueOf(file.getAbsolutePath()) + " already exists. Overwrite it?", stringArray, (Object)file);
                ((Component)lEConfirmDialog).setVisible(true);
                return;
            }
            this.setLogFile(file);
            return;
        }
        this.restore();
    }

    void setLogFile(File file) {
        this.m_file = file;
        ((TextComponent)this.m_logPath).setText(this.m_file.getAbsolutePath());
        if (this.m_prw != null) {
            this.m_prw.close();
        }
        try {
            FileWriter fileWriter = new FileWriter(this.m_file);
            this.m_prw = new PrintWriter((Writer)fileWriter, true);
            this.restore();
            return;
        }
        catch (IOException iOException) {
            this.m_file = null;
            this.m_prw = null;
            ((TextComponent)this.m_logPath).setText("");
            LEDebug.getLog().logln(20, iOException);
            new LEErrorDialog(LEUiUtils.getFrame(this), iOException.getMessage());
            return;
        }
    }

    boolean needsReboot(LEVector lEVector) {
        int n = lEVector.size();
        int n2 = 0;
        while (n2 < n) {
            String string = (String)lEVector.elementAt(n2);
            if (LEPMCommand.IsReboot(string)) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

