/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.backend;

import COM.livingston.amf.LEAMFactory;
import COM.livingston.backend.LEEntityFactory;
import COM.livingston.backend.LEEntityMessage;
import COM.livingston.backend.LEMemorySummaryMessage;
import COM.livingston.backend.LEModemSummaryMessage;
import COM.livingston.backend.LEMonEnvMessage;
import COM.livingston.backend.LEMonIfacesMessage;
import COM.livingston.backend.LEMonL2TPSessionMessage;
import COM.livingston.backend.LEMonL2TPTunnelMessage;
import COM.livingston.backend.LEMonLinesMessage;
import COM.livingston.backend.LEMonModemsMessage;
import COM.livingston.backend.LEMonNATSessMessage;
import COM.livingston.backend.LEMonNATStatsMessage;
import COM.livingston.backend.LEMonSessionsMessage;
import COM.livingston.backend.LEMonSyslogMessage;
import COM.livingston.backend.LEOSPFLinkMessage;
import COM.livingston.backend.LEOSPFNeighborMessage;
import COM.livingston.backend.LESessionSummaryMessage;

public class LEMonitorFactory
extends LEEntityFactory {
    public static final String MONITOR = "MONITOR";
    static LEMonitorFactory s_factory = null;

    public static LEAMFactory GetFactory() {
        if (s_factory == null) {
            s_factory = new LEMonitorFactory();
        }
        return s_factory;
    }

    public static void Register() {
        LEMonitorFactory.GetFactory();
    }

    LEMonitorFactory() {
        LEAMFactory.GetFactory().register(MONITOR, this);
    }

    LEEntityMessage createMessage(int request, int entity, String name) {
        LEEntityMessage msg = null;
        switch (entity) {
            case 0x120000: {
                msg = new LEMonIfacesMessage(request, name);
                break;
            }
            case 131072: {
                msg = new LEMonLinesMessage(request, name);
                break;
            }
            case 65536: {
                msg = new LEMonSessionsMessage(request, name);
                break;
            }
            case 327680: {
                msg = new LEMonSyslogMessage(request, name);
                break;
            }
            case 196608: {
                msg = new LEMonModemsMessage(request, name);
                break;
            }
            case 0x2C0000: {
                msg = new LEModemSummaryMessage(request, name);
                break;
            }
            case 0x2D0000: {
                msg = new LEMemorySummaryMessage(request, name);
                break;
            }
            case 0x2E0000: {
                msg = new LESessionSummaryMessage(request, name);
                break;
            }
            case 0x330000: {
                msg = new LEMonEnvMessage(request, name);
                break;
            }
            case 0x360000: {
                msg = new LEMonL2TPTunnelMessage(request, name);
                break;
            }
            case 0x370000: {
                msg = new LEMonL2TPSessionMessage(request, name);
                break;
            }
            case 0x2A0000: {
                msg = new LEMonNATSessMessage(request, name);
                break;
            }
            case 0x2B0000: {
                msg = new LEMonNATStatsMessage(request, name);
                break;
            }
            case 983040: {
                msg = new LEOSPFNeighborMessage(request, name);
                break;
            }
            case 0x340000: {
                msg = new LEOSPFLinkMessage(request, name);
                break;
            }
        }
        return msg;
    }
}

