/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.model;

import COM.livingston.amf.LEAMFactory;
import COM.livingston.amf.LEAMObserver;
import COM.livingston.backend.LEAlarmFactory;
import COM.livingston.backend.LEAlarmMessage;
import COM.livingston.backend.LEDSSException;
import COM.livingston.backend.LEDSSPortMaster;
import COM.livingston.backend.LEStatusFactory;
import COM.livingston.backend.LEStatusMessage;
import COM.livingston.model.LEPortMaster;
import COM.livingston.util.LEDebug;
import COM.livingston.util.LEVector;

public class LEAlarmFacility
implements LEAMObserver {
    LEPortMaster m_pm;
    LEVector m_alarms = new LEVector();
    long m_req;

    public LEAlarmFacility(LEPortMaster pm) {
        this.m_pm = pm;
        if (pm.isConnected()) {
            this.startAlarms();
        }
        String host = pm.getHostname();
        LEStatusFactory.GetFactory().addObserver(host, this);
    }

    public LEVector getAlarms() {
        return this.m_alarms;
    }

    public void shutdown() {
        this.stopAlarms();
    }

    public synchronized void update(LEAMFactory factory, String host, Object arg) {
        if (arg instanceof LEAlarmMessage) {
            this.updateAlarm((LEAlarmMessage)arg);
        } else if (arg instanceof LEStatusMessage) {
            this.updateStatus((LEStatusMessage)arg);
        }
    }

    void updateAlarm(LEAlarmMessage msg) {
        String id = msg.getName();
        int len = this.m_alarms.size();
        boolean found = false;
        int i = 0;
        while (!found && i < len) {
            LEAlarmMessage alarm = (LEAlarmMessage)this.m_alarms.elementAt(i);
            if (id.equals(alarm.getName())) {
                found = true;
                this.m_alarms.setElementAt(msg, i);
            }
            ++i;
        }
        if (!found) {
            this.m_alarms.addElement(msg);
        }
    }

    void updateStatus(LEStatusMessage msg) {
        switch (msg.getStatus()) {
            case 1: {
                if (this.m_req != 0L) break;
                this.startAlarms();
                break;
            }
            case 2: 
            case 4: {
                this.m_alarms.removeAllElements();
                this.m_req = 0L;
                break;
            }
        }
    }

    void startAlarms() {
        LEAlarmFactory.GetFactory().addObserver(this.m_pm.getHostname(), this);
        try {
            LEDSSPortMaster dss = this.m_pm.getDSS();
            this.m_req = dss.alarm(655360);
        }
        catch (LEDSSException lEDSSException) {
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
        }
    }

    void stopAlarms() {
        LEAlarmFactory.GetFactory().deleteObserver(this.m_pm.getHostname(), this);
        this.m_alarms.removeAllElements();
        try {
            LEDSSPortMaster dss = this.m_pm.getDSS();
            if (this.m_req > 0L) {
                dss.killAlarm(this.m_req);
            }
        }
        catch (LEDSSException lEDSSException) {
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
        }
    }
}

