/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.model;

import COM.livingston.backend.LEPMCommand;
import COM.livingston.model.LEConfig;
import COM.livingston.model.LEConfigFacility;
import COM.livingston.model.LEHost;
import COM.livingston.model.LEOrderedList;
import COM.livingston.util.LEVector;

public class LEHosts
extends LEOrderedList {
    public LEHosts(LEConfigFacility facility) {
        super(facility);
    }

    public Object clone() {
        LEHosts config = new LEHosts(this.m_facility);
        config.copy(this);
        return config;
    }

    public LEVector add(String ip, String host) {
        LEVector errors = null;
        StringBuffer buf = new StringBuffer("add ");
        buf.append("host ");
        buf.append(ip);
        buf.append(" ");
        buf.append(host);
        LEPMCommand ret = this.m_facility.execute(buf.toString());
        if (ret.getStatus()) {
            ret = this.m_facility.execute("save all");
            this.refresh();
        }
        if (!ret.getStatus()) {
            errors = new LEVector();
            errors.addElement(ret);
        }
        return errors;
    }

    public LEVector delete(String host) {
        LEVector errors = null;
        StringBuffer buf = new StringBuffer("delete ");
        buf.append("host ");
        buf.append(host);
        LEPMCommand ret = this.m_facility.execute(buf.toString());
        if (ret.getStatus()) {
            ret = this.m_facility.execute("save all");
            this.refresh();
        }
        if (!ret.getStatus()) {
            errors = new LEVector();
            errors.addElement(ret);
        }
        return errors;
    }

    LEConfig createConfig() {
        return new LEHost(this.m_facility);
    }

    boolean generateAddCommand(String key, LEVector cmds) {
        LEHost host = (LEHost)this.get(key);
        if (host == null) {
            return false;
        }
        String ip = (String)host.get("address");
        String name = (String)host.get("hostname");
        if (ip != null && ip.length() > 0 && name != null && name.length() > 0) {
            StringBuffer buf = new StringBuffer("add ");
            buf.append("host ");
            buf.append(ip);
            buf.append(" ");
            buf.append(name);
            cmds.addElement(buf.toString());
            return true;
        }
        return false;
    }

    boolean generateDeleteCommand(String key, LEVector cmds) {
        LEHost host = (LEHost)this.get(key);
        if (host == null) {
            return false;
        }
        String name = (String)host.get("hostname");
        if (name != null && name.length() > 0) {
            StringBuffer buf = new StringBuffer("delete ");
            buf.append("host ");
            buf.append(name);
            cmds.addElement(buf.toString());
            return true;
        }
        return false;
    }
}

