/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.model;

import COM.livingston.model.LEDBLoginUser;
import COM.livingston.model.LEDBLoginUsers;
import COM.livingston.model.LEDBNetUser;
import COM.livingston.model.LEDBNetUsers;
import COM.livingston.model.LELoginUser;
import COM.livingston.model.LELoginUsers;
import COM.livingston.model.LENetUser;
import COM.livingston.model.LENetUsers;
import COM.livingston.model.LEUsers;
import COM.livingston.util.LEVector;
import java.io.PrintWriter;

public class LERadiusConverter {
    boolean m_password;
    String m_hostname;

    public LERadiusConverter() {
        this("", false);
    }

    public LERadiusConverter(String hostname, boolean password) {
        this.m_hostname = hostname;
        this.m_password = password;
    }

    public void writeUsers(LEUsers users, PrintWriter pw) {
        LELoginUsers loginusers = (LELoginUsers)users.get("user");
        LEVector keys = loginusers.getKeys();
        int len = keys.size();
        int i = 0;
        while (i < len) {
            LELoginUser loginuser = (LELoginUser)loginusers.get((String)keys.elementAt(i));
            this.writeUser(loginuser, pw);
            ++i;
        }
        LEDBLoginUsers dbloginusers = (LEDBLoginUsers)users.get("logindialback");
        keys = dbloginusers.getKeys();
        len = keys.size();
        int i2 = 0;
        while (i2 < len) {
            LEDBLoginUser dbloginuser = (LEDBLoginUser)dbloginusers.get((String)keys.elementAt(i2));
            this.writeUser(dbloginuser, pw);
            ++i2;
        }
        LENetUsers netusers = (LENetUsers)users.get("netuser");
        keys = netusers.getKeys();
        len = keys.size();
        int i3 = 0;
        while (i3 < len) {
            LENetUser netuser = (LENetUser)netusers.get((String)keys.elementAt(i3));
            this.writeUser(netuser, pw);
            ++i3;
        }
        LEDBNetUsers dbnetusers = (LEDBNetUsers)users.get("netdialback");
        keys = dbnetusers.getKeys();
        len = keys.size();
        int i4 = 0;
        while (i4 < len) {
            LEDBNetUser dbnetuser = (LEDBNetUser)dbnetusers.get((String)keys.elementAt(i4));
            this.writeUser(dbnetuser, pw);
            ++i4;
        }
    }

    public void writeUser(LENetUser user, PrintWriter pw) {
        pw.println('#');
        pw.print(user.getName());
        pw.print("\tPassword = \"");
        if (this.m_password) {
            pw.print((String)user.get("password"));
        }
        pw.print("\", ");
        pw.print("Client-Id = ");
        pw.print(this.m_hostname);
        pw.println("");
        pw.println("\tUser-Service-Type = Framed-User,");
        pw.print("\tFramed-Protocol = ");
        String protocol = (String)user.get("289");
        if (protocol.equals("ppp")) {
            pw.println("PPP,");
        } else {
            pw.println("SLIP,");
        }
        pw.print("\tFramed-Address = ");
        pw.print((String)user.get("IPAddress"));
        pw.println(",");
        pw.print("\tFramed-Netmask = ");
        pw.print((String)user.get("15"));
        pw.println(",");
        pw.print("\tFramed-Routing = ");
        String rip_broad = (String)user.get("187");
        String rip_listen = (String)user.get("188");
        if (rip_broad.equals("on") && rip_listen.equals("on")) {
            pw.println("Broadcast-Listen,");
        } else if (rip_broad.equals("on") && rip_listen.equals("off")) {
            pw.println("Broadcast,");
        } else if (rip_broad.equals("off") && rip_listen.equals("on")) {
            pw.println("Listen,");
        } else {
            pw.println("None,");
        }
        pw.print("\tFramed-Compression = ");
        String compression = (String)user.get("290");
        if (!compression.equals("off")) {
            pw.print("Van-Jacobsen-TCP-IP");
        } else {
            pw.print("None");
        }
        pw.println(",");
        String ifilter = (String)user.get("193");
        String ofilter = (String)user.get("194");
        if (ifilter != null && ofilter != null) {
            if (ifilter.equals(ofilter)) {
                pw.print("\tFramed-Filter-Id = \"");
                pw.print(ifilter);
                pw.println("\",");
            } else {
                pw.println("# WARNING input and output both filters specified and do not match");
                pw.print("#\tFramed-Filter-Id = \"");
                pw.print(ifilter);
                pw.println("\",");
                pw.print("#\tFramed-Filter-Id = \"");
                pw.print(ofilter);
                pw.println("\",");
            }
        }
        pw.print("\tFramed-MTU = ");
        pw.print((String)user.get("295"));
        pw.println("");
    }

    public void writeUser(LELoginUser user, PrintWriter pw) {
        pw.println('#');
        pw.print(user.getName());
        pw.print("\tPassword = \"");
        if (this.m_password) {
            pw.print((String)user.get("password"));
        }
        pw.print("\", ");
        pw.print("Client-Id = ");
        pw.print(this.m_hostname);
        pw.println("");
        pw.println("\tUser-Service-Type = Login-User,");
        pw.print("\tLogin-Host = ");
        pw.print((String)user.get("HostAddress"));
        pw.println(",");
        pw.print("\tFramed-Filter-Id = \"");
        pw.print((String)user.get("193"));
        pw.println("\",");
        pw.print("\tLogin-Service = ");
        String service = (String)user.get("service");
        if (service.equals("portmaster")) {
            pw.println("PortMaster");
        } else if (service.equals("telnet")) {
            pw.println("Telnet");
        } else if (service.equals("rlogin")) {
            pw.println("Rlogin");
        } else {
            pw.println("TCP-Clear");
        }
    }

    public void writeUser(LEDBLoginUser user, PrintWriter pw) {
        pw.println('#');
        pw.print(user.getName());
        pw.print("\tPassword = \"\", ");
        pw.print("Client-Id = ");
        pw.print(this.m_hostname);
        pw.println("");
        pw.println("\tUser-Service-Type = Dialback-Login-User,");
        pw.println("\tLogin-Host = 0.0.0.0,");
        pw.print("\tDialback-No = \"");
        pw.print((String)user.get("301"));
        pw.println("\",");
        pw.println("\tLogin-Service = PortMaster");
    }

    public void writeUser(LEDBNetUser user, PrintWriter pw) {
        pw.println('#');
        pw.print(user.getName());
        pw.print("\tPassword = \"");
        if (this.m_password) {
            pw.print((String)user.get("password"));
        }
        pw.print("\", ");
        pw.print("Client-Id = ");
        pw.print(this.m_hostname);
        pw.println("");
        pw.println("\tUser-Service-Type = Dialback-Framed-User,");
        pw.print("\tDialback-Name = \"");
        pw.print((String)user.get("368"));
        pw.println("\"");
    }
}

