/*
 * Decompiled with CFR 0.152.
 */
import COM.livingston.amf.LEAMFactory;
import COM.livingston.amf.LEAMObserver;
import COM.livingston.backend.LEPortIOFactory;
import COM.livingston.backend.LEPortIOMessage;
import COM.livingston.backend.LEStatusFactory;
import COM.livingston.backend.LEStatusMessage;
import COM.livingston.model.LEPortMaster;
import COM.livingston.ui.LEColor;
import COM.livingston.ui.LEFont;
import COM.livingston.ui.LELEDs;
import COM.livingston.util.LEResource;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ImageObserver;

public class LEOR_UDisplay
implements LEMonitorDisplay,
LEAMObserver,
ImageObserver {
    static Image s_oru = null;
    LEPortMaster m_pm;
    String m_host;
    int m_height = -1;
    int m_width = -1;
    int m_nameHeight;
    int m_x;
    int m_y;
    int m_flags;
    int m_pollcnt;
    boolean m_blink;
    boolean m_active;
    boolean m_connected;
    boolean m_drawHeartbeat;
    boolean m_drawInterfaces;
    boolean m_nt1_flash = false;
    boolean m_state = true;
    Image m_hb;
    Image m_link;
    Image m_traffic;
    Image m_nt1;
    Image m_s1;
    Image m_s2;

    public LEOR_UDisplay() {
        if (s_oru == null) {
            s_oru = LEResource.GetImage("oru-fr.gif");
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            if (!toolkit.prepareImage(s_oru, -1, -1, this)) {
                this.m_flags = 2;
            }
        }
        this.m_pollcnt = 0;
        this.m_hb = LELEDs.GetLED(LELEDs.SQGREEN);
        this.m_link = LELEDs.GetLED(LELEDs.SQGREEN);
        this.m_traffic = LELEDs.GetLED(LELEDs.SQYELLOW);
        this.m_nt1 = LELEDs.GetLED(LELEDs.SQGREEN);
        this.m_s1 = LELEDs.GetLED(LELEDs.SQGRAY);
        this.m_s2 = LELEDs.GetLED(LELEDs.SQGRAY);
    }

    public void setPortMaster(LEPortMaster lEPortMaster) {
        this.m_pm = lEPortMaster;
        this.m_host = this.m_pm.getHostname();
        this.m_connected = this.m_pm.isConnected();
        LEStatusFactory.GetFactory().addObserver(this.m_host, this);
        LEPortIOFactory.GetFactory().addObserver(this.m_host, this);
        if (!this.m_connected) {
            this.m_hb = LELEDs.GetLED(LELEDs.SQGRAY);
            this.m_link = LELEDs.GetLED(LELEDs.SQGRAY);
            this.m_traffic = LELEDs.GetLED(LELEDs.SQGRAY);
            this.m_nt1 = LELEDs.GetLED(LELEDs.SQGRAY);
            this.m_s1 = LELEDs.GetLED(LELEDs.SQGRAY);
            this.m_s2 = LELEDs.GetLED(LELEDs.SQGRAY);
        }
        this.m_active = this.m_pm.getDSS().supportsEntities();
        if (this.m_active) {
            this.startMonitoring();
        }
        this.m_pm.fetch("262144");
    }

    public void select(int n, int n2, LEViewListener lEViewListener) {
    }

    public int getHeight(Graphics graphics) {
        if (this.m_height < 1) {
            this.determineSize(graphics);
            this.m_flags |= 4;
        }
        return this.m_height;
    }

    public int getWidth(Graphics graphics) {
        if (this.m_width < 1) {
            this.determineSize(graphics);
            this.m_flags |= 4;
        }
        return this.m_width;
    }

    public void draw(Graphics graphics, int n, int n2) {
        if (this.m_width == -1 || this.m_height == -1) {
            this.determineSize(graphics);
        }
        if (this.m_width == -1 || this.m_height == -1) {
            return;
        }
        graphics.setColor(LEColor.getBackground());
        graphics.fillRect(n, n2, this.m_width, this.m_height);
        Font font = LEFont.getBoldFont();
        graphics.setFont(font);
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        int n3 = n + (this.m_width - fontMetrics.stringWidth(this.m_host)) / 2;
        graphics.setColor(LEColor.getForeground());
        graphics.drawString(this.m_host, n3, n2 + fontMetrics.getAscent());
        this.m_nameHeight = fontMetrics.getHeight() + 2;
        this.m_x = n;
        this.m_y = n2 + this.m_nameHeight;
        graphics.drawImage(s_oru, this.m_x, this.m_y, this);
        this.drawHeartbeat(graphics);
        this.drawInterfaces(graphics);
        if (!(this.m_active && this.m_connected || !this.m_active)) {
            graphics.setFont(LEFont.getFont());
            fontMetrics = graphics.getFontMetrics();
            int n4 = fontMetrics.stringWidth("Not connected") + 20;
            int n5 = fontMetrics.getHeight() + 20;
            n3 = this.m_x + (this.m_width - n4) / 2;
            int n6 = this.m_y + (this.m_height - this.m_nameHeight - n5) / 2;
            this.drawBox(graphics, n3, n6, n4, n5);
            graphics.drawString("Not connected", n3 + 10, n6 + 10 + fontMetrics.getAscent());
        }
    }

    public synchronized int heartbeat(Graphics graphics) {
        if (this.m_pollcnt < 2) {
            ++this.m_pollcnt;
        } else {
            this.m_pollcnt = 0;
            if (this.m_pm != null) {
                this.m_pm.fetch("262144");
            }
        }
        if (this.m_connected) {
            this.m_hb = LELEDs.GetLED(LELEDs.SQGRAY);
            this.drawHeartbeat(graphics);
            this.m_drawHeartbeat = true;
            return 1;
        }
        return 0;
    }

    public synchronized int blink(Graphics graphics, boolean bl) {
        this.m_blink = bl;
        if (this.m_connected && this.m_drawHeartbeat) {
            this.m_hb = LELEDs.GetLED(LELEDs.SQGREEN);
            this.drawHeartbeat(graphics);
        }
        if (this.m_connected && this.m_nt1_flash) {
            this.switchLED(graphics);
        }
        if (this.m_connected && this.m_drawInterfaces) {
            this.drawInterfaces(graphics);
        }
        int n = this.m_flags;
        this.m_flags = 0;
        return n;
    }

    public void shutdown() {
        LEStatusFactory.GetFactory().deleteObserver(this.m_host, this);
        LEPortIOFactory.GetFactory().deleteObserver(this.m_host, this);
        this.stopMonitoring();
    }

    public synchronized boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        if ((n & 0x20) != 0) {
            this.m_flags |= 2;
            return false;
        }
        return true;
    }

    public synchronized void update(LEAMFactory lEAMFactory, String string, Object object) {
        if (object instanceof LEStatusMessage) {
            this.updateStatus((LEStatusMessage)object);
            return;
        }
        if (object instanceof LEPortIOMessage) {
            this.updateStatus((LEPortIOMessage)object);
        }
    }

    void determineSize(Graphics graphics) {
        this.m_width = s_oru.getWidth(this);
        this.m_height = s_oru.getHeight(this);
        if (this.m_width == -1 || this.m_height == -1) {
            return;
        }
        Font font = LEFont.getBoldFont();
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        this.m_height += fontMetrics.getHeight() + 4;
    }

    void startMonitoring() {
    }

    void stopMonitoring() {
    }

    void updateStatus(LEStatusMessage lEStatusMessage) {
        switch (lEStatusMessage.getStatus()) {
            case 1: {
                this.m_active = this.m_pm.getDSS().supportsEntities();
                if (this.m_active) {
                    this.startMonitoring();
                }
                this.m_connected = true;
                this.m_hb = LELEDs.GetLED(LELEDs.SQGREEN);
                this.m_link = LELEDs.GetLED(LELEDs.SQGREEN);
                this.m_traffic = LELEDs.GetLED(LELEDs.SQYELLOW);
                this.m_nt1 = LELEDs.GetLED(LELEDs.SQGRAY);
                this.m_s1 = LELEDs.GetLED(LELEDs.SQGRAY);
                this.m_s2 = LELEDs.GetLED(LELEDs.SQGRAY);
                this.m_flags |= 2;
                return;
            }
            case 2: 
            case 4: {
                this.m_connected = false;
                this.m_hb = LELEDs.GetLED(LELEDs.SQGRAY);
                this.m_link = LELEDs.GetLED(LELEDs.SQGRAY);
                this.m_traffic = LELEDs.GetLED(LELEDs.SQGRAY);
                this.m_nt1 = LELEDs.GetLED(LELEDs.SQGRAY);
                this.m_s1 = LELEDs.GetLED(LELEDs.SQGRAY);
                this.m_s2 = LELEDs.GetLED(LELEDs.SQGRAY);
                this.m_flags |= 2;
                return;
            }
        }
    }

    void updateStatus(LEPortIOMessage lEPortIOMessage) {
        if (lEPortIOMessage.getPortName().equals("S1")) {
            String string = lEPortIOMessage.getState();
            if (string.equals("NO-SERVICE")) {
                String string2 = lEPortIOMessage.getModemStatus();
                if (string2.equals("0")) {
                    this.flashNT1(true);
                } else {
                    this.flashNT1(false);
                }
                this.m_s1 = LELEDs.GetLED(LELEDs.SQGRAY);
            } else {
                this.m_s1 = string.equals("IDLE") ? LELEDs.GetLED(LELEDs.SQGRAY) : LELEDs.GetLED(LELEDs.SQBLUE);
            }
        } else if (lEPortIOMessage.getPortName().equals("S2")) {
            String string = lEPortIOMessage.getState();
            this.m_s2 = string.equals("NO-SERVICE") ? LELEDs.GetLED(LELEDs.SQGRAY) : (string.equals("IDLE") ? LELEDs.GetLED(LELEDs.SQGRAY) : LELEDs.GetLED(LELEDs.SQBLUE));
        }
        this.m_flags |= 2;
    }

    void drawHeartbeat(Graphics graphics) {
        graphics.drawImage(this.m_hb, this.m_x + 97, this.m_y + 36, null);
        this.m_drawHeartbeat = false;
        this.m_flags |= 1;
    }

    void drawInterfaces(Graphics graphics) {
        graphics.drawImage(this.m_link, this.m_x + 124, this.m_y + 36, null);
        graphics.drawImage(this.m_traffic, this.m_x + 152, this.m_y + 36, null);
        graphics.drawImage(this.m_nt1, this.m_x + 181, this.m_y + 36, null);
        graphics.drawImage(this.m_s1, this.m_x + 208, this.m_y + 36, null);
        graphics.drawImage(this.m_s2, this.m_x + 236, this.m_y + 36, null);
        this.m_flags |= 1;
        this.m_drawInterfaces = false;
    }

    void drawBox(Graphics graphics, int n, int n2, int n3, int n4) {
        graphics.setColor(Color.white);
        graphics.fillRect(n, n2, n3, n4);
        graphics.setColor(Color.black);
        graphics.drawRect(n, n2, n3, n4);
        graphics.drawRect(n + 1, n2 + 1, n3 - 2, n4 - 2);
    }

    private void flashNT1(boolean bl) {
        if (bl && !this.m_nt1_flash) {
            this.m_nt1_flash = true;
            return;
        }
        if (!bl) {
            this.m_nt1_flash = false;
            this.m_nt1 = LELEDs.GetLED(LELEDs.SQGREEN);
        }
    }

    private void switchLED(Graphics graphics) {
        if (this.m_state) {
            this.m_nt1 = LELEDs.GetLED(LELEDs.SQGREEN);
            graphics.drawImage(this.m_nt1, this.m_x + 181, this.m_y + 36, null);
            this.m_state = false;
        } else {
            this.m_nt1 = LELEDs.GetLED(LELEDs.SQGRAY);
            graphics.drawImage(this.m_nt1, this.m_x + 181, this.m_y + 36, null);
            this.m_state = true;
        }
        this.m_flags |= 1;
    }
}

