/*
 * Decompiled with CFR 0.152.
 */
import COM.livingston.amf.LEAMFactory;
import COM.livingston.amf.LEAMObserver;
import COM.livingston.backend.LEDeltaFactory;
import COM.livingston.backend.LEMonEnvMessage;
import COM.livingston.backend.LEMonIfacesMessage;
import COM.livingston.backend.LEMonLinesMessage;
import COM.livingston.backend.LEMonitorFactory;
import COM.livingston.backend.LESessionSummaryMessage;
import COM.livingston.backend.LEStatusFactory;
import COM.livingston.backend.LEStatusMessage;
import COM.livingston.model.LEBoard;
import COM.livingston.model.LEBoards;
import COM.livingston.model.LEMonitorFacility;
import COM.livingston.model.LEPortMaster;
import COM.livingston.ui.LEColor;
import COM.livingston.ui.LEFont;
import COM.livingston.ui.LELEDs;
import COM.livingston.util.LEDebug;
import COM.livingston.util.LEResource;
import COM.livingston.util.LEVector;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ImageObserver;

public class LEPM_4Display
implements LEMonitorDisplay,
LEAMObserver,
ImageObserver,
Runnable {
    public static final String NOT_CONNECTED = "Not connected";
    public static final String DASH = "-";
    public static final String DOWN = "down";
    static final int s_barW = 190;
    static final int s_greenW = 161;
    static final int s_yellowW = 15;
    static final int s_redW = 13;
    static final double s_maxTemp = 50.0;
    static Image s_pm4 = null;
    static Image s_present = null;
    static Image s_qt1 = null;
    static Image s_te1 = null;
    static Image s_sysmgr = null;
    static Image s_power = null;
    static Image s_fan1 = null;
    static Image s_fan2 = null;
    static Image s_fan3 = null;
    static Image s_fan4 = null;
    LEPortMaster m_pm;
    String m_host;
    int m_height = -1;
    int m_width = -1;
    int m_nameHeight;
    int m_x;
    int m_y;
    int m_flags;
    boolean m_drawSessions;
    boolean m_drawLines;
    boolean m_drawInterfaces;
    boolean m_drawEnv;
    boolean m_connected = false;
    boolean m_heartbeat = false;
    Image[] m_boards = new Image[10];
    boolean[] m_power = new boolean[10];
    Image[][] m_leds = new Image[10][];
    int[] m_sessions = new int[10];
    Image[] m_supplies = new Image[3];
    Image[] m_acleds = new Image[3];
    Image[] m_dcleds = new Image[3];
    Image m_fan1;
    Image m_fan2;
    Image m_fan3;
    Image m_fan4;
    Image m_diagOn;
    Image m_diagOff;
    double m_usedPower;
    double m_maxTemp;

    public LEPM_4Display() {
        if (s_pm4 == null) {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            if (!toolkit.prepareImage(s_pm4 = LEResource.GetImage("pm4.gif"), -1, -1, this)) {
                this.m_flags = 2;
            }
            s_sysmgr = LEResource.GetImage("sysmgr.gif");
            toolkit.prepareImage(s_sysmgr, -1, -1, null);
            s_qt1 = LEResource.GetImage("qt1.gif");
            toolkit.prepareImage(s_qt1, -1, -1, null);
            s_te1 = LEResource.GetImage("te1.gif");
            toolkit.prepareImage(s_te1, -1, -1, null);
            s_present = LEResource.GetImage("present.gif");
            toolkit.prepareImage(s_present, -1, -1, null);
            s_power = LEResource.GetImage("powersupply.gif");
            toolkit.prepareImage(s_power, -1, -1, null);
            s_fan1 = LEResource.GetImage("fan1down.gif");
            toolkit.prepareImage(s_fan1, -1, -1, null);
            s_fan2 = LEResource.GetImage("fan2down.gif");
            toolkit.prepareImage(s_fan2, -1, -1, null);
            s_fan3 = LEResource.GetImage("fan3down.gif");
            toolkit.prepareImage(s_fan3, -1, -1, null);
            s_fan4 = LEResource.GetImage("fan4down.gif");
            toolkit.prepareImage(s_fan4, -1, -1, null);
        }
        this.m_diagOn = LELEDs.GetLED(LELEDs.VSQ_YELLOW);
        this.m_diagOff = LELEDs.GetLED(LELEDs.VSQ_GRAY);
    }

    public void setPortMaster(LEPortMaster lEPortMaster) {
        this.m_pm = lEPortMaster;
        this.m_host = this.m_pm.getHostname();
        this.m_connected = this.m_pm.isConnected();
        LEStatusFactory.GetFactory().addObserver(this.m_host, this);
        LEMonitorFactory.GetFactory().addObserver(this.m_host, this);
        LEDeltaFactory.GetFactory().addObserver(this.m_host, this);
        if (this.m_connected) {
            this.startMonitoring();
        }
    }

    public void select(int n, int n2, LEViewListener lEViewListener) {
        LEViewEvent lEViewEvent = null;
        if ((n2 -= this.m_y) > 0 && n2 < 31 && n > 35 && n < 285 || n2 > 314 && n2 < 363 && n > 35 && n < 285 || n2 > 35 && n2 < 310 && (n -= this.m_x) > 290 && n < 424) {
            LEMonStatusView.Display(this.m_pm);
            lEViewEvent = new LEViewEvent(1, LEControlTree.STATUS);
        }
        if (lEViewEvent == null) {
            int n3 = 0;
            int n4 = 0;
            while (n4 < 10) {
                if (this.m_boards[n4] == s_qt1) {
                    if (n > 42 + n3 && n < 54 + n3 && n2 > 100 && n2 < 160) {
                        lEViewEvent = new LEViewEvent(1, LEControlTree.LINES);
                    } else if (n > 43 + n3 && n < 53 + n3 && n2 > 165 && n2 < 215) {
                        lEViewEvent = new LEViewEvent(1, LEControlTree.SESSION_SUM);
                    }
                } else if (this.m_boards[n4] == s_sysmgr && n > 42 + n3 && n < 54 + n3 && n2 > 100 && n2 < 175) {
                    if (n2 > 150) {
                        LEMonitorDetailPanel.Display(this.m_pm.getHostname(), "10");
                    } else {
                        LEMonitorDetailPanel.Display(this.m_pm.getHostname(), Integer.toString(n4));
                    }
                    lEViewEvent = new LEViewEvent(1, LEControlTree.IFACES);
                }
                n3 += 23;
                if (n4 == 4) {
                    n3 += 11;
                }
                ++n4;
            }
        }
        if (lEViewEvent != null) {
            lEViewListener.onLEViewEvent(lEViewEvent);
        }
    }

    public int getHeight(Graphics graphics) {
        if (this.m_height < 1) {
            this.determineSize(graphics);
            this.m_flags |= 4;
        }
        return this.m_height;
    }

    public int getWidth(Graphics graphics) {
        if (this.m_width < 1) {
            this.determineSize(graphics);
            this.m_flags |= 4;
        }
        return this.m_width;
    }

    public void draw(Graphics graphics, int n, int n2) {
        if (this.m_width == -1 || this.m_height == -1) {
            this.determineSize(graphics);
        }
        if (this.m_width == -1 || this.m_height == -1) {
            return;
        }
        graphics.setColor(LEColor.getBackground());
        graphics.fillRect(n, n2, this.m_width, this.m_height);
        Font font = LEFont.getBoldFont();
        graphics.setFont(font);
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        int n3 = n + (this.m_width - fontMetrics.stringWidth(this.m_host)) / 2;
        graphics.setColor(LEColor.getForeground());
        graphics.drawString(this.m_host, n3, n2 + fontMetrics.getAscent());
        this.m_nameHeight = fontMetrics.getHeight() + 2;
        this.m_x = n;
        this.m_y = n2 + this.m_nameHeight;
        graphics.drawImage(s_pm4, this.m_x, this.m_y, this);
        if (!this.m_connected) {
            graphics.setFont(LEFont.getFont());
            fontMetrics = graphics.getFontMetrics();
            int n4 = fontMetrics.stringWidth(NOT_CONNECTED) + 20;
            int n5 = fontMetrics.getHeight() + 20;
            n3 = this.m_x + (this.m_width - n4) / 2;
            int n6 = this.m_y + (this.m_height - this.m_nameHeight - n5) / 2;
            this.drawBox(graphics, n3, n6, n4, n5);
            graphics.drawString(NOT_CONNECTED, n3 + 10, n6 + 10 + fontMetrics.getAscent());
            return;
        }
        this.drawBoards(graphics);
        this.drawHeartbeat(graphics);
        this.drawLines(graphics);
        this.drawInterfaces(graphics);
        this.drawSessions(graphics);
        this.drawEnv(graphics);
    }

    public synchronized int heartbeat(Graphics graphics) {
        if (this.m_connected) {
            this.m_heartbeat = true;
            this.m_flags |= this.drawHeartbeat(graphics);
        }
        int n = this.m_flags;
        this.m_flags = 0;
        return n;
    }

    public synchronized int blink(Graphics graphics, boolean bl) {
        if (this.m_heartbeat) {
            this.m_heartbeat = false;
            this.m_flags |= this.drawHeartbeat(graphics);
        }
        if (this.m_drawLines) {
            this.m_flags |= this.drawLines(graphics);
        }
        if (this.m_drawInterfaces) {
            this.m_flags |= this.drawInterfaces(graphics);
        }
        if (this.m_drawSessions) {
            this.m_flags |= this.drawSessions(graphics);
        }
        if (this.m_drawEnv) {
            this.m_flags |= this.drawEnv(graphics);
        }
        int n = this.m_flags;
        this.m_flags = 0;
        return n;
    }

    public void shutdown() {
        LEStatusFactory.GetFactory().deleteObserver(this.m_host, this);
        LEMonitorFactory.GetFactory().deleteObserver(this.m_host, this);
        LEDeltaFactory.GetFactory().deleteObserver(this.m_host, this);
        this.stopMonitoring();
    }

    public synchronized boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        if ((n & 0x20) != 0) {
            this.m_flags |= 2;
            return false;
        }
        return true;
    }

    public synchronized void update(LEAMFactory lEAMFactory, String string, Object object) {
        if (object instanceof LEStatusMessage) {
            this.updateStatus((LEStatusMessage)object);
            return;
        }
        if (object instanceof LEMonLinesMessage) {
            this.updateLine((LEMonLinesMessage)object);
            return;
        }
        if (object instanceof LESessionSummaryMessage) {
            this.updateSessionSummary((LESessionSummaryMessage)object);
            return;
        }
        if (object instanceof LEMonEnvMessage) {
            this.updateEnvironment((LEMonEnvMessage)object);
        }
    }

    void determineSize(Graphics graphics) {
        this.m_width = s_pm4.getWidth(this);
        this.m_height = s_pm4.getHeight(this);
        if (this.m_width == -1 || this.m_height == -1) {
            return;
        }
        Font font = LEFont.getBoldFont();
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        this.m_height += fontMetrics.getHeight() + 4;
    }

    void startMonitoring() {
        LEBoards lEBoards = (LEBoards)this.m_pm.get("2555904");
        int n = 0;
        while (n < 10) {
            LEBoard lEBoard = (LEBoard)lEBoards.get(Integer.toString(n));
            if (lEBoard == null) {
                this.m_boards[n] = null;
            } else {
                String string = (String)lEBoard.get(LEBoard.POWER);
                this.m_power[n] = string != null && string.equals("on");
                String string2 = (String)lEBoard.get(LEBoard.BOARD_TYPE);
                if (string2 == null || string2.equals("Present")) {
                    this.m_boards[n] = s_present;
                    this.m_leds[n] = null;
                    this.m_sessions[n] = -1;
                } else if (string2.equals("System Manager")) {
                    this.m_boards[n] = s_sysmgr;
                    this.m_leds[n] = new Image[8];
                    this.m_leds[n][0] = LELEDs.GetLED(LELEDs.OVAL_GREEN);
                    this.m_leds[n][1] = LELEDs.GetLED(LELEDs.OVAL_YELLOW);
                    this.m_leds[n][2] = LELEDs.GetLED(LELEDs.OVAL_GREEN);
                    this.m_leds[n][3] = LELEDs.GetLED(LELEDs.OVAL_YELLOW);
                    this.m_leds[n][4] = LELEDs.GetLED(LELEDs.OVAL_GRAY);
                    this.m_leds[n][5] = LELEDs.GetLED(LELEDs.OVAL_GRAY);
                    this.m_leds[n][6] = LELEDs.GetLED(LELEDs.OVAL_GRAY);
                    this.m_leds[n][7] = LELEDs.GetLED(LELEDs.OVAL_GRAY);
                    this.m_sessions[n] = -1;
                } else if (string2.equals("Quad T1")) {
                    this.m_boards[n] = s_qt1;
                    this.m_leds[n] = new Image[8];
                    this.m_leds[n][0] = LELEDs.GetLED(LELEDs.OVAL_GRAY);
                    this.m_leds[n][1] = LELEDs.GetLED(LELEDs.OVAL_YELLOW);
                    this.m_leds[n][2] = LELEDs.GetLED(LELEDs.OVAL_GRAY);
                    this.m_leds[n][3] = LELEDs.GetLED(LELEDs.OVAL_YELLOW);
                    this.m_leds[n][4] = LELEDs.GetLED(LELEDs.OVAL_GRAY);
                    this.m_leds[n][5] = LELEDs.GetLED(LELEDs.OVAL_YELLOW);
                    this.m_leds[n][6] = LELEDs.GetLED(LELEDs.OVAL_GRAY);
                    this.m_leds[n][7] = LELEDs.GetLED(LELEDs.OVAL_YELLOW);
                    this.m_sessions[n] = 0;
                } else if (string2.equals("Tri E1")) {
                    this.m_boards[n] = s_te1;
                    this.m_leds[n] = new Image[6];
                    this.m_leds[n][0] = LELEDs.GetLED(LELEDs.OVAL_GRAY);
                    this.m_leds[n][1] = LELEDs.GetLED(LELEDs.OVAL_YELLOW);
                    this.m_leds[n][2] = LELEDs.GetLED(LELEDs.OVAL_GRAY);
                    this.m_leds[n][3] = LELEDs.GetLED(LELEDs.OVAL_YELLOW);
                    this.m_leds[n][4] = LELEDs.GetLED(LELEDs.OVAL_GRAY);
                    this.m_leds[n][5] = LELEDs.GetLED(LELEDs.OVAL_YELLOW);
                    this.m_sessions[n] = 0;
                }
            }
            ++n;
        }
        new Thread(this).start();
    }

    public void run() {
        LEMonitorFacility lEMonitorFacility = this.m_pm.getMonitorFacility();
        if (lEMonitorFacility == null) {
            return;
        }
        lEMonitorFacility.startMonitor(131072, -1);
        lEMonitorFacility.startMonitor(0x2E0000, -1);
        lEMonitorFacility.startMonitor(0x330000, -1);
    }

    void stopMonitoring() {
        LEMonitorFacility lEMonitorFacility = this.m_pm.getMonitorFacility();
        if (lEMonitorFacility == null) {
            return;
        }
        lEMonitorFacility.stopMonitor(131072, -1);
        lEMonitorFacility.stopMonitor(0x2E0000, -1);
        lEMonitorFacility.stopMonitor(0x330000, -1);
    }

    void updateSessionSummary(LESessionSummaryMessage lESessionSummaryMessage) {
        String string = lESessionSummaryMessage.getBoard();
        if (string == null) {
            return;
        }
        int n = 0;
        try {
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
            return;
        }
        if (this.m_sessions[n] == -1) {
            return;
        }
        int n2 = lESessionSummaryMessage.getTotal();
        if (n2 <= 0) {
            return;
        }
        int n3 = 0;
        int n4 = lESessionSummaryMessage.getISDNCount();
        if (n4 > 0) {
            n3 += n4;
        }
        if ((n4 = lESessionSummaryMessage.get56KCount()) > 0) {
            n3 += n4;
        }
        if ((n4 = lESessionSummaryMessage.getV34Count()) > 0) {
            n3 += n4;
        }
        if ((n4 = lESessionSummaryMessage.getOtherCount()) > 0) {
            n3 += n4;
        }
        double d = (double)n3 / (double)n2 * 100.0;
        this.m_sessions[n] = (int)(d / 2.0);
        this.m_drawSessions = true;
    }

    void updateLine(LEMonLinesMessage lEMonLinesMessage) {
        String string = lEMonLinesMessage.getBoard();
        String string2 = lEMonLinesMessage.getName();
        String string3 = lEMonLinesMessage.getStatus();
        String string4 = lEMonLinesMessage.getStatus2();
        if (string == null || string2 == null || string3 == null || string4 == null) {
            return;
        }
        if (string2.length() < 5) {
            return;
        }
        int n = 0;
        int n2 = 0;
        try {
            n = Integer.parseInt(string2.substring(4));
            n2 = Integer.parseInt(string);
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
            return;
        }
        if (this.m_leds[n2] == null) {
            return;
        }
        boolean bl = true;
        if (string3.equals(DOWN) || string3.equals(DASH)) {
            bl = false;
        }
        boolean bl2 = true;
        if (string4.equals(DOWN) || string4.equals(DASH)) {
            bl2 = false;
        }
        if (!bl) {
            this.m_leds[n2][n * 2] = LELEDs.GetLED(LELEDs.OVAL_GRAY);
            this.m_leds[n2][n * 2 + 1] = LELEDs.GetLED(LELEDs.OVAL_YELLOW);
        } else if (bl2) {
            this.m_leds[n2][n * 2] = LELEDs.GetLED(LELEDs.OVAL_GREEN);
            this.m_leds[n2][n * 2 + 1] = LELEDs.GetLED(LELEDs.OVAL_GRAY);
        } else {
            this.m_leds[n2][n * 2] = LELEDs.GetLED(LELEDs.OVAL_GREEN);
            this.m_leds[n2][n * 2 + 1] = LELEDs.GetLED(LELEDs.OVAL_YELLOW);
        }
        this.m_drawLines = true;
    }

    void updateEnvironment(LEMonEnvMessage lEMonEnvMessage) {
        Object object;
        this.updatePowerSupply(lEMonEnvMessage.getPowerSupply("top"), 0);
        this.updatePowerSupply(lEMonEnvMessage.getPowerSupply("middle"), 1);
        this.updatePowerSupply(lEMonEnvMessage.getPowerSupply("bottom"), 2);
        try {
            double d = (double)Integer.parseInt(lEMonEnvMessage.getUsedPower()) + (double)Integer.parseInt(lEMonEnvMessage.getReqPower());
            double d2 = Integer.parseInt(lEMonEnvMessage.getMaxPower());
            if (d2 == 0.0) {
                d2 = 1.0;
            }
            this.m_usedPower = d / d2;
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
        }
        try {
            this.m_maxTemp = 0.0;
            object = lEMonEnvMessage.getBoards();
            int n = ((LEVector)object).size();
            int n2 = 0;
            while (n2 < n) {
                String string = (String)((LEVector)object).elementAt(n2);
                this.m_maxTemp = Math.max(this.m_maxTemp, (double)Integer.parseInt(lEMonEnvMessage.getBoardTemp(string)));
                ++n2;
            }
            int n3 = 0;
            while (n3 < this.m_boards.length) {
                String string = Integer.toString(n3);
                if (this.m_boards[n3] != null && !((LEVector)object).contains(string)) {
                    this.m_power[n3] = false;
                    this.m_flags |= 2;
                }
                ++n3;
            }
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
        }
        this.m_maxTemp /= 50.0;
        this.m_maxTemp = Math.min(this.m_maxTemp, 1.0);
        Image image = this.m_fan1;
        object = this.m_fan2;
        Image image2 = this.m_fan3;
        Image image3 = this.m_fan4;
        this.m_fan1 = lEMonEnvMessage.getFan(1).equals("off") ? s_fan1 : null;
        this.m_fan2 = lEMonEnvMessage.getFan(2).equals("off") ? s_fan2 : null;
        this.m_fan3 = lEMonEnvMessage.getFan(3).equals("off") ? s_fan3 : null;
        Image image4 = this.m_fan4 = lEMonEnvMessage.getFan(4).equals("off") ? s_fan4 : null;
        if (this.m_fan1 != image || this.m_fan2 != object || this.m_fan3 != image2 || this.m_fan4 != image3) {
            this.m_flags |= 2;
        }
        this.m_drawEnv = true;
    }

    void updatePowerSupply(String string, int n) {
        if (string.equals("removed")) {
            if (this.m_supplies[n] != null) {
                this.m_flags |= 2;
            }
            this.m_supplies[n] = null;
            this.m_acleds[n] = null;
            this.m_dcleds[n] = null;
            return;
        }
        if (string.equals("present")) {
            this.m_supplies[n] = s_power;
            this.m_acleds[n] = LELEDs.GetLED(LELEDs.GRAY);
            this.m_dcleds[n] = LELEDs.GetLED(LELEDs.GRAY);
            return;
        }
        if (string.equals("working")) {
            this.m_supplies[n] = s_power;
            if (this.m_acleds[n] != null) {
                this.m_flags |= 2;
            }
            this.m_acleds[n] = null;
            this.m_dcleds[n] = null;
        }
    }

    void updateInterface(LEMonIfacesMessage lEMonIfacesMessage) {
    }

    void updateStatus(LEStatusMessage lEStatusMessage) {
        switch (lEStatusMessage.getStatus()) {
            case 1: {
                this.startMonitoring();
                this.m_connected = true;
                this.m_flags |= 2;
                return;
            }
            case 2: 
            case 4: {
                this.m_connected = false;
                this.m_flags |= 2;
                return;
            }
        }
    }

    void drawBoards(Graphics graphics) {
        int n = this.m_x + 38;
        int n2 = this.m_y + 35;
        int n3 = 0;
        while (n3 < 10) {
            if (this.m_boards[n3] != null) {
                graphics.drawImage(this.m_boards[n3], n, n2, null);
                if (!this.m_power[n3]) {
                    graphics.drawImage(this.m_diagOff, n + 8, n2 + 198, null);
                }
            }
            n += 23;
            if (n3 == 4) {
                n += 11;
            }
            ++n3;
        }
    }

    int drawHeartbeat(Graphics graphics) {
        int n = this.m_x + 46;
        int n2 = this.m_y + 222;
        int n3 = 0;
        while (n3 < 10) {
            if (this.m_boards[n3] != null) {
                if (this.m_heartbeat || !this.m_power[n3]) {
                    graphics.drawImage(this.m_diagOff, n, n2, null);
                } else {
                    graphics.drawImage(this.m_diagOn, n, n2, null);
                }
            }
            n += 23;
            if (n3 == 4) {
                n += 11;
            }
            ++n3;
        }
        return 1;
    }

    int drawLines(Graphics graphics) {
        int n = this.m_x + 41;
        int n2 = this.m_y + 102;
        int n3 = 0;
        while (n3 < 10) {
            if (this.m_boards[n3] == s_sysmgr) {
                graphics.drawImage(this.m_leds[n3][0], n, n2, null);
                graphics.drawImage(this.m_leds[n3][1], n, n2 + 7, null);
                graphics.drawImage(this.m_leds[n3][2], n, n2 + 14, null);
                graphics.drawImage(this.m_leds[n3][3], n, n2 + 21, null);
            } else if (this.m_boards[n3] == s_qt1) {
                graphics.drawImage(this.m_leds[n3][0], n, n2, null);
                graphics.drawImage(this.m_leds[n3][1], n, n2 + 7, null);
                graphics.drawImage(this.m_leds[n3][2], n, n2 + 14, null);
                graphics.drawImage(this.m_leds[n3][3], n, n2 + 21, null);
                graphics.drawImage(this.m_leds[n3][4], n, n2 + 28, null);
                graphics.drawImage(this.m_leds[n3][5], n, n2 + 35, null);
                graphics.drawImage(this.m_leds[n3][6], n, n2 + 42, null);
                graphics.drawImage(this.m_leds[n3][7], n, n2 + 49, null);
            } else if (this.m_boards[n3] == s_te1) {
                graphics.drawImage(this.m_leds[n3][0], n, n2, null);
                graphics.drawImage(this.m_leds[n3][1], n, n2 + 7, null);
                graphics.drawImage(this.m_leds[n3][2], n, n2 + 14, null);
                graphics.drawImage(this.m_leds[n3][3], n, n2 + 21, null);
                graphics.drawImage(this.m_leds[n3][4], n, n2 + 28, null);
                graphics.drawImage(this.m_leds[n3][5], n, n2 + 35, null);
            }
            n += 23;
            if (n3 == 4) {
                n += 11;
            }
            ++n3;
        }
        this.m_drawLines = false;
        return 1;
    }

    int drawInterfaces(Graphics graphics) {
        int n = this.m_x + 41;
        int n2 = this.m_y + 136;
        int n3 = 0;
        while (n3 < 10) {
            if (this.m_boards[n3] == s_sysmgr) {
                graphics.drawImage(this.m_leds[n3][4], n, n2, null);
                graphics.drawImage(this.m_leds[n3][5], n, n2 + 7, null);
                graphics.drawImage(this.m_leds[n3][6], n + 10, n2 + 20, null);
                graphics.drawImage(this.m_leds[n3][7], n + 10, n2 + 27, null);
            }
            n += 23;
            if (n3 == 4) {
                n += 11;
            }
            ++n3;
        }
        this.m_drawInterfaces = false;
        return 1;
    }

    int drawSessions(Graphics graphics) {
        int n = this.m_x + 44;
        int n2 = this.m_y + 165;
        int n3 = 0;
        while (n3 < 10) {
            if (this.m_sessions[n3] > 0) {
                graphics.setColor(Color.green);
                int n4 = this.m_sessions[n3];
                graphics.fillRect(n, n2 + 51 - n4, 9, n4);
            }
            n += 23;
            if (n3 == 4) {
                n += 11;
            }
            ++n3;
        }
        this.m_drawSessions = false;
        return 1;
    }

    int drawEnv(Graphics graphics) {
        int n = this.m_x + 297;
        int n2 = this.m_y + 40;
        int n3 = 0;
        while (n3 < this.m_supplies.length) {
            if (this.m_supplies[n3] != null) {
                graphics.drawImage(this.m_supplies[n3], n, n2, null);
                if (this.m_acleds[n3] != null) {
                    graphics.drawImage(this.m_acleds[n3], n + 18, n2 + 68, null);
                }
                if (this.m_dcleds[n3] != null) {
                    graphics.drawImage(this.m_dcleds[n3], n + 29, n2 + 68, null);
                }
            }
            n2 += 89;
            ++n3;
        }
        this.drawPowerBar(graphics, this.m_usedPower, this.m_x + 87, this.m_y + 7);
        this.drawBar(graphics, this.m_maxTemp, this.m_x + 87, this.m_y + 21);
        if (this.m_fan1 != null) {
            graphics.drawImage(this.m_fan1, this.m_x + 171, this.m_y + 321, null);
        }
        if (this.m_fan2 != null) {
            graphics.drawImage(this.m_fan2, this.m_x + 45, this.m_y + 321, null);
        }
        if (this.m_fan3 != null) {
            graphics.drawImage(this.m_fan3, this.m_x + 171, this.m_y + 341, null);
        }
        if (this.m_fan4 != null) {
            graphics.drawImage(this.m_fan4, this.m_x + 45, this.m_y + 341, null);
        }
        this.m_drawEnv = false;
        return 1;
    }

    void drawPowerBar(Graphics graphics, double d, int n, int n2) {
        graphics.setColor(Color.black);
        graphics.fillRect(n, n2, 190, 7);
        if (d > 1.0) {
            int n3 = (int)(190.0 / d);
            graphics.setColor(Color.green);
            graphics.fillRect(n + 1, n2 + 1, n3, 5);
            int n4 = 190 - n3;
            graphics.setColor(Color.red);
            graphics.fillRect(n + 1 + n3, n2, n4, 5);
            return;
        }
        int n5 = (int)(190.0 * d);
        graphics.setColor(Color.green);
        graphics.fillRect(n + 1, n2 + 1, n5, 5);
    }

    void drawBar(Graphics graphics, double d, int n, int n2) {
        graphics.setColor(Color.black);
        graphics.fillRect(n, n2, 190, 7);
        int n3 = (int)(190.0 * d);
        int n4 = Math.min(n3, 161);
        graphics.setColor(Color.green);
        graphics.fillRect(n + 1, n2 + 1, n4, 5);
        if ((n3 -= 161) > 0) {
            n4 = Math.min(n3, 15);
            graphics.setColor(Color.yellow);
            graphics.fillRect(n + 1 + 161, n2 + 1, n4, 5);
            if ((n3 -= 15) > 0) {
                n4 = Math.min(n3, 14);
                graphics.setColor(Color.red);
                graphics.fillRect(n + 1 + 161 + 15, n2, n4, 5);
            }
        }
    }

    void drawBox(Graphics graphics, int n, int n2, int n3, int n4) {
        graphics.setColor(Color.white);
        graphics.fillRect(n, n2, n3, n4);
        graphics.setColor(Color.black);
        graphics.drawRect(n, n2, n3, n4);
        graphics.drawRect(n + 1, n2 + 1, n3 - 2, n4 - 2);
    }
}

