/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.model;

import COM.livingston.model.LEConfig;
import COM.livingston.model.LEConfigFacility;
import COM.livingston.util.LEVector;

public class LEChoicenet
extends LEConfig {
    public static final String SERVER_0 = "208";
    public static final String SERVER_1 = "209";
    public static final String PORT_0 = "212";
    public static final String PORT_1 = "213";
    public static final String SECRET = "choicenet-secret";
    public static final int KEY_COUNT = 5;
    static String[] s_keys = null;
    boolean m_secretFetched = false;

    public static String[] GetAllPossibleKeys() {
        if (s_keys == null) {
            s_keys = new String[5];
            LEChoicenet.s_keys[0] = SERVER_0;
            LEChoicenet.s_keys[1] = SERVER_1;
            LEChoicenet.s_keys[2] = PORT_0;
            LEChoicenet.s_keys[3] = PORT_1;
            LEChoicenet.s_keys[4] = SECRET;
        }
        return s_keys;
    }

    public LEChoicenet(LEConfigFacility facility) {
        super(facility);
    }

    public Object clone() {
        LEChoicenet config = new LEChoicenet(this.m_facility);
        config.copy(this);
        return config;
    }

    void setSecret(String secret) {
        this.m_secretFetched = true;
        this.setField(SECRET, secret);
    }

    boolean generateCommands(LEVector keys, LEVector cmds) {
        String port;
        String serveraddr;
        StringBuffer cmdbuf;
        boolean allCmds;
        int start = cmds.size();
        boolean bl = allCmds = keys == null;
        if (allCmds || keys.contains(SERVER_0)) {
            cmdbuf = new StringBuffer(30);
            cmdbuf.append("set ");
            cmdbuf.append("choicenet ");
            serveraddr = (String)this.get(SERVER_0);
            if (serveraddr.equals("")) {
                cmdbuf.append("0.0.0.0");
            } else {
                cmdbuf.append(serveraddr);
            }
            port = (String)this.get(PORT_0);
            if (port != null && !serveraddr.equals("")) {
                cmdbuf.append(" ");
                cmdbuf.append(port);
            }
            cmds.add(cmdbuf.toString());
        }
        if (allCmds || keys.contains(SERVER_1)) {
            cmdbuf = new StringBuffer(30);
            cmdbuf.append("set ");
            cmdbuf.append("choicenet 2 ");
            serveraddr = (String)this.get(SERVER_1);
            if (serveraddr.equals("")) {
                cmdbuf.append("0.0.0.0");
            } else {
                cmdbuf.append(serveraddr);
            }
            port = (String)this.get(PORT_1);
            if (port != null && !serveraddr.equals("")) {
                cmdbuf.append(" ");
                cmdbuf.append(port);
            }
            cmds.add(cmdbuf.toString());
        }
        if (allCmds && this.m_secretFetched) {
            this.makeSetCommand(cmds, null, SECRET, SECRET);
        } else if (!allCmds && keys.contains(SECRET)) {
            this.makeSetCommand(cmds, null, SECRET, SECRET);
        }
        return cmds.size() > start;
    }
}

