/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.model;

import COM.livingston.model.LEConfig;
import COM.livingston.model.LEConfigFacility;
import COM.livingston.util.LEDebug;
import COM.livingston.util.LEVector;

public class LEGlobal
extends LEConfig {
    public static final String ASSIGNED_ADDR = "164";
    public static final String ASSIGNED_POOL = "165";
    public static final String BGP = "197";
    public static final String BRI_SWITCH = "144";
    public static final String CALL_CHECK = "185";
    public static final String CHAP = "170";
    public static final String DEF_BROADCAST = "154";
    public static final String DEF_LISTEN = "155";
    public static final String DOMAIN = "159";
    public static final String HARDWARE_VER = "146";
    public static final String HOST_1 = "173";
    public static final String HOST_2 = "174";
    public static final String HOST_3 = "175";
    public static final String HOST_4 = "176";
    public static final String IP_GATEWAY = "75";
    public static final String IP_METRIC = "151";
    public static final String IPX = "183";
    public static final String IPX_GATEWAY = "152";
    public static final String IPX_METRIC = "153";
    public static final String ISDN_MSN = "171";
    public static final String ISDN_NUM_AUTO = "179";
    public static final String L2TP_TYPE = "495";
    public static final String LOCAL_IP = "177";
    public static final String LOGHOST = "162";
    public static final String MAC_ADDRESS = "195";
    public static final String MAX_PMC = "161";
    public static final String MCPPP_ENDPOINT = "57";
    public static final String NAME_SERVICE = "156";
    public static final String NAME_SERVER_ALT = "158";
    public static final String NAME_SERVER_PRI = "157";
    public static final String NETBIOS = "184";
    public static final String NETBIOS_NS_ALT = "168";
    public static final String NETBIOS_NS_PRI = "167";
    public static final String NUM_ETHERS = "150";
    public static final String NUM_LINES = "149";
    public static final String NUM_PORTS = "148";
    public static final String OSPF = "181";
    public static final String PAP = "169";
    public static final String PASSWORD = "password";
    public static final String PRI_SWITCH = "143";
    public static final String PROXY_ARP = "178";
    public static final String REPORTED_IP = "166";
    public static final String SERIAL_ADMIN = "163";
    public static final String SOFTWARE_VER = "145";
    public static final String SNMP = "182";
    public static final String TELNET_PORT = "160";
    public static final String UP_TIME = "36";
    public static final String USER_NETMASK = "180";
    public static final int KEY_COUNT = 48;
    public static final String SW_1TR6 = "1tr6";
    public static final String SW_ATT_4ESS = "att-4ess";
    public static final String SW_ATT_5ESS = "att-5ess";
    public static final String SW_ATT_5ESS_PTP = "att-5ess-ptp";
    public static final String SW_CCITT = "ccitt";
    public static final String SW_DMS_100 = "dms-100";
    public static final String SW_KDD = "kdd";
    public static final String SW_NET3 = "net3";
    public static final String SW_NET3_SWISS = "net3-swiss";
    public static final String SW_NET5 = "net5";
    public static final String SW_NET5_SWISS = "net5-swiss";
    public static final String SW_NI_1 = "ni-1";
    public static final String SW_NI_2 = "ni-2";
    public static final String SW_NTT = "ntt";
    public static final String SW_VN2 = "vn2";
    public static final String SW_VN3 = "vn3";
    public static final String SW_VN4 = "vn4";
    public static final String SW_VNP = "vnP";
    public static final int SWITCH_COUNT = 18;
    public static final String DNS = "dns";
    public static final String NIS = "nis";
    static String[] s_keys = null;
    static String[] s_switches = null;
    boolean m_reboot;

    public static String[] GetAllPossibleKeys() {
        if (s_keys == null) {
            s_keys = new String[48];
            int i = 0;
            LEGlobal.s_keys[i++] = ASSIGNED_ADDR;
            LEGlobal.s_keys[i++] = ASSIGNED_POOL;
            LEGlobal.s_keys[i++] = BGP;
            LEGlobal.s_keys[i++] = BRI_SWITCH;
            LEGlobal.s_keys[i++] = CALL_CHECK;
            LEGlobal.s_keys[i++] = CHAP;
            LEGlobal.s_keys[i++] = DEF_BROADCAST;
            LEGlobal.s_keys[i++] = DEF_LISTEN;
            LEGlobal.s_keys[i++] = DOMAIN;
            LEGlobal.s_keys[i++] = HARDWARE_VER;
            LEGlobal.s_keys[i++] = HOST_1;
            LEGlobal.s_keys[i++] = HOST_2;
            LEGlobal.s_keys[i++] = HOST_3;
            LEGlobal.s_keys[i++] = HOST_4;
            LEGlobal.s_keys[i++] = IP_GATEWAY;
            LEGlobal.s_keys[i++] = IP_METRIC;
            LEGlobal.s_keys[i++] = IPX;
            LEGlobal.s_keys[i++] = IPX_GATEWAY;
            LEGlobal.s_keys[i++] = IPX_METRIC;
            LEGlobal.s_keys[i++] = ISDN_MSN;
            LEGlobal.s_keys[i++] = ISDN_NUM_AUTO;
            LEGlobal.s_keys[i++] = L2TP_TYPE;
            LEGlobal.s_keys[i++] = LOCAL_IP;
            LEGlobal.s_keys[i++] = LOGHOST;
            LEGlobal.s_keys[i++] = MAC_ADDRESS;
            LEGlobal.s_keys[i++] = MAX_PMC;
            LEGlobal.s_keys[i++] = MCPPP_ENDPOINT;
            LEGlobal.s_keys[i++] = NAME_SERVICE;
            LEGlobal.s_keys[i++] = NAME_SERVER_ALT;
            LEGlobal.s_keys[i++] = NAME_SERVER_PRI;
            LEGlobal.s_keys[i++] = NETBIOS;
            LEGlobal.s_keys[i++] = NETBIOS_NS_ALT;
            LEGlobal.s_keys[i++] = NETBIOS_NS_PRI;
            LEGlobal.s_keys[i++] = NUM_ETHERS;
            LEGlobal.s_keys[i++] = NUM_LINES;
            LEGlobal.s_keys[i++] = NUM_PORTS;
            LEGlobal.s_keys[i++] = OSPF;
            LEGlobal.s_keys[i++] = PAP;
            LEGlobal.s_keys[i++] = PASSWORD;
            LEGlobal.s_keys[i++] = PRI_SWITCH;
            LEGlobal.s_keys[i++] = PROXY_ARP;
            LEGlobal.s_keys[i++] = REPORTED_IP;
            LEGlobal.s_keys[i++] = SERIAL_ADMIN;
            LEGlobal.s_keys[i++] = SOFTWARE_VER;
            LEGlobal.s_keys[i++] = SNMP;
            LEGlobal.s_keys[i++] = TELNET_PORT;
            LEGlobal.s_keys[i++] = UP_TIME;
            LEGlobal.s_keys[i++] = USER_NETMASK;
        }
        return s_keys;
    }

    public static String[] GetSwitches() {
        if (s_switches == null) {
            s_switches = new String[18];
            LEGlobal.s_switches[0] = SW_1TR6;
            LEGlobal.s_switches[1] = SW_ATT_4ESS;
            LEGlobal.s_switches[2] = SW_ATT_5ESS;
            LEGlobal.s_switches[3] = SW_ATT_5ESS_PTP;
            LEGlobal.s_switches[4] = SW_CCITT;
            LEGlobal.s_switches[5] = SW_DMS_100;
            LEGlobal.s_switches[6] = SW_KDD;
            LEGlobal.s_switches[7] = SW_NET3;
            LEGlobal.s_switches[8] = SW_NET3_SWISS;
            LEGlobal.s_switches[9] = SW_NET5;
            LEGlobal.s_switches[10] = SW_NET5_SWISS;
            LEGlobal.s_switches[11] = SW_NI_1;
            LEGlobal.s_switches[12] = SW_NI_2;
            LEGlobal.s_switches[13] = SW_NTT;
            LEGlobal.s_switches[14] = SW_VN2;
            LEGlobal.s_switches[15] = SW_VN3;
            LEGlobal.s_switches[16] = SW_VN4;
            LEGlobal.s_switches[17] = SW_VNP;
        }
        return s_switches;
    }

    public LEGlobal(LEConfigFacility facility, String board) {
        super(facility, board);
    }

    public LEGlobal(LEConfigFacility facility) {
        super(facility);
    }

    public Object clone() {
        LEGlobal config = new LEGlobal(this.m_facility, this.m_board);
        config.copy(this);
        return config;
    }

    public void set(String key, Object value) {
        String oldValue;
        if (key.equals(ASSIGNED_POOL) && (oldValue = (String)this.get(ASSIGNED_POOL)) != null) {
            try {
                int prev = Integer.parseInt(oldValue);
                int curr = Integer.parseInt(value.toString());
                if (curr < prev) {
                    this.m_reboot = true;
                }
            }
            catch (NumberFormatException e) {
                LEDebug.getLog().logln(20, e);
            }
        }
        super.set(key, value);
    }

    public boolean requiresReboot(String key) {
        if (key.equals(ASSIGNED_POOL)) {
            return this.m_reboot;
        }
        return key.equals(BGP) || key.equals(OSPF) || key.equals(SNMP) || key.equals(MCPPP_ENDPOINT) || key.equals(BRI_SWITCH) || key.equals(PRI_SWITCH) || key.equals(L2TP_TYPE);
    }

    boolean generateCommands(LEVector keys, LEVector cmds) {
        String type;
        String metric;
        StringBuffer buf;
        String gateway;
        int start = cmds.size();
        boolean allCmds = keys == null;
        boolean reboot = false;
        if (allCmds || keys.contains(ASSIGNED_ADDR)) {
            this.makeSetCommand(cmds, null, ASSIGNED_ADDR, "assigned_address");
        }
        if ((allCmds || keys.contains(ASSIGNED_POOL)) && this.makeSetCommand(cmds, null, ASSIGNED_POOL, "pool") && !allCmds) {
            if (this.m_reboot) {
                reboot = true;
            }
            this.m_reboot = false;
        }
        if ((allCmds || keys.contains(BGP)) && this.makeSetCommand(cmds, null, BGP, "bgp")) {
            reboot = true;
        }
        if ((allCmds || keys.contains(BRI_SWITCH) || keys.contains(PRI_SWITCH)) && (this.makeSetCommand(cmds, null, BRI_SWITCH, "isdn-switch") || this.makeSetCommand(cmds, null, PRI_SWITCH, "isdn-switch"))) {
            reboot = true;
        }
        if (allCmds || keys.contains(CALL_CHECK)) {
            this.makeSetCommand(cmds, null, CALL_CHECK, "call-check");
        }
        if (allCmds || keys.contains(CHAP)) {
            this.makeSetCommand(cmds, null, CHAP, "chap");
        }
        if (allCmds || keys.contains(DEF_BROADCAST) || keys.contains(DEF_LISTEN)) {
            this.makeRIPCommand(cmds, null, "default", (String)this.get(DEF_BROADCAST), (String)this.get(DEF_LISTEN));
        }
        if (allCmds || keys.contains(DOMAIN)) {
            this.makeSetCommand(cmds, null, DOMAIN, "domain");
        }
        if (allCmds || keys.contains(HOST_1)) {
            this.makeSetCommand(cmds, null, HOST_1, "host 1");
        }
        if (allCmds || keys.contains(HOST_2)) {
            this.makeSetCommand(cmds, null, HOST_2, "host 2");
        }
        if (allCmds || keys.contains(HOST_3)) {
            this.makeSetCommand(cmds, null, HOST_3, "host 3");
        }
        if (allCmds || keys.contains(HOST_4)) {
            this.makeSetCommand(cmds, null, HOST_4, "host 4");
        }
        if ((allCmds || keys.contains(IP_GATEWAY) || keys.contains(IP_METRIC)) && (gateway = (String)this.get(IP_GATEWAY)) != null) {
            buf = new StringBuffer("set ");
            buf.append("gateway ");
            buf.append(gateway);
            metric = (String)this.get(IP_METRIC);
            if (metric != null && metric.length() > 0) {
                buf.append(" ");
                buf.append(metric);
                buf.append(" ");
            }
            cmds.addElement(new String(buf));
        }
        if (allCmds || keys.contains(IPX)) {
            this.makeSetCommand(cmds, null, IPX, "ipx");
        }
        if ((allCmds || keys.contains(IPX_GATEWAY) || keys.contains(IPX_METRIC)) && (gateway = (String)this.get(IPX_GATEWAY)) != null) {
            buf = new StringBuffer("set ");
            buf.append("ipxgate ");
            buf.append(gateway);
            metric = (String)this.get(IPX_METRIC);
            if (metric != null && metric.length() > 0) {
                buf.append(" ");
                buf.append(metric);
                buf.append(" ");
            }
            cmds.addElement(new String(buf));
        }
        if (allCmds || keys.contains(ISDN_MSN)) {
            this.makeSetCommand(cmds, null, ISDN_MSN, "isdn-msn");
        }
        if (allCmds || keys.contains(ISDN_NUM_AUTO)) {
            this.makeSetCommand(cmds, null, ISDN_NUM_AUTO, "isdn-numberauto");
        }
        if ((allCmds || keys.contains(L2TP_TYPE)) && (type = (String)this.get(L2TP_TYPE)) != null) {
            StringBuffer cmdbuf = new StringBuffer("set ");
            cmdbuf.append("l2tp ");
            if (type.equals("disable")) {
                cmdbuf.append(type);
            } else {
                cmdbuf.append("enable ");
                cmdbuf.append(type);
            }
            cmds.add(cmdbuf.toString());
            reboot = true;
        }
        if (allCmds || keys.contains(LOGHOST)) {
            this.makeSetCommand(cmds, null, LOGHOST, "loghost");
        }
        if (allCmds || keys.contains(MAX_PMC)) {
            this.makeSetCommand(cmds, null, MAX_PMC, "maximum pmconsole");
        }
        if ((allCmds || keys.contains(MCPPP_ENDPOINT)) && this.makeSetCommand(cmds, null, MCPPP_ENDPOINT, "endpoint")) {
            reboot = true;
        }
        if (allCmds || keys.contains(NAME_SERVICE)) {
            this.makeSetCommand(cmds, null, NAME_SERVICE, "namesvc");
        }
        if (allCmds || keys.contains(NAME_SERVER_ALT)) {
            this.makeSetCommand(cmds, null, NAME_SERVER_ALT, "nameserver 2");
        }
        if (allCmds || keys.contains(NAME_SERVER_PRI)) {
            this.makeSetCommand(cmds, null, NAME_SERVER_PRI, "nameserver");
        }
        if (allCmds || keys.contains(NETBIOS)) {
            this.makeSetCommand(cmds, null, NETBIOS, "netbios");
        }
        if (allCmds || keys.contains(NETBIOS_NS_ALT)) {
            this.makeSetCommand(cmds, null, NETBIOS_NS_ALT, "nbns 2");
        }
        if (allCmds || keys.contains(NETBIOS_NS_PRI)) {
            this.makeSetCommand(cmds, null, NETBIOS_NS_PRI, "nbns 1");
        }
        if ((allCmds || keys.contains(OSPF)) && this.makeSetCommand(cmds, null, OSPF, "ospf")) {
            reboot = true;
        }
        if (allCmds || keys.contains(PAP)) {
            this.makeSetCommand(cmds, null, PAP, "pap");
        }
        if (!allCmds && keys.contains(PASSWORD)) {
            this.makeSetCommand(cmds, null, PASSWORD, PASSWORD);
        }
        if (allCmds || keys.contains(PROXY_ARP)) {
            this.makeSetCommand(cmds, null, PROXY_ARP, "arp-proxy");
        }
        if (allCmds || keys.contains(REPORTED_IP)) {
            this.makeSetCommand(cmds, null, REPORTED_IP, "reported-ip");
        }
        if (allCmds || keys.contains(SERIAL_ADMIN)) {
            this.makeSetCommand(cmds, null, SERIAL_ADMIN, "serial-admin");
        }
        if ((allCmds || keys.contains(SNMP)) && this.makeSetCommand(cmds, null, SNMP, "snmp")) {
            reboot = true;
        }
        if (allCmds || keys.contains(TELNET_PORT)) {
            this.makeSetCommand(cmds, null, TELNET_PORT, "telnet");
        }
        if (allCmds || keys.contains(USER_NETMASK)) {
            this.makeSetCommand(cmds, null, USER_NETMASK, "user-netmask");
        }
        if (reboot) {
            cmds.addElement("save all");
            cmds.addElement("reboot");
        }
        return cmds.size() > start;
    }
}

