/*
 * Decompiled with CFR 0.152.
 */
package sunw.hotjava.doc;

import java.util.Vector;
import sunw.hotjava.doc.DocumentPanel;

public class DocumentPanelStack {
    int currIndex = -1;
    Vector docPanelStack = new Vector();

    public boolean canForward() {
        return this.currIndex + 1 < this.docPanelStack.size();
    }

    public synchronized DocumentPanel forward() {
        if (this.canForward()) {
            return (DocumentPanel)this.docPanelStack.elementAt(++this.currIndex);
        }
        return null;
    }

    public synchronized DocumentPanel getNext() {
        if (this.canForward()) {
            return (DocumentPanel)this.docPanelStack.elementAt(this.currIndex + 1);
        }
        return null;
    }

    public boolean canBack() {
        return this.currIndex > 0;
    }

    public synchronized DocumentPanel back() {
        if (this.canBack()) {
            return (DocumentPanel)this.docPanelStack.elementAt(this.currIndex--);
        }
        return null;
    }

    public synchronized DocumentPanel getPrevious() {
        if (this.canBack()) {
            return (DocumentPanel)this.docPanelStack.elementAt(this.currIndex - 1);
        }
        return null;
    }

    public synchronized DocumentPanel current() {
        if (this.docPanelStack.size() != 0) {
            return (DocumentPanel)this.docPanelStack.elementAt(this.currIndex);
        }
        return null;
    }

    public synchronized DocumentPanel elementAt(int n) {
        if (n >= 0 && n < this.docPanelStack.size()) {
            return (DocumentPanel)this.docPanelStack.elementAt(n);
        }
        return null;
    }

    public synchronized void push(DocumentPanel documentPanel) {
        ++this.currIndex;
        this.setSize(this.currIndex);
        this.docPanelStack.addElement(documentPanel);
    }

    public int size() {
        return this.docPanelStack.size();
    }

    public void setSize(int n) {
        this.docPanelStack.setSize(n);
    }

    public int currentIndex() {
        return this.currIndex;
    }

    public synchronized void clear() {
        this.docPanelStack.setSize(0);
        this.currIndex = -1;
    }
}

