/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.dTree;

import oracle.ewt.dTree.DTree;
import oracle.ewt.dTree.DTreeItem;
import oracle.ewt.dTree.DTreeRange;

public class DTreeRangeSet
implements Cloneable {
    private DTreeRange[] _ranges;

    public final void addRange(DTreeRange dTreeRange) {
        DTreeRange[] dTreeRangeArray = new DTreeRange[]{dTreeRange};
        this.addRanges(dTreeRangeArray);
    }

    public void addRanges(DTreeRange[] dTreeRangeArray) {
        int n;
        DTreeRange[] dTreeRangeArray2 = null;
        int n2 = 0;
        int n3 = n = dTreeRangeArray == null ? 0 : dTreeRangeArray.length;
        if (this._ranges == null) {
            dTreeRangeArray2 = dTreeRangeArray;
            n2 = n;
        } else {
            int n4 = this.getCount();
            n2 = n + n4;
            dTreeRangeArray2 = new DTreeRange[n2];
            System.arraycopy(dTreeRangeArray, 0, dTreeRangeArray2, 0, n);
            System.arraycopy(this._ranges, 0, dTreeRangeArray2, n, this._ranges.length);
        }
        dTreeRangeArray2 = this._normalizeRanges(dTreeRangeArray2, n2);
        this._ranges = dTreeRangeArray2;
    }

    public Object clone() {
        DTreeRangeSet dTreeRangeSet = new DTreeRangeSet();
        dTreeRangeSet.addRanges(this._ranges);
        return dTreeRangeSet;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof DTreeRangeSet)) {
            return false;
        }
        DTreeRangeSet dTreeRangeSet = (DTreeRangeSet)object;
        if (dTreeRangeSet.getCount() != this.getCount()) {
            return false;
        }
        int n = 0;
        int n2 = this.getCount();
        while (n < n2) {
            if (!this._ranges[n].equals(dTreeRangeSet.getRange(n))) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public int getCount() {
        if (this._ranges == null) {
            return 0;
        }
        return this._ranges.length;
    }

    public DTreeRange getRange(int n) {
        return this._ranges[n];
    }

    private DTreeRange[] _normalizeRanges(DTreeRange[] dTreeRangeArray, int n) {
        Object object;
        DTreeRange[] dTreeRangeArray2 = new DTreeRange[n];
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            int n4 = 0;
            object = dTreeRangeArray[n3];
            DTreeItem dTreeItem = ((DTreeRange)object).getParent();
            while (n4 < n2) {
                DTreeRange dTreeRange = dTreeRangeArray2[n4];
                DTreeItem dTreeItem2 = dTreeRange.getParent();
                if (dTreeItem == dTreeItem2) {
                    if (((DTreeRange)object).getStartIndex() < dTreeRange.getStartIndex()) {
                        System.arraycopy(dTreeRangeArray2, n4, dTreeRangeArray2, n4 + 1, n2 - n4);
                        dTreeRangeArray2[n4] = object;
                        ++n2;
                        break;
                    }
                } else if (DTree.isItemBefore(dTreeItem, dTreeItem2)) {
                    System.arraycopy(dTreeRangeArray2, n4, dTreeRangeArray2, n4 + 1, n2 - n4);
                    dTreeRangeArray2[n4] = object;
                    ++n2;
                    break;
                }
                ++n4;
            }
            if (n4 == n2) {
                dTreeRangeArray2[n4] = object;
                ++n2;
            }
            ++n3;
        }
        n3 = 0;
        while (n3 < n2) {
            DTreeRange dTreeRange = dTreeRangeArray2[n3];
            object = dTreeRange.getParent();
            int n5 = dTreeRange.getStartIndex();
            int n6 = dTreeRange.getCount();
            if (n6 <= 0) {
                System.arraycopy(dTreeRangeArray2, n3 + 1, dTreeRangeArray2, n3, n2 - (n3 + 1));
                --n2;
                continue;
            }
            int n7 = n3 + 1;
            while (n7 < n2 && object == dTreeRangeArray2[n7].getParent()) {
                DTreeRange dTreeRange2 = dTreeRangeArray2[n7];
                int n8 = dTreeRange2.getStartIndex();
                int n9 = dTreeRange2.getCount();
                if (n8 > n5 + n6) break;
                n6 = Math.max(n6, n8 + n9 - n5);
                dTreeRangeArray2[n3] = new DTreeRange((DTreeItem)object, n5, n6);
                System.arraycopy(dTreeRangeArray2, n7 + 1, dTreeRangeArray2, n7, n2 - (n7 + 1));
                --n2;
            }
            ++n3;
        }
        if (n2 < dTreeRangeArray2.length) {
            DTreeRange[] dTreeRangeArray3 = new DTreeRange[n2];
            System.arraycopy(dTreeRangeArray2, 0, dTreeRangeArray3, 0, n2);
            dTreeRangeArray2 = dTreeRangeArray3;
        }
        return dTreeRangeArray2;
    }
}

