/*
 * Decompiled with CFR 0.152.
 */
import com.lucent.ra.nms.model.LEPortMaster;
import com.lucent.ra.nms.ui.LECompGrid;
import com.lucent.ra.nms.ui.LEFont;
import com.lucent.ra.nms.ui.LEScrollPanel;
import com.lucent.ra.nms.ui.LEScrollablePanel;
import com.lucent.ra.nms.ui.LEUiUtils;
import com.lucent.ra.nms.util.LEAppInfo;
import com.lucent.ra.nms.util.LEDebug;
import com.lucent.ra.nms.view.LEViewEvent;
import com.lucent.ra.nms.view.LEViewListener;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Choice;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class LEGraphSessionsView
extends Panel
implements LEPMView,
ActionListener {
    LEPortMaster[] m_pms;
    LEViewListener m_listener;
    LEScrollPanel m_panel;
    LEScrollablePanel m_spanel;
    Panel m_buttons;
    Button m_browse;
    Choice m_pmChoice;
    TextField m_log;
    TextField m_time;
    Checkbox m_mins;
    Checkbox m_secs;

    public LEGraphSessionsView() {
        Font font = LEFont.getBoldFont();
        this.setLayout(new BorderLayout());
        Component[][] componentArray = new Component[4][3];
        Label label = new Label("Device:");
        componentArray[0][0] = label;
        label.setFont(font);
        label = new Label("Update Interval:");
        componentArray[1][0] = label;
        label.setFont(font);
        label = new Label("Log:");
        componentArray[2][0] = label;
        label.setFont(font);
        label = new Label("Log Format:");
        componentArray[3][0] = label;
        label.setFont(font);
        this.m_pmChoice = new Choice();
        componentArray[0][1] = this.m_pmChoice;
        componentArray[1][1] = this.createTimePanel();
        this.m_log = new TextField(40);
        componentArray[2][1] = this.m_log;
        componentArray[3][1] = new Label("YYYYMMDDHHMMSS,Total,ISDN,56k,v34,Other");
        this.m_browse = new Button("Browse...");
        componentArray[2][2] = this.m_browse;
        this.m_browse.addActionListener(this);
        Panel panel = new Panel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        panel.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        LECompGrid lECompGrid = new LECompGrid(componentArray, 2, false);
        panel.add(lECompGrid);
        gridBagLayout.setConstraints(lECompGrid, gridBagConstraints);
        this.add("Center", panel);
        this.m_spanel = new LEScrollablePanel(this, true, true);
        this.m_panel = new LEScrollPanel(this.m_spanel);
        this.m_buttons = new Panel();
        this.m_buttons.setLayout(new FlowLayout(1));
        Button button = new Button("Start...");
        button.addActionListener(this);
        this.m_buttons.add(button);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.m_browse) {
            FileDialog fileDialog = new FileDialog(LEUiUtils.GetBaseFrame(), "Session Data Log", 1);
            String string = LEAppInfo.getLastDirectory();
            if (string != null) {
                fileDialog.setDirectory(string);
            }
            fileDialog.show();
            string = fileDialog.getDirectory();
            String string2 = fileDialog.getFile();
            if (string2 != null) {
                String string3 = LEAppInfo.createFullPath(string, string2);
                ((TextComponent)this.m_log).setText(string3);
                LEAppInfo.setLastDirectory(string);
                return;
            }
        } else {
            if (this.m_pmChoice.getItemCount() == 0) {
                return;
            }
            int n = this.m_pmChoice.getSelectedIndex();
            int n2 = 5;
            try {
                n2 = Integer.parseInt(this.m_time.getText());
            }
            catch (Exception exception) {
                LEDebug.getLog().logln(20, exception);
            }
            boolean bl = this.m_secs.getState();
            if (bl) {
                n2 = Math.max(n2, 5);
            }
            LESessionsGraph lESessionsGraph = new LESessionsGraph(this.m_pms[n], this.m_log.getText(), n2, bl);
            if (this.m_listener != null) {
                LEViewEvent lEViewEvent = new LEViewEvent(10, lESessionsGraph);
                this.m_listener.onLEViewEvent(lEViewEvent);
            }
        }
    }

    public void setSelection(LEPortMaster[] lEPortMasterArray) {
        this.m_pms = lEPortMasterArray;
        this.m_pmChoice.removeAll();
        int n = 0;
        while (n < this.m_pms.length) {
            this.m_pmChoice.add(this.m_pms[n].getDescription());
            ++n;
        }
        this.m_pmChoice.invalidate();
        this.invalidate();
        this.validate();
    }

    public Component getMainPanel() {
        return this.m_panel;
    }

    public Component getBottomPanel() {
        return this.m_buttons;
    }

    public void going() {
    }

    public void gone() {
    }

    public void addListener(LEViewListener lEViewListener) {
        this.m_listener = lEViewListener;
    }

    public void deleteListener(LEViewListener lEViewListener) {
        if (this.m_listener == lEViewListener) {
            this.m_listener = null;
        }
    }

    Component createTimePanel() {
        Panel panel = new Panel();
        panel.setLayout(new FlowLayout(0, 0, 0));
        this.m_time = new TextField("5", 5);
        panel.add(this.m_time);
        CheckboxGroup checkboxGroup = new CheckboxGroup();
        this.m_secs = new Checkbox("seconds", checkboxGroup, true);
        panel.add(this.m_secs);
        this.m_mins = new Checkbox("minutes", checkboxGroup, false);
        panel.add(this.m_mins);
        return panel;
    }
}

