/*
 * Decompiled with CFR 0.152.
 */
import com.lucent.ra.nms.amf.LEAMFactory;
import com.lucent.ra.nms.backend.LEMonEthersMessage;
import com.lucent.ra.nms.backend.LEStatusMessage;
import com.lucent.ra.nms.util.LEAlphaNumericCompare;

public class LEMonEthersView
extends LEMonitorPanel {
    static int[] s_monitors = null;

    public LEMonEthersView() {
        this.initialize(1, 3, 7);
        this.setCellJustification(1, 2);
        int n = this.getNumColumns();
        int n2 = 2;
        while (n2 < n) {
            this.setCellJustification(n2, 2);
            ++n2;
        }
        this.m_resetCols = new int[7];
        int n3 = 0;
        while (n3 < 7) {
            this.m_resetCols[n3] = n3 + 3;
            ++n3;
        }
        this.setSortObject(2, new LEAlphaNumericCompare());
    }

    public synchronized void update(LEAMFactory lEAMFactory, String string, Object object) {
        if (this.m_pms == null) {
            return;
        }
        if (object instanceof LEMonEthersMessage) {
            LEMonEthersMessage lEMonEthersMessage = (LEMonEthersMessage)object;
            String string2 = String.valueOf(lEMonEthersMessage.getBoard()) + lEMonEthersMessage.getName();
            Integer n = this.getRow(string, string2);
            if (n == null) {
                this.createRow(string, string2, lEMonEthersMessage);
                return;
            }
            this.updateRow(n, lEMonEthersMessage);
            return;
        }
        if (object instanceof LEStatusMessage) {
            this.updateStatus(string, (LEStatusMessage)object);
        }
    }

    void createColumnTitles(int n, int n2, Object[] objectArray) {
        objectArray[n2++] = new String("Board");
        objectArray[n2++] = new String("Ethernet");
        objectArray[n2++] = new String("In Packets");
        objectArray[n2++] = new String("Out Packets");
        objectArray[n2++] = new String("In Errors");
        objectArray[n2++] = new String("Out Errors");
        objectArray[n2++] = new String("Collisions");
        objectArray[n2++] = new String("Resets");
        objectArray[n2++] = new String("Queued");
    }

    void createRow(String string, String string2, LEMonEthersMessage lEMonEthersMessage) {
        Object[] objectArray = new Object[this.getNumColumns()];
        int n = 0;
        objectArray[n++] = this.getPM(string).getDescription();
        objectArray[n++] = lEMonEthersMessage.getBoard();
        objectArray[n++] = lEMonEthersMessage.getName();
        objectArray[n++] = new Long(lEMonEthersMessage.getInPackets());
        objectArray[n++] = new Long(lEMonEthersMessage.getOutPackets());
        objectArray[n++] = new Long(lEMonEthersMessage.getInErrors());
        objectArray[n++] = new Long(lEMonEthersMessage.getOutErrors());
        objectArray[n++] = new Long(lEMonEthersMessage.getCollisions());
        objectArray[n++] = new Long(lEMonEthersMessage.getResets());
        objectArray[n++] = new Long(lEMonEthersMessage.getQueue());
        this.addRow(string, string2, objectArray);
    }

    void updateRow(int n, LEMonEthersMessage lEMonEthersMessage) {
        int n2 = 0;
        ++n2;
        ++n2;
        ++n2;
        LEMonitorData lEMonitorData = (LEMonitorData)this.getRowObject(n);
        if (lEMonitorData == null) {
            return;
        }
        this.setCellItem(n, n2, lEMonitorData.getCounter(n2, lEMonEthersMessage.getInPackets()));
        this.setCellItem(n, ++n2, lEMonitorData.getCounter(n2, lEMonEthersMessage.getOutPackets()));
        this.setCellItem(n, ++n2, lEMonitorData.getCounter(n2, lEMonEthersMessage.getInErrors()));
        this.setCellItem(n, ++n2, lEMonitorData.getCounter(n2, lEMonEthersMessage.getOutErrors()));
        this.setCellItem(n, ++n2, lEMonitorData.getCounter(n2, lEMonEthersMessage.getCollisions()));
        this.setCellItem(n, ++n2, lEMonitorData.getCounter(n2, lEMonEthersMessage.getResets()));
        this.setCellItem(n, ++n2, lEMonitorData.getCounter(n2, lEMonEthersMessage.getQueue()));
    }

    int[] getMonitorEntities() {
        if (s_monitors == null) {
            s_monitors = new int[1];
            LEMonEthersView.s_monitors[0] = 720896;
        }
        return s_monitors;
    }

    String getMonitorName() {
        return "Monitor Ethernets";
    }
}

