/*
 * Decompiled with CFR 0.152.
 */
import com.lucent.ra.nms.forms.LENewEntry;
import com.lucent.ra.nms.forms.LETableForm;
import com.lucent.ra.nms.model.LEConfig;
import com.lucent.ra.nms.model.LEPortMaster;
import com.lucent.ra.nms.ui.LEClipboard;
import com.lucent.ra.nms.ui.LEMLEvent;
import com.lucent.ra.nms.ui.LEMLListener;
import com.lucent.ra.nms.ui.LEScrollPanel;
import com.lucent.ra.nms.util.LEObservable;
import com.lucent.ra.nms.util.LEObserver;
import com.lucent.ra.nms.util.LEVector;
import com.lucent.ra.nms.view.LEViewEvent;
import com.lucent.ra.nms.view.LEViewListener;
import java.awt.Button;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class LETableView
implements LEModelView,
ActionListener,
LEMLListener,
LEObserver,
Runnable {
    public static final String ACTION_ADD = "add";
    public static final String ACTION_COPY = "copy";
    public static final String ACTION_CUT = "cut";
    public static final String ACTION_DELETE = "delete";
    public static final String ACTION_EDIT = "edit";
    public static final String ACTION_PASTE = "paste";
    public static final String ACTION_REFRESH = "refresh";
    public static final String ACTION_RENAME = "rename";
    LEViewListener m_listener;
    String m_action;
    LETableForm m_form = new LETableForm();
    LEScrollPanel m_panel;
    Panel m_buttons;
    Button m_edit;
    Button m_rename;
    Button m_delete;

    public LETableView() {
        LEClipboard.GetClipboard().addObserver(this);
    }

    public void setContext(LEVector lEVector) {
        Button button;
        this.m_form.setContext(lEVector);
        this.m_form.addListener(this);
        this.m_panel = new LEScrollPanel(this.m_form);
        this.m_buttons = new Panel();
        this.m_buttons.setLayout(new FlowLayout(1));
        Panel panel = new Panel();
        boolean bl = this.m_form.isKeyReadonly();
        boolean bl2 = this.m_form.isSimpleTable();
        boolean bl3 = this.m_form.canRenameEntries();
        int n = 4;
        if (bl2) {
            --n;
        }
        if (bl) {
            n -= 2;
        }
        panel.setLayout(new GridLayout(1, n, 10, 10));
        if (!bl) {
            panel.setLayout(new GridLayout(1, 4, 10, 10));
            button = new Button("Add...");
            panel.add(button);
            button.setActionCommand(ACTION_ADD);
            button.addActionListener(this);
        }
        if (!bl2) {
            this.m_edit = new Button("Edit...");
            panel.add(this.m_edit);
            this.m_edit.setActionCommand(ACTION_EDIT);
            this.m_edit.addActionListener(this);
            this.m_edit.setEnabled(false);
        }
        if (bl3) {
            this.m_rename = new Button("Rename...");
            panel.add(this.m_rename);
            this.m_rename.setActionCommand(ACTION_RENAME);
            this.m_rename.addActionListener(this);
            this.m_rename.setEnabled(false);
        }
        if (!bl) {
            this.m_delete = new Button("Delete");
            panel.add(this.m_delete);
            this.m_delete.setActionCommand(ACTION_DELETE);
            this.m_delete.addActionListener(this);
            this.m_delete.setEnabled(false);
        }
        button = new Button("Refresh");
        panel.add(button);
        button.setActionCommand(ACTION_REFRESH);
        button.addActionListener(this);
        this.m_buttons.add(panel);
    }

    public void onLEMLEvent(LEMLEvent lEMLEvent) {
        if (lEMLEvent.getType() == 6) {
            if (this.m_edit.isEnabled()) {
                this.edit(lEMLEvent.getRow());
                return;
            }
        } else if (lEMLEvent.getType() == 3) {
            this.setState();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(ACTION_EDIT)) {
            int[] nArray = this.m_form.getSelectedRows();
            if (nArray.length == 1) {
                this.edit(nArray[0]);
                return;
            }
        } else if (string.equals(ACTION_RENAME)) {
            int[] nArray = this.m_form.getSelectedRows();
            if (nArray.length == 1) {
                this.m_form.rename();
                return;
            }
        } else {
            this.dispatch(string);
        }
    }

    public void update(LEObservable lEObservable, Object object) {
        if (object instanceof Integer) {
            Integer n = (Integer)object;
            if (n == LEClipboard.CUT) {
                this.dispatch(ACTION_CUT);
                return;
            }
            if (n == LEClipboard.COPY) {
                this.copy();
                return;
            }
            if (n == LEClipboard.PASTE) {
                this.dispatch(ACTION_PASTE);
                return;
            }
            if (n == LEClipboard.DELETE) {
                this.dispatch(ACTION_DELETE);
                return;
            }
            if (n == LEClipboard.CONTENT) {
                this.checkClipboard();
            }
        }
    }

    public void dispatch(String string) {
        this.lock();
        this.m_action = string;
        new Thread((Runnable)this, "LETableView.dispatch").start();
    }

    public void lock() {
        this.m_buttons.setEnabled(false);
        this.m_form.setEnabled(false);
        if (this.m_listener != null) {
            this.m_listener.onLEViewEvent(new LEViewEvent(8, null));
        }
    }

    public void unlock() {
        if (this.m_listener != null) {
            this.m_listener.onLEViewEvent(new LEViewEvent(9, null));
        }
        this.m_buttons.setEnabled(true);
        this.m_form.setEnabled(true);
    }

    public void run() {
        this.handleAction(this.m_action);
        this.m_action = null;
        this.unlock();
    }

    public void handleAction(String string) {
        if (string.equals(ACTION_ADD)) {
            LEVector lEVector = this.m_form.add();
            if (lEVector.size() == 1 && this.m_listener != null && this.m_edit != null) {
                LENewEntry lENewEntry = (LENewEntry)lEVector.elementAt(0);
                this.m_listener.onLEViewEvent(new LEConfigViewEvent(1, lENewEntry.getTable(), lENewEntry.getKey()));
                return;
            }
        } else {
            if (string.equals(ACTION_CUT)) {
                this.cut();
                return;
            }
            if (string.equals(ACTION_DELETE)) {
                this.delete();
                return;
            }
            if (string.equals(ACTION_PASTE)) {
                this.paste();
                return;
            }
            if (string.equals(ACTION_REFRESH)) {
                this.m_form.refresh();
            }
        }
    }

    public void setSelection(LEPortMaster[] lEPortMasterArray) {
        this.m_form.setPortMasters(lEPortMasterArray);
    }

    public Component getMainPanel() {
        return this.m_panel;
    }

    public Component getBottomPanel() {
        return this.m_buttons;
    }

    public void going() {
        this.m_form.deleteListener(this);
        LEClipboard.GetClipboard().deleteObserver(this);
    }

    public void gone() {
        this.m_form.gone();
    }

    public void addListener(LEViewListener lEViewListener) {
        this.m_listener = lEViewListener;
    }

    public void deleteListener(LEViewListener lEViewListener) {
        if (this.m_listener == lEViewListener) {
            this.m_listener = null;
        }
    }

    void edit(int n) {
        if (this.m_listener == null) {
            return;
        }
        String string = (String)this.m_form.getCellItem(n, 0);
        String string2 = (String)this.m_form.getCellItem(n, 1);
        this.m_listener.onLEViewEvent(new LEConfigViewEvent(1, this.m_form.getTable(string), string2));
    }

    void setState() {
        int[] nArray = this.m_form.getSelectedRows();
        if (nArray.length > 0) {
            if (this.m_delete != null) {
                this.m_delete.setEnabled(true);
            }
            if (this.m_edit != null) {
                if (nArray.length == 1) {
                    this.m_edit.setEnabled(true);
                } else {
                    this.m_edit.setEnabled(false);
                }
            }
            if (this.m_rename != null) {
                if (nArray.length == 1) {
                    this.m_rename.setEnabled(true);
                } else {
                    this.m_rename.setEnabled(false);
                }
            }
        } else {
            if (this.m_delete != null) {
                this.m_delete.setEnabled(false);
            }
            if (this.m_edit != null) {
                this.m_edit.setEnabled(false);
            }
            if (this.m_rename != null) {
                this.m_rename.setEnabled(false);
            }
        }
        this.checkClipboard();
    }

    void cut() {
        this.copy();
        this.delete();
    }

    void copy() {
        int[] nArray = this.m_form.getSelectedRows();
        if (nArray.length > 1) {
            LEVector lEVector = new LEVector();
            int n = 0;
            while (n < nArray.length) {
                Object object = this.m_form.getEntry(nArray[n]);
                if (object instanceof LEConfig) {
                    object = ((LEConfig)object).clone();
                }
                lEVector.addElement(object);
                ++n;
            }
            LEClipboard.GetClipboard().setContents(lEVector);
            return;
        }
        if (nArray.length == 1) {
            Object object = this.m_form.getEntry(nArray[0]);
            if (object instanceof LEConfig) {
                object = ((LEConfig)object).clone();
            }
            LEClipboard.GetClipboard().setContents(object);
        }
    }

    void paste() {
        Object object = LEClipboard.GetClipboard().getContents();
        if (object != null) {
            this.m_form.paste(object);
        }
    }

    void delete() {
        this.m_form.delete();
    }

    void checkClipboard() {
        int[] nArray;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        LEClipboard lEClipboard = LEClipboard.GetClipboard();
        Object object = lEClipboard.getContents();
        if (this.pasteable(object)) {
            bl3 = true;
        }
        if ((nArray = this.m_form.getSelectedRows()).length > 0) {
            bl2 = true;
            if (this.m_delete != null) {
                bl = true;
                bl4 = true;
            }
        }
        lEClipboard.setState(bl, bl2, bl3, bl4);
    }

    boolean pasteable(Object object) {
        return false;
    }
}

