/*
 * Decompiled with CFR 0.152.
 */
import com.lucent.ra.nms.model.LEDataSpec;
import com.lucent.ra.nms.model.LEDataSpecFactory;
import com.lucent.ra.nms.model.LEPortMaster;
import com.lucent.ra.nms.ui.LETreeItem;
import com.lucent.ra.nms.util.LEDebug;
import com.lucent.ra.nms.util.LEStatusManager;
import com.lucent.ra.nms.util.LEVector;
import java.awt.Component;
import java.awt.Panel;

public class LEViewFactory {
    static LEMainView m_pmMain;
    static LEMaintainView m_pmMaintain;
    static LEConfigsView m_pmConfigs;
    static LEDiagnoseView m_pmDiagnose;
    static LECommandView m_pmCommand;
    static LESaveView m_pmSave;
    static LEUpgradeView m_pmUpgrade;
    static LERestoreView m_pmRestore;
    static LEGraphView m_pmGraph;
    static LEMainView m_itsMain;
    static LEMaintainView m_itsMaintain;
    static LEConfigsView m_itsConfigs;
    static LECommandView m_itsCommand;
    static LESaveView m_itsSave;
    static LEUpgradeView m_itsUpgrade;
    static LERestoreView m_itsRestore;
    LEConsole m_console;
    LEDataSpecFactory m_specFactory;

    public LEViewFactory(LEConsole lEConsole, LEDataSpecFactory lEDataSpecFactory) {
        this.m_console = lEConsole;
        this.m_specFactory = lEDataSpecFactory;
    }

    public LEPMView getView(LEControlTree lEControlTree, LEPortMaster[] lEPortMasterArray) {
        LEStatusManager.SetStatus("Building display...");
        LEPMView lEPMView = null;
        LEVector lEVector = lEControlTree.getContext();
        if (lEVector.size() > 0) {
            String string = (String)lEVector.removeElementAt(0);
            if (string.equals("pm")) {
                lEPMView = this.getPortMasterView(lEControlTree, lEVector, lEPortMasterArray);
            } else if (string.equals("its")) {
                lEPMView = this.getITSView(lEControlTree, lEVector, lEPortMasterArray);
            }
        }
        if (lEPMView != null) {
            lEPMView.setSelection(lEPortMasterArray);
        }
        return lEPMView;
    }

    public LEPMView getView(LEControlTree lEControlTree, LEPortMaster[] lEPortMasterArray, LEPortMaster lEPortMaster, String string) {
        LEPMView lEPMView = this.getView(lEControlTree, lEPortMasterArray);
        if (lEPMView instanceof LEMonitorDetailPanel) {
            LEMonitorDetailPanel lEMonitorDetailPanel = (LEMonitorDetailPanel)lEPMView;
            if (lEPortMaster != null && string != null) {
                LEMonitorDetailPanel.Display(lEPortMaster.getResourceID(), string);
            }
            lEMonitorDetailPanel.setSelection(lEPortMasterArray);
        }
        return lEPMView;
    }

    LEPMView getPortMasterView(LEControlTree lEControlTree, LEVector lEVector, LEPortMaster[] lEPortMasterArray) {
        LEPMView lEPMView = null;
        if (lEVector.size() > 0) {
            String string = (String)lEVector.removeElementAt(0);
            if (string.equals(LEControlTree.MONITOR)) {
                lEPMView = this.getPMMonitorView(lEVector);
            } else if (string.equals(LEControlTree.GRAPHS)) {
                lEPMView = this.getPMGraphView(lEVector, lEPortMasterArray);
            } else if (string.equals(LEControlTree.DIAGNOSE)) {
                lEPMView = this.getPMDiagnoseView(lEVector, lEPortMasterArray);
            } else if (string.equals(LEControlTree.MAINTAIN)) {
                lEPMView = this.getPMMaintainView(lEVector, lEPortMasterArray);
            } else if (string.equals(LEControlTree.COMMAND)) {
                lEPMView = this.getPMCommandView();
            } else if (string.equals(LEControlTree.CONFIG)) {
                lEPMView = this.getPMConfigView(lEControlTree.getSelectedItem(), lEVector, lEPortMasterArray);
            }
        } else {
            if (m_pmMain == null) {
                m_pmMain = new LEMainView(this.m_console);
            } else {
                m_pmMain.getMainPanel().setVisible(true);
            }
            lEPMView = m_pmMain;
        }
        return lEPMView;
    }

    LEPMView getPMMonitorView(LEVector lEVector) {
        LEPMView lEPMView = null;
        if (lEVector.size() == 0) {
            lEPMView = new LEMonitorView();
        } else {
            String string = (String)lEVector.removeElementAt(0);
            if (string.equals(LEControlTree.STATUS)) {
                lEPMView = new LEMonStatusView();
            } else if (string.equals(LEControlTree.MON_USERS)) {
                lEPMView = new LEMonUsersNewView();
            } else if (string.equals(LEControlTree.MODEM_SUM)) {
                lEPMView = new LEModemSummaryView();
            } else if (string.equals(LEControlTree.SESSION_SUM)) {
                lEPMView = new LESessionSummaryView();
            } else if (string.equals(LEControlTree.SESSIONS)) {
                lEPMView = new LEMonSessionsView();
            } else if (string.equals(LEControlTree.MODEMS)) {
                lEPMView = new LEMonModemsView();
            } else if (string.equals(LEControlTree.LINES)) {
                lEPMView = new LEMonLinesView();
            } else if (string.equals(LEControlTree.IFACES)) {
                lEPMView = new LEMonIfacesView();
            } else if (string.equals(LEControlTree.NAT_SESS)) {
                lEPMView = new LEMonNATSessView();
            } else if (string.equals(LEControlTree.NAT_STATS)) {
                lEPMView = new LEMonNATStatsView();
            } else if (string.equals(LEControlTree.ALARMS)) {
                lEPMView = new LEMonAlarmsView();
            } else if (string.equals(LEControlTree.OSPF_NEIGHBOR)) {
                lEPMView = new LEMonOSPFNeighborView();
            } else if (string.equals(LEControlTree.OSPF_LINKS)) {
                lEPMView = new LEMonOSPFLinksView();
            } else if (string.equals(LEControlTree.L2TP)) {
                lEPMView = this.getPMVPNView(lEVector);
            } else if (string.equals(LEControlTree.MUX_CHANNELS)) {
                lEPMView = new LEMonMuxChannelView();
            } else if (string.equals(LEControlTree.MUX_STATS)) {
                lEPMView = new LEMonMuxStatsView();
            } else if (string.equals(LEControlTree.NET_CONN)) {
                lEPMView = new LEMonNetConnView();
            } else if (string.equals(LEControlTree.MON_ETHERS)) {
                lEPMView = new LEMonEthersView();
            }
        }
        return lEPMView;
    }

    LEPMView getPMVPNView(LEVector lEVector) {
        Component component = null;
        if (lEVector.size() == 0) {
            component = new LEVPNView();
        } else {
            String string = (String)lEVector.removeElementAt(0);
            if (string.equals(LEControlTree.L2TP_TUNNELS)) {
                component = new LEMonL2TPTunnelsView();
            } else if (string.equals(LEControlTree.L2TP_SESSIONS)) {
                component = new LEMonL2TPSessionsView();
            }
        }
        return component;
    }

    LEPMView getPMGraphView(LEVector lEVector, LEPortMaster[] lEPortMasterArray) {
        Panel panel = null;
        if (lEVector.size() == 0) {
            if (m_pmGraph == null) {
                m_pmGraph = new LEGraphView();
            } else {
                m_pmGraph.setVisible(true);
            }
            panel = m_pmGraph;
        } else {
            String string = (String)lEVector.removeElementAt(0);
            if (string.equals(LEControlTree.MODEM_GRAPH)) {
                panel = new LEGraphModemsView();
            } else if (string.equals(LEControlTree.SESSION_GRAPH)) {
                panel = new LEGraphSessionsView();
            }
        }
        return panel;
    }

    LEPMView getPMDiagnoseView(LEVector lEVector, LEPortMaster[] lEPortMasterArray) {
        Panel panel = null;
        if (lEVector.size() == 0) {
            if (m_pmDiagnose == null) {
                m_pmDiagnose = new LEDiagnoseView();
            } else {
                m_pmDiagnose.setVisible(true);
            }
            panel = m_pmDiagnose;
        } else {
            panel = new LEDebugView();
        }
        return panel;
    }

    LEPMView getPMMaintainView(LEVector lEVector, LEPortMaster[] lEPortMasterArray) {
        Panel panel = null;
        if (lEVector.size() == 0) {
            if (m_pmMaintain == null) {
                m_pmMaintain = new LEMaintainView();
            } else {
                m_pmMaintain.setVisible(true);
            }
            panel = m_pmMaintain;
        } else {
            String string = (String)lEVector.removeElementAt(0);
            if (string.equals(LEControlTree.SAVE)) {
                if (m_pmSave == null) {
                    m_pmSave = new LESaveView();
                } else {
                    m_pmSave.setVisible(true);
                }
                panel = m_pmSave;
            } else if (string.equals(LEControlTree.UPGRADE)) {
                if (m_pmUpgrade == null) {
                    m_pmUpgrade = new LEUpgradeView();
                } else {
                    m_pmUpgrade.setVisible(true);
                }
                panel = m_pmUpgrade;
            } else if (string.equals(LEControlTree.RESTORE)) {
                if (m_pmRestore == null) {
                    m_pmRestore = new LERestoreView();
                } else {
                    m_pmRestore.setVisible(true);
                }
                panel = m_pmRestore;
            }
        }
        return panel;
    }

    LEPMView getPMCommandView() {
        if (m_pmCommand == null) {
            m_pmCommand = new LECommandView();
        } else {
            m_pmCommand.setVisible(true);
        }
        return m_pmCommand;
    }

    LEPMView getPMConfigView(LETreeItem lETreeItem, LEVector lEVector, LEPortMaster[] lEPortMasterArray) {
        LEPMView lEPMView = null;
        if (lEVector.size() == 0) {
            if (m_pmConfigs == null) {
                m_pmConfigs = new LEConfigsView(lETreeItem);
            } else {
                m_pmConfigs.setVisible(true);
            }
            lEPMView = m_pmConfigs;
        } else {
            try {
                StringBuffer stringBuffer = new StringBuffer("Configuration");
                LEDataSpec lEDataSpec = this.m_specFactory.getSpec("pm");
                int n = lEVector.size();
                int n2 = 0;
                while (n2 < n) {
                    lEDataSpec = lEDataSpec.getSpecFor((String)lEVector.elementAt(n2));
                    stringBuffer.append(" - ");
                    stringBuffer.append(lEDataSpec.getDescription());
                    ++n2;
                }
                lEPMView = LEConfigViewFactory.GetView(lEVector);
            }
            catch (Exception exception) {
                LEDebug.getLog().logln(20, exception);
            }
        }
        return lEPMView;
    }

    LEPMView getITSView(LEControlTree lEControlTree, LEVector lEVector, LEPortMaster[] lEPortMasterArray) {
        LEPMView lEPMView = null;
        if (lEVector.size() > 0) {
            String string = (String)lEVector.removeElementAt(0);
            if (string.equals(LEControlTree.MONITOR)) {
                lEPMView = this.getITSMonitorView(lEVector);
            } else if (string.equals(LEControlTree.MAINTAIN)) {
                lEPMView = this.getITSMaintainView(lEVector, lEPortMasterArray);
            } else if (string.equals(LEControlTree.COMMAND)) {
                lEPMView = this.getITSCommandView();
            } else if (string.equals(LEControlTree.CONFIG)) {
                lEPMView = this.getITSConfigView(lEControlTree.getSelectedItem(), lEVector, lEPortMasterArray);
            }
        } else {
            if (m_itsMain == null) {
                m_itsMain = new LEMainView(this.m_console);
            } else {
                m_itsMain.getMainPanel().setVisible(true);
            }
            lEPMView = m_itsMain;
        }
        return lEPMView;
    }

    LEPMView getITSMonitorView(LEVector lEVector) {
        Component component = null;
        if (lEVector.size() == 0) {
            component = new LEMonitorView();
        } else {
            String string = (String)lEVector.removeElementAt(0);
            if (string.equals(LEControlTree.STATUS)) {
                component = new LEMonStatusView();
            } else if (string.equals(LEControlTree.LINES)) {
                component = new LEMonLinesView();
            } else if (string.equals(LEControlTree.IFACES)) {
                component = new LEMonIfacesView();
            } else if (string.equals(LEControlTree.ALARMS)) {
                component = new LEMonAlarmsView();
            }
        }
        return component;
    }

    LEPMView getITSMaintainView(LEVector lEVector, LEPortMaster[] lEPortMasterArray) {
        Panel panel = null;
        if (lEVector.size() == 0) {
            if (m_itsMaintain == null) {
                m_itsMaintain = new LEMaintainView();
            } else {
                m_itsMaintain.setVisible(true);
            }
            panel = m_itsMaintain;
        } else {
            String string = (String)lEVector.removeElementAt(0);
            if (string.equals(LEControlTree.SAVE)) {
                if (m_itsSave == null) {
                    m_itsSave = new LESaveView();
                } else {
                    m_itsSave.setVisible(true);
                }
                panel = m_itsSave;
            } else if (string.equals(LEControlTree.UPGRADE)) {
                if (m_itsUpgrade == null) {
                    m_itsUpgrade = new LEUpgradeView();
                } else {
                    m_itsUpgrade.setVisible(true);
                }
                panel = m_itsUpgrade;
            } else if (string.equals(LEControlTree.RESTORE)) {
                if (m_itsRestore == null) {
                    m_itsRestore = new LERestoreView();
                } else {
                    m_itsRestore.setVisible(true);
                }
                panel = m_itsRestore;
            }
        }
        return panel;
    }

    LEPMView getITSCommandView() {
        if (m_itsCommand == null) {
            m_itsCommand = new LECommandView();
        } else {
            m_itsCommand.setVisible(true);
        }
        return m_itsCommand;
    }

    LEPMView getITSConfigView(LETreeItem lETreeItem, LEVector lEVector, LEPortMaster[] lEPortMasterArray) {
        LEPMView lEPMView = null;
        if (lEVector.size() == 0) {
            if (m_itsConfigs == null) {
                m_itsConfigs = new LEConfigsView(lETreeItem);
            } else {
                m_itsConfigs.setVisible(true);
            }
            lEPMView = m_itsConfigs;
        } else {
            try {
                StringBuffer stringBuffer = new StringBuffer("Configuration");
                LEDataSpec lEDataSpec = this.m_specFactory.getSpec("its");
                int n = lEVector.size();
                int n2 = 0;
                while (n2 < n) {
                    lEDataSpec = lEDataSpec.getSpecFor((String)lEVector.elementAt(n2));
                    stringBuffer.append(" - ");
                    stringBuffer.append(lEDataSpec.getDescription());
                    ++n2;
                }
                lEPMView = LEConfigViewFactory.GetView(lEVector);
            }
            catch (Exception exception) {
                LEDebug.getLog().logln(20, exception);
            }
        }
        return lEPMView;
    }
}

