/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.backend;

import com.lucent.ra.nms.amf.LEAMManager_RI;
import com.lucent.ra.nms.amf.LEAMRouter_R;
import com.lucent.ra.nms.backend.LEConnectionManager_I;
import com.lucent.ra.nms.backend.LEConnectionManager_R;
import com.lucent.ra.nms.backend.LEDSS;
import com.lucent.ra.nms.backend.LEDSSException;
import com.lucent.ra.nms.backend.LEDSSFlatFile;
import com.lucent.ra.nms.backend.LEDSSPortMaster;
import com.lucent.ra.nms.backend.LEStatusMessage;
import com.lucent.ra.nms.backend.LETemplateDSSFlatFile;
import com.lucent.ra.nms.util.LEDebug;
import com.lucent.ra.nms.util.LEResourceID;
import com.lucent.ra.nms.util.LEVector;
import java.io.IOException;
import java.rmi.RemoteException;

public class LEConnectionManager {
    LEConnectionManager_I m_cm_i;
    LEConnectionManager_R m_cm_r;
    String m_id;
    String m_descr;
    static LEConnectionManager s_cm = null;

    public static LEConnectionManager Initialize() {
        if (s_cm == null) {
            s_cm = new LEConnectionManager();
        }
        return s_cm;
    }

    public static LEConnectionManager GetDefault() {
        return s_cm;
    }

    public LEConnectionManager() {
        this.m_cm_i = new LEConnectionManager_I();
        this.m_descr = this.m_id = "local";
    }

    public LEConnectionManager(String string, String string2, LEConnectionManager_R lEConnectionManager_R) {
        this.m_cm_r = lEConnectionManager_R;
        this.m_id = string;
        this.m_descr = string2;
    }

    public String getDescription() {
        return this.m_descr;
    }

    public String getResourceID() {
        return this.m_id;
    }

    public LEConnectionManager_I getLocalManager() {
        return this.m_cm_i;
    }

    public LEConnectionManager_R getRemoteManager() {
        return this.m_cm_r;
    }

    public boolean isConnected() {
        return this.m_cm_i != null || this.m_cm_r != null;
    }

    public LEAMRouter_R getAMRouter() {
        if (this.m_cm_i != null) {
            return this.m_cm_i.getAMRouter();
        }
        LEAMRouter_R lEAMRouter_R = null;
        try {
            if (this.m_cm_r != null) {
                lEAMRouter_R = this.m_cm_r.getAMRouter();
            }
        }
        catch (RemoteException remoteException) {
            this.handleRemoteException(remoteException);
        }
        return lEAMRouter_R;
    }

    public LEDSSPortMaster connectToPM(String string, String string2, String string3) throws IOException, LEDSSException {
        String string4 = LEResourceID.CreatePM_ID(string, string2);
        if (this.m_cm_i != null) {
            return new LEDSSPortMaster(this.m_id, string4, this.m_cm_i.connectToPM(string, string2, string3), string, string2, string3);
        }
        if (this.m_cm_r == null) {
            throw new LEDSSException("No connection to server");
        }
        LEAMManager_RI.GetManager().addID(this.getAMRouter(), string4);
        LEDSSPortMaster lEDSSPortMaster = null;
        try {
            lEDSSPortMaster = new LEDSSPortMaster(this.m_id, string4, this.m_cm_r.connectToPM(string, string2, string3), string, string2, string3);
        }
        catch (RemoteException remoteException) {
            LEAMManager_RI.GetManager().removeID(this.getAMRouter(), string4);
            this.handleRemoteException(remoteException);
        }
        catch (IOException iOException) {
            LEAMManager_RI.GetManager().removeID(this.getAMRouter(), string4);
            throw iOException;
        }
        catch (LEDSSException lEDSSException) {
            LEAMManager_RI.GetManager().removeID(this.getAMRouter(), string4);
            throw lEDSSException;
        }
        return lEDSSPortMaster;
    }

    public LEDSSFlatFile connectToFile(String string, int n) {
        String string2 = LEResourceID.CreateFile_ID(string);
        LEAMManager_RI.GetManager().addID(this.getAMRouter(), string2);
        if (this.m_cm_i != null) {
            return new LEDSSFlatFile(this.m_cm_i.connectToFile(string, n));
        }
        LEDSSFlatFile lEDSSFlatFile = null;
        try {
            if (this.m_cm_r != null) {
                lEDSSFlatFile = new LEDSSFlatFile(this.m_cm_r.connectToFile(string, n));
            }
        }
        catch (RemoteException remoteException) {
            LEAMManager_RI.GetManager().removeID(this.getAMRouter(), string2);
            this.handleRemoteException(remoteException);
        }
        return lEDSSFlatFile;
    }

    public LETemplateDSSFlatFile connectToTemplateFile(String string, int n, LEVector lEVector) {
        String string2 = LEResourceID.CreateFile_ID(string);
        LEAMManager_RI.GetManager().addID(this.getAMRouter(), string2);
        if (this.m_cm_i != null) {
            return new LETemplateDSSFlatFile(this.m_cm_i.connectToTemplateFile(string, n, lEVector));
        }
        LETemplateDSSFlatFile lETemplateDSSFlatFile = null;
        try {
            if (this.m_cm_r != null) {
                lETemplateDSSFlatFile = new LETemplateDSSFlatFile(this.m_cm_r.connectToTemplateFile(string, n, lEVector));
            }
        }
        catch (RemoteException remoteException) {
            LEAMManager_RI.GetManager().removeID(this.getAMRouter(), string2);
            this.handleRemoteException(remoteException);
        }
        return lETemplateDSSFlatFile;
    }

    public void disconnectFrom(LEDSS lEDSS) {
        LEStatusMessage lEStatusMessage = new LEStatusMessage(2);
        LEAMManager_RI.Process(lEDSS.getResourceID(), "STATUS", lEStatusMessage);
        LEAMManager_RI.GetManager().removeID(this.getAMRouter(), lEDSS.getResourceID());
        lEDSS.disconnect();
        if (this.m_cm_i != null) {
            this.m_cm_i.remove(lEDSS.getResourceID());
        }
    }

    public void remove(String string) {
        if (this.m_cm_i != null) {
            this.m_cm_i.remove(string);
        }
    }

    void handleRemoteException(RemoteException remoteException) {
        LEDebug.getLog().logln(20, remoteException);
        LEStatusMessage lEStatusMessage = new LEStatusMessage(2);
        LEAMManager_RI.Process(this.m_id, "STATUS", lEStatusMessage);
        this.m_cm_r = null;
    }
}

