/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.forms;

import com.lucent.ra.nms.forms.LEAddDialog;
import com.lucent.ra.nms.forms.LECmdErrorDialog;
import com.lucent.ra.nms.forms.LEFormLine;
import com.lucent.ra.nms.forms.LEFormLineFactory;
import com.lucent.ra.nms.forms.LENewEntry;
import com.lucent.ra.nms.forms.LETableForm;
import com.lucent.ra.nms.model.LEBGPPeer;
import com.lucent.ra.nms.model.LEBGPPeers;
import com.lucent.ra.nms.model.LEDataSpec;
import com.lucent.ra.nms.model.LEPortMaster;
import com.lucent.ra.nms.model.LETable;
import com.lucent.ra.nms.ui.LECompGrid;
import com.lucent.ra.nms.ui.LEErrorDialog;
import com.lucent.ra.nms.ui.LEFont;
import com.lucent.ra.nms.ui.LEUiUtils;
import com.lucent.ra.nms.util.LEAlphaNumericCompare;
import com.lucent.ra.nms.util.LEVector;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Label;
import java.awt.Panel;

public class LEBGPPeersForm
extends LETableForm {
    static final String PORTMASTER = "Device";
    static final String BLANK = "";
    String m_peer;
    String m_local;
    String m_asn;

    public LEBGPPeersForm() {
        this.m_keyReadonly = false;
    }

    public void setContext(LEVector lEVector) {
        this.m_context = lEVector;
        this.m_cols = 12;
        this.initialize(1, 2, this.m_cols);
        this.setSortable(0, true);
        this.setSortable(1, true);
        this.setSortable(2, true);
        this.setSortObject(1, new LEAlphaNumericCompare());
        Object[] objectArray = new String[this.m_cols + 2];
        objectArray[0] = PORTMASTER;
        objectArray[1] = "Destination Address";
        objectArray[2] = "Source Address";
        objectArray[3] = "ASN";
        objectArray[4] = "Easy Multihome";
        objectArray[5] = "Assume Default";
        objectArray[6] = "Hop Count";
        objectArray[7] = "State";
        objectArray[8] = "Confederation Member";
        objectArray[9] = "Route Reflector Client";
        objectArray[10] = "Always Next Hop";
        objectArray[11] = "Accept Policy";
        objectArray[12] = "Inject Policy";
        objectArray[13] = "Advertise Policy";
        this.setTitles(0, objectArray);
    }

    void addEntry(String string, LETable lETable, String string2) {
        Object[] objectArray = new Object[this.m_cols + 2];
        objectArray[0] = string;
        objectArray[1] = string2;
        Object object = lETable.get(string2);
        if (object instanceof LEBGPPeer) {
            LEBGPPeer lEBGPPeer = (LEBGPPeer)object;
            objectArray[2] = (String)lEBGPPeer.get("177");
            objectArray[3] = (String)lEBGPPeer.get("106");
            objectArray[4] = (String)lEBGPPeer.get("118");
            objectArray[5] = (String)lEBGPPeer.get("119");
            objectArray[6] = (String)lEBGPPeer.get("113");
            objectArray[7] = (String)lEBGPPeer.get("96");
            objectArray[8] = (String)lEBGPPeer.get("114");
            objectArray[9] = (String)lEBGPPeer.get("115");
            objectArray[10] = (String)lEBGPPeer.get("116");
            objectArray[11] = (String)lEBGPPeer.get("121");
            objectArray[12] = (String)lEBGPPeer.get("122");
            objectArray[13] = (String)lEBGPPeer.get("123");
        }
        this.addRow(objectArray);
    }

    boolean addNewEntry(LEDataSpec lEDataSpec, LEDataSpec lEDataSpec2) {
        Panel panel = new Panel();
        panel.setLayout(new BorderLayout());
        Component[][] componentArray = new Component[3][2];
        componentArray[0][0] = new Label("Peer Address:");
        componentArray[0][0].setFont(LEFont.getBoldFont());
        componentArray[0][1] = LEFormLineFactory.BuildFormLine(null, null, null, lEDataSpec);
        LEDataSpec lEDataSpec3 = lEDataSpec2.getSpecFor("177");
        componentArray[1][0] = new Label(String.valueOf(lEDataSpec3.getDescription()) + ":");
        componentArray[1][0].setFont(LEFont.getBoldFont());
        componentArray[1][1] = LEFormLineFactory.BuildFormLine(null, null, null, lEDataSpec3);
        lEDataSpec3 = lEDataSpec2.getSpecFor("106");
        componentArray[2][0] = new Label(String.valueOf(lEDataSpec3.getDescription()) + ":");
        componentArray[2][0].setFont(LEFont.getBoldFont());
        componentArray[2][1] = LEFormLineFactory.BuildFormLine(null, null, null, lEDataSpec3);
        panel.add("Center", new LECompGrid(componentArray, 2, false));
        LEAddDialog lEAddDialog = new LEAddDialog(LEUiUtils.GetBaseFrame(), "Add BGP Peer", panel);
        if (lEAddDialog.okay()) {
            this.m_peer = ((LEFormLine)((Object)componentArray[0][1])).getValue();
            this.m_local = ((LEFormLine)((Object)componentArray[1][1])).getValue();
            this.m_asn = ((LEFormLine)((Object)componentArray[2][1])).getValue();
            if (this.m_peer.length() == 0) {
                new LEErrorDialog(LEUiUtils.GetBaseFrame(), "A peer address must be entered");
                return false;
            }
            if (this.m_local.length() == 0) {
                new LEErrorDialog(LEUiUtils.GetBaseFrame(), "A local address must be entered");
                return false;
            }
            if (this.m_asn.length() == 0) {
                new LEErrorDialog(LEUiUtils.GetBaseFrame(), "An asn id must be entered");
                return false;
            }
            return true;
        }
        return false;
    }

    LENewEntry addNewEntryTo(LEPortMaster lEPortMaster) {
        LENewEntry lENewEntry = null;
        LETable lETable = this.getTable(lEPortMaster);
        if (lETable.get(this.m_peer) == null) {
            LEVector lEVector = ((LEBGPPeers)lETable).add(this.m_peer, this.m_local, this.m_asn);
            if (lEVector != null) {
                new LECmdErrorDialog(LEUiUtils.GetBaseFrame(), lEPortMaster.getConnectionFacade(), lEVector);
            } else {
                this.addEntry(lEPortMaster.getDescription(), lETable, this.m_peer);
                lENewEntry = new LENewEntry(lEPortMaster, lETable, this.m_peer);
            }
        } else {
            new LEErrorDialog(LEUiUtils.GetBaseFrame(), String.valueOf(lEPortMaster.getDescription()) + " already contains the BGP peer with address " + this.m_peer);
        }
        return lENewEntry;
    }

    void delete(LEPortMaster lEPortMaster, LETable lETable, String string) {
        if (!(lETable instanceof LEBGPPeers)) {
            return;
        }
        LEBGPPeers lEBGPPeers = (LEBGPPeers)lETable;
        LEVector lEVector = lEBGPPeers.delete(string);
        if (lEVector != null) {
            new LECmdErrorDialog(LEUiUtils.GetBaseFrame(), lEPortMaster.getConnectionFacade(), lEVector);
        }
    }

    String getPasteKey(LEPortMaster lEPortMaster, Object object) {
        String string;
        String string2;
        LEVector lEVector;
        String string3;
        if (!(object instanceof LEBGPPeer)) {
            return null;
        }
        LEBGPPeer lEBGPPeer = (LEBGPPeer)object;
        LEBGPPeers lEBGPPeers = (LEBGPPeers)this.getTable(lEPortMaster);
        if (lEBGPPeers.get(string3 = lEBGPPeer.getName()) != null) {
            string3 = LETableForm.GetUniqueKey(lEBGPPeers, string3, 16);
        }
        if ((lEVector = lEBGPPeers.add(string3, string2 = (String)lEBGPPeer.get("177"), string = (String)lEBGPPeer.get("106"))) != null) {
            new LECmdErrorDialog(LEUiUtils.GetBaseFrame(), lEPortMaster.getConnectionFacade(), lEVector);
            string3 = null;
        }
        return string3;
    }
}

