/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.forms;

import com.lucent.ra.nms.forms.LEFormLine;
import com.lucent.ra.nms.forms.LEFormLineFactory;
import com.lucent.ra.nms.forms.LEStringFormLine;
import com.lucent.ra.nms.model.LEConfig;
import com.lucent.ra.nms.model.LEDataSpec;
import com.lucent.ra.nms.model.LEPortMaster;
import com.lucent.ra.nms.model.LEPrefixes;
import com.lucent.ra.nms.util.LEVector;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

public class LEPrefixesPanel
extends Panel
implements ItemListener,
ActionListener {
    LEPortMaster m_pm;
    LEPrefixes m_ordered;
    LEFormLine m_fl;
    List m_list;
    Button m_add;
    Button m_insert;
    Button m_delete;

    public LEPrefixesPanel(LEPortMaster lEPortMaster, LEVector lEVector) {
        this.setLayout(new BorderLayout(5, 5));
        this.m_pm = lEPortMaster;
        LEConfig lEConfig = lEPortMaster;
        int n = lEVector.size();
        int n2 = 0;
        while (lEConfig != null && n2 < n) {
            Object object = ((LEConfig)lEConfig).get((String)lEVector.elementAt(n2));
            lEConfig = object instanceof LEConfig ? (LEConfig)object : null;
            ++n2;
        }
        String string = lEPortMaster.getDescription();
        this.add("North", new Label(string, 1));
        if (lEConfig instanceof LEPrefixes) {
            this.m_ordered = (LEPrefixes)lEConfig;
            this.m_list = new List();
            this.add("Center", this.m_list);
            Panel panel = new Panel();
            panel.setLayout(new BorderLayout());
            Panel panel2 = new Panel();
            panel2.setLayout(new BorderLayout());
            LEDataSpec lEDataSpec = this.m_ordered.getSpecFor("entry");
            Component component = LEFormLineFactory.BuildFormLine(this.m_pm, "entry", "", lEDataSpec);
            if (!(component instanceof LEFormLine)) {
                component = new LEStringFormLine();
            }
            this.m_fl = (LEFormLine)((Object)component);
            panel2.add("Center", component);
            panel.add("North", panel2);
            Panel panel3 = new Panel();
            panel3.setLayout(new GridLayout(1, 3, 5, 5));
            this.m_add = new Button("Add");
            panel3.add(this.m_add);
            this.m_add.addActionListener(this);
            this.m_insert = new Button("Insert");
            panel3.add(this.m_insert);
            this.m_insert.setEnabled(false);
            this.m_insert.addActionListener(this);
            this.m_delete = new Button("Delete");
            panel3.add(this.m_delete);
            this.m_delete.setEnabled(false);
            this.m_delete.addActionListener(this);
            panel.add("South", panel3);
            this.add("South", panel);
            this.fillList();
        }
    }

    public LEPrefixes getPrefixes() {
        return this.m_ordered;
    }

    public LEPortMaster getPortMaster() {
        return this.m_pm;
    }

    public void ok() {
        if (this.m_ordered == null) {
            return;
        }
        this.m_ordered.deleteAll();
        int n = this.m_list.getItemCount();
        int n2 = 0;
        while (n2 < n) {
            this.m_ordered.add(this.m_list.getItem(n2));
            ++n2;
        }
        this.m_ordered.setChgFlag(false);
        this.m_ordered.setPlansChgFlag(true);
    }

    public void cancel() {
        if (this.m_ordered == null) {
            return;
        }
        this.m_list.removeAll();
        this.fillList();
        this.m_ordered.setChgFlag(false);
    }

    public void gone() {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.m_add) {
            String string = this.m_fl.getValue();
            if (string != null && !string.equals("")) {
                this.m_list.add(string);
                this.m_list.select(this.m_list.getItemCount() - 1);
                this.setState();
                this.m_ordered.setChgFlag(true);
                return;
            }
        } else {
            if (object == this.m_insert) {
                String string;
                int n = this.m_list.getSelectedIndex();
                if (n > -1 && (string = this.m_fl.getValue()) != null && !string.equals("")) {
                    this.m_list.add(string, n);
                    this.m_list.select(n);
                    this.m_ordered.setChgFlag(true);
                }
                this.setState();
                return;
            }
            if (object == this.m_delete) {
                int n = this.m_list.getSelectedIndex();
                if (n > -1) {
                    this.m_list.remove(n);
                    this.m_ordered.setChgFlag(true);
                    if (n > 0) {
                        this.m_list.select(n - 1);
                    } else if (this.m_list.getItemCount() > 0) {
                        this.m_list.select(0);
                    }
                }
                this.setState();
            }
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        int n = itemEvent.getStateChange();
        if (n == 1 || n == 2) {
            this.setState();
        }
    }

    void fillList() {
        if (this.m_ordered == null) {
            return;
        }
        int n = this.m_ordered.length();
        int n2 = 0;
        while (n2 < n) {
            this.m_list.addItem((String)this.m_ordered.get(n2));
            ++n2;
        }
        this.m_list.addItemListener(this);
    }

    void setState() {
        int n = this.m_list.getSelectedIndex();
        if (n > -1) {
            this.m_insert.setEnabled(true);
            this.m_delete.setEnabled(true);
            this.m_fl.setValue(this.m_list.getItem(n));
            return;
        }
        this.m_insert.setEnabled(false);
        this.m_delete.setEnabled(false);
    }
}

