/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.amf;

import com.lucent.ra.nms.amf.LEAMManager_R;
import com.lucent.ra.nms.amf.LEAMRouter_R;
import com.lucent.ra.nms.amf.LEAsyncMessage;
import com.lucent.ra.nms.amf.LECCMap;
import com.lucent.ra.nms.amf.LEClientPerf;
import com.lucent.ra.nms.amf.LEClientRouter;
import com.lucent.ra.nms.util.LEAppSpecs;
import com.lucent.ra.nms.util.LEDebug;
import com.lucent.ra.nms.util.LEResourceID;
import com.lucent.ra.nms.util.LETQClient;
import com.lucent.ra.nms.util.LEThreadedQueue;
import com.lucent.ra.nms.util.LEVector;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Enumeration;
import java.util.Hashtable;

public class LEAMRouter_RI
extends UnicastRemoteObject
implements LEAMRouter_R,
LETQClient {
    public static final String ALL_IDS = "";
    static final String ADD_CLIENT = "add_client";
    static final String DEL_CLIENT = "del_client";
    static final String RM_CLIENT = "rm_client";
    static final int MAX_MESSAGES = 1000;
    static LEAMRouter_RI s_router = null;
    LEThreadedQueue m_queue;
    Hashtable m_clients = new Hashtable();
    Hashtable m_ids = new Hashtable();
    LEVector m_criticalTypes;
    LECCMap m_map;
    String m_ignoreId;

    public static LEAMRouter_RI Initialize(LEVector lEVector) {
        block2: {
            if (s_router != null) break block2;
            try {
                s_router = new LEAMRouter_RI(lEVector);
            }
            catch (RemoteException remoteException) {
                LEDebug.getLog().logln(20, remoteException);
            }
        }
        return s_router;
    }

    public static LEAMRouter_RI GetAMRouter() {
        return s_router;
    }

    public LEAMRouter_RI(LEVector lEVector) throws RemoteException {
        this.m_criticalTypes = lEVector;
        this.m_queue = new LEThreadedQueue(this);
    }

    public synchronized void addObserver(String string, LEAMManager_R lEAMManager_R) throws RemoteException {
        LEAppSpecs lEAppSpecs = lEAMManager_R.getAppSpecs();
        LEClientRouter lEClientRouter = (LEClientRouter)this.m_clients.get(lEAppSpecs.m_id);
        if (lEClientRouter == null) {
            lEClientRouter = new LEClientRouter(this, lEAMManager_R, lEAppSpecs);
            lEClientRouter.setCriticalMessageTypes(this.m_criticalTypes);
            this.m_clients.put(lEAppSpecs.m_id, lEClientRouter);
        }
        LEAsyncMessage lEAsyncMessage = new LEAsyncMessage(string, ADD_CLIENT, lEClientRouter);
        this.distribute(lEAsyncMessage);
    }

    public synchronized void removeObserver(String string, LEAMManager_R lEAMManager_R) throws RemoteException {
        String string2 = lEAMManager_R.getResourceID();
        LEClientRouter lEClientRouter = (LEClientRouter)this.m_clients.get(string2);
        if (lEClientRouter == null) {
            return;
        }
        LEAsyncMessage lEAsyncMessage = new LEAsyncMessage(string, DEL_CLIENT, lEClientRouter);
        this.distribute(lEAsyncMessage);
    }

    public void clientShutdown(LEClientRouter lEClientRouter) {
        LEAsyncMessage lEAsyncMessage = new LEAsyncMessage(null, RM_CLIENT, lEClientRouter);
        this.distribute(lEAsyncMessage);
    }

    public void distribute(String string, String string2, Object object) {
        if (this.m_queue.getQueueSize() >= 1000 && !this.m_criticalTypes.contains(string2)) {
            LEDebug.getLog().logln(10, "LEAMRouter_RI ignoring message of type " + string2 + " from " + string);
            return;
        }
        LEAsyncMessage lEAsyncMessage = new LEAsyncMessage(string, string2, object);
        this.distribute(lEAsyncMessage);
    }

    public void distribute(LEAsyncMessage lEAsyncMessage) {
        this.m_queue.add(lEAsyncMessage);
    }

    public void setIgnoreId(String string) {
        this.m_ignoreId = string;
    }

    public LECCMap getCCMap() {
        if (this.m_map == null) {
            this.m_map = this.buildCCMap();
        }
        return this.m_map;
    }

    public LEAppSpecs getSpecsFor(String string) {
        LEClientRouter lEClientRouter = (LEClientRouter)this.m_clients.get(string);
        if (lEClientRouter != null) {
            return lEClientRouter.getAppSpecs();
        }
        return null;
    }

    public LEClientPerf getPerformanceFor(String string) {
        LEClientRouter lEClientRouter = (LEClientRouter)this.m_clients.get(string);
        if (lEClientRouter != null) {
            return lEClientRouter.getPerformance();
        }
        return null;
    }

    public LEThreadedQueue getQueue() {
        return this.m_queue;
    }

    public void next(Object object) {
        try {
            LEAsyncMessage lEAsyncMessage = (LEAsyncMessage)object;
            String string = lEAsyncMessage.getType();
            if (string.equals(ADD_CLIENT)) {
                this.addClient(lEAsyncMessage.getID(), (LEClientRouter)lEAsyncMessage.getData());
                return;
            }
            if (string.equals(DEL_CLIENT)) {
                this.delClient(lEAsyncMessage.getID(), (LEClientRouter)lEAsyncMessage.getData());
                return;
            }
            if (string.equals(RM_CLIENT)) {
                this.rmClient((LEClientRouter)lEAsyncMessage.getData());
                return;
            }
            this.routeMessage(lEAsyncMessage);
            return;
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
            return;
        }
    }

    public boolean haveClientsFor(String string) {
        String string2;
        LEVector lEVector = (LEVector)this.m_ids.get(string);
        if (lEVector == null) {
            return false;
        }
        int n = lEVector.size();
        return n == 1 ? !(string2 = (String)lEVector.elementAt(0)).equals(this.m_ignoreId) : n > 1;
    }

    public LEVector haveClientsForIP(String string) {
        LEVector lEVector = null;
        Enumeration enumeration = this.m_ids.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (!string.equals(LEResourceID.ExtractHost(string2)) || !this.haveClientsFor(string2)) continue;
            if (lEVector == null) {
                lEVector = new LEVector();
            }
            lEVector.addElement(string2);
        }
        return lEVector;
    }

    public boolean verifyClientsFor(String string) {
        LEVector lEVector = (LEVector)this.m_ids.get(string);
        if (lEVector == null) {
            return false;
        }
        boolean bl = false;
        LEClientRouter lEClientRouter = null;
        int n = lEVector.size();
        int n2 = 0;
        while (n2 < n) {
            String string2 = (String)lEVector.elementAt(n2);
            if (!string2.equals(this.m_ignoreId) && (lEClientRouter = (LEClientRouter)this.m_clients.get(string2)) != null && lEClientRouter.ping()) {
                bl = true;
            }
            ++n2;
        }
        return bl;
    }

    LECCMap buildCCMap() {
        String string;
        int n;
        int n2;
        LEVector lEVector;
        LECCMap lECCMap = new LECCMap();
        Enumeration enumeration = this.m_ids.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (!string2.startsWith("pm://")) continue;
            lEVector = (LEVector)this.m_ids.get(string2);
            n2 = lEVector.size();
            n = 0;
            while (n < n2) {
                string = (String)lEVector.elementAt(n);
                if (this.m_ignoreId == null || !string.equals(this.m_ignoreId)) {
                    lECCMap.add(string2, string);
                }
                ++n;
            }
        }
        lEVector = (LEVector)this.m_ids.get(ALL_IDS);
        if (lEVector != null) {
            n2 = lEVector.size();
            n = 0;
            while (n < n2) {
                string = (String)lEVector.elementAt(n);
                if (this.m_ignoreId == null || !string.equals(this.m_ignoreId)) {
                    lECCMap.addToAll(string);
                }
                ++n;
            }
        }
        return lECCMap;
    }

    void rmClient(LEClientRouter lEClientRouter) {
        String string = lEClientRouter.getId();
        Enumeration enumeration = this.m_ids.elements();
        while (enumeration.hasMoreElements()) {
            LEVector lEVector = (LEVector)enumeration.nextElement();
            lEVector.removeElement(string);
        }
        this.m_clients.remove(string);
        this.m_map = null;
    }

    void addClient(String string, LEClientRouter lEClientRouter) {
        LEVector lEVector = (LEVector)this.m_ids.get(string);
        if (lEVector == null) {
            lEVector = new LEVector();
            this.m_ids.put(string, lEVector);
        }
        lEVector.addElementUnique(lEClientRouter.getId());
        this.m_map = null;
    }

    void delClient(String string, LEClientRouter lEClientRouter) {
        LEVector lEVector = (LEVector)this.m_ids.get(string);
        if (lEVector == null) {
            return;
        }
        lEVector.removeElement(lEClientRouter.getId());
        this.m_map = null;
    }

    void routeMessage(LEAsyncMessage lEAsyncMessage) {
        LEVector lEVector = (LEVector)this.m_ids.get(ALL_IDS);
        if (lEVector != null) {
            this.notify(lEVector, lEAsyncMessage);
        }
        if ((lEVector = (LEVector)this.m_ids.get(lEAsyncMessage.getID())) != null) {
            this.notify(lEVector, lEAsyncMessage);
        }
    }

    void notify(LEVector lEVector, LEAsyncMessage lEAsyncMessage) {
        int n = lEVector.size();
        int n2 = 0;
        while (n2 < n) {
            String string = (String)lEVector.elementAt(n2);
            LEClientRouter lEClientRouter = (LEClientRouter)this.m_clients.get(string);
            if (lEClientRouter != null) {
                lEClientRouter.process(lEAsyncMessage);
            }
            ++n2;
        }
    }
}

