/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.forms;

import com.lucent.ra.nms.forms.LEAddDialog;
import com.lucent.ra.nms.forms.LECmdErrorDialog;
import com.lucent.ra.nms.forms.LEFormLine;
import com.lucent.ra.nms.forms.LEFormLineFactory;
import com.lucent.ra.nms.forms.LENewEntry;
import com.lucent.ra.nms.forms.LETableForm;
import com.lucent.ra.nms.model.LEBGPPolicies;
import com.lucent.ra.nms.model.LEBGPPolicy;
import com.lucent.ra.nms.model.LEDataSpec;
import com.lucent.ra.nms.model.LEPortMaster;
import com.lucent.ra.nms.model.LETable;
import com.lucent.ra.nms.ui.LEErrorDialog;
import com.lucent.ra.nms.ui.LEFont;
import com.lucent.ra.nms.ui.LEUiUtils;
import com.lucent.ra.nms.util.LEAlphaNumericCompare;
import com.lucent.ra.nms.util.LEVector;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Label;
import java.awt.Panel;

public class LEBGPPoliciesForm
extends LETableForm {
    String m_name;

    public void setContext(String string, LEVector lEVector) {
        this.m_platform = string;
        this.m_context = lEVector;
        this.m_tags.addElement("entry");
        this.m_cols = this.m_tags.size();
        this.initialize(1, 2, this.m_cols);
        this.setSortable(0, true);
        this.setSortable(1, true);
        this.setSortable(2, true);
        this.setSortObject(1, new LEAlphaNumericCompare());
        Object[] objectArray = new String[this.m_cols + 2];
        objectArray[0] = "Device";
        objectArray[1] = "BGP Policy";
        objectArray[2] = "Rule Count";
        this.setTitles(0, objectArray);
    }

    void addEntry(String string, LETable lETable, String string2) {
        Object[] objectArray = new Object[this.m_cols + 2];
        objectArray[0] = string;
        objectArray[1] = string2;
        Object object = lETable.get(string2);
        if (object instanceof LEBGPPolicy) {
            LEBGPPolicy lEBGPPolicy = (LEBGPPolicy)object;
            objectArray[2] = Integer.toString(lEBGPPolicy.size());
        }
        this.addRow(objectArray);
    }

    boolean addNewEntry(LEDataSpec lEDataSpec, LEDataSpec lEDataSpec2) {
        Panel panel = new Panel();
        panel.setLayout(new BorderLayout());
        Label label = new Label("BGP Policy Name:");
        label.setFont(LEFont.getBoldFont());
        panel.add("West", label);
        Component component = LEFormLineFactory.BuildFormLine(null, null, null, lEDataSpec);
        panel.add("Center", component);
        LEAddDialog lEAddDialog = new LEAddDialog(LEUiUtils.GetBaseFrame(), "Add BGP Policy", panel);
        if (lEAddDialog.okay()) {
            this.m_name = ((LEFormLine)((Object)component)).getValue();
            if (this.m_name.length() > 0) {
                return true;
            }
            new LEErrorDialog(LEUiUtils.GetBaseFrame(), "A BGP policy name must be entered");
        }
        return false;
    }

    LENewEntry addNewEntryTo(LEPortMaster lEPortMaster) {
        LENewEntry lENewEntry = null;
        LEBGPPolicies lEBGPPolicies = (LEBGPPolicies)this.getTable(lEPortMaster);
        if (lEBGPPolicies.get(this.m_name) == null) {
            LEVector lEVector = lEBGPPolicies.add(this.m_name);
            if (lEVector != null) {
                new LECmdErrorDialog(LEUiUtils.GetBaseFrame(), lEPortMaster.getConnectionFacade(), lEVector);
            }
            this.addEntry(lEPortMaster.getDescription(), lEBGPPolicies, this.m_name);
            lENewEntry = new LENewEntry(lEPortMaster, lEBGPPolicies, this.m_name);
        } else {
            new LEErrorDialog(LEUiUtils.GetBaseFrame(), String.valueOf(lEPortMaster.getDescription()) + " already contains a bgp policy named " + this.m_name);
        }
        return lENewEntry;
    }

    void delete(LEPortMaster lEPortMaster, LETable lETable, String string) {
        if (!(lETable instanceof LEBGPPolicies)) {
            return;
        }
        LEBGPPolicies lEBGPPolicies = (LEBGPPolicies)lETable;
        LEVector lEVector = lEBGPPolicies.delete(string);
        if (lEVector != null) {
            new LECmdErrorDialog(LEUiUtils.GetBaseFrame(), lEPortMaster.getConnectionFacade(), lEVector);
        }
    }

    void pasteEntryTo(LEPortMaster lEPortMaster, Object object) {
        String string = this.getPasteKey(lEPortMaster, object);
        if (string == null) {
            return;
        }
        this.updateEntry(lEPortMaster.getDescription(), this.getTable(lEPortMaster), string);
    }

    String getPasteKey(LEPortMaster lEPortMaster, Object object) {
        String string;
        if (!(object instanceof LEBGPPolicy)) {
            return null;
        }
        LEBGPPolicy lEBGPPolicy = (LEBGPPolicy)object;
        LEBGPPolicies lEBGPPolicies = (LEBGPPolicies)this.getTable(lEPortMaster);
        if (lEBGPPolicies.get(string = lEBGPPolicy.getName()) != null) {
            new LEErrorDialog(LEUiUtils.GetBaseFrame(), String.valueOf(lEPortMaster.getDescription()) + " already contains a bgp policy named " + string);
            string = null;
        } else {
            LEVector lEVector = lEBGPPolicies.add(string);
            if (lEVector != null) {
                new LECmdErrorDialog(LEUiUtils.GetBaseFrame(), lEPortMaster.getConnectionFacade(), lEVector);
                string = null;
            }
        }
        return string;
    }
}

