/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.forms;

import com.lucent.ra.nms.forms.LEAddDialog;
import com.lucent.ra.nms.forms.LECmdErrorDialog;
import com.lucent.ra.nms.forms.LEForm;
import com.lucent.ra.nms.forms.LEFormLine;
import com.lucent.ra.nms.forms.LEFormLineFactory;
import com.lucent.ra.nms.forms.LENewEntry;
import com.lucent.ra.nms.model.LEDataSpec;
import com.lucent.ra.nms.model.LEHost;
import com.lucent.ra.nms.model.LEHosts;
import com.lucent.ra.nms.model.LEPortMaster;
import com.lucent.ra.nms.ui.LECompGrid;
import com.lucent.ra.nms.ui.LEErrorDialog;
import com.lucent.ra.nms.ui.LEFont;
import com.lucent.ra.nms.ui.LEMultiList;
import com.lucent.ra.nms.ui.LEUiUtils;
import com.lucent.ra.nms.util.LEVector;
import java.awt.BorderLayout;
import java.awt.Checkbox;
import java.awt.Component;
import java.awt.Label;
import java.awt.Panel;

public class LEHostsForm
extends LEMultiList
implements LEForm {
    static final String PORTMASTER = "Device";
    static final String ADDRESS = "Address";
    static final String HOSTNAME = "Hostname";
    static final String BLANK = "";
    LEPortMaster[] m_pms;
    LEVector m_context;
    String m_platform;
    String m_addAddress;
    String m_addHostname;

    public void setContext(String string, LEVector lEVector) {
        this.m_platform = string;
        this.initialize(1, 2, 1);
        this.setSortable(0, true);
        this.setSortable(1, true);
        this.setSortable(2, true);
        Object[] objectArray = new String[]{PORTMASTER, ADDRESS, HOSTNAME};
        this.setTitles(0, objectArray);
    }

    public void setPortMasters(LEPortMaster[] lEPortMasterArray) {
        int n;
        boolean bl;
        int n2;
        if (this.m_pms != null) {
            n2 = 0;
            while (n2 < this.m_pms.length) {
                bl = false;
                n = 0;
                while (!bl && n < lEPortMasterArray.length) {
                    if (this.m_pms[n2] == lEPortMasterArray[n]) {
                        bl = true;
                    }
                    ++n;
                }
                if (!bl) {
                    this.removePortMaster(this.m_pms[n2]);
                }
                ++n2;
            }
        }
        n2 = 0;
        while (n2 < lEPortMasterArray.length) {
            bl = false;
            if (this.m_pms != null) {
                n = 0;
                while (!bl && n < this.m_pms.length) {
                    if (lEPortMasterArray[n2] == this.m_pms[n]) {
                        bl = true;
                    }
                    ++n;
                }
            }
            if (!bl) {
                this.addPortMaster(lEPortMasterArray[n2]);
            }
            ++n2;
        }
        this.m_pms = lEPortMasterArray;
        this.repaint();
    }

    public void refresh() {
        this.deleteAllRows();
        int n = 0;
        while (n < this.m_pms.length) {
            LEHosts lEHosts = (LEHosts)this.m_pms[n].get("1245184");
            if (lEHosts != null) {
                lEHosts.refresh();
                this.addPortMaster(this.m_pms[n]);
            }
            ++n;
        }
    }

    public void gone() {
    }

    public void add() {
        int n = 0;
        LEDataSpec lEDataSpec = null;
        int n2 = 0;
        while (n2 < this.m_pms.length) {
            LEHosts lEHosts = (LEHosts)this.m_pms[n2].get("1245184");
            if (lEHosts != null) {
                ++n;
                if (lEDataSpec == null) {
                    lEDataSpec = lEHosts.getSpecFor("entry");
                }
            }
            ++n2;
        }
        if (n == 0) {
            return;
        }
        if (!this.addNewEntry(lEDataSpec)) {
            return;
        }
        LEVector lEVector = this.determinePMs("Add");
        if (lEVector != null) {
            int n3 = lEVector.size();
            int n4 = 0;
            while (n4 < n3) {
                this.addNewEntryTo((LEPortMaster)lEVector.elementAt(n4));
                ++n4;
            }
            this.layoutGrid();
        }
    }

    public void delete() {
        int[] nArray = this.getSelectedRows();
        int n = nArray.length - 1;
        while (n > -1) {
            LEPortMaster lEPortMaster = this.getPortMaster(nArray[n]);
            String string = (String)this.getCellItem(nArray[n], 1);
            this.delete(lEPortMaster, string);
            --n;
        }
        this.deleteAllRows();
        int n2 = 0;
        while (n2 < this.m_pms.length) {
            this.addPortMaster(this.m_pms[n2]);
            ++n2;
        }
    }

    public void paste(Object object) {
        LEVector lEVector = this.determinePMs("Paste");
        if (lEVector != null) {
            int n = lEVector.size();
            int n2 = 0;
            while (n2 < n) {
                this.pasteTo((LEPortMaster)lEVector.elementAt(n2), object);
                ++n2;
            }
            this.layoutGrid();
        }
    }

    public Object getEntry(int n) {
        LEHost lEHost = null;
        LEPortMaster lEPortMaster = this.getPortMaster(n);
        if (lEPortMaster != null) {
            LEHosts lEHosts = (LEHosts)lEPortMaster.get("1245184");
            String string = (String)this.getCellItem(n, 1);
            String string2 = (String)this.getCellItem(n, 2);
            if (lEHosts != null && string != null && string2 != null) {
                lEHost = this.findHost(lEHosts, string, string2);
            }
        }
        return lEHost;
    }

    LEPortMaster getPortMaster(int n) {
        LEPortMaster lEPortMaster = null;
        String string = (String)this.getCellItem(n, 0);
        int n2 = 0;
        while (lEPortMaster == null && n2 < this.m_pms.length) {
            if (string.equals(this.m_pms[n2].getDescription())) {
                lEPortMaster = this.m_pms[n2];
            }
            ++n2;
        }
        return lEPortMaster;
    }

    void addPortMaster(LEPortMaster lEPortMaster) {
        LEHosts lEHosts = (LEHosts)lEPortMaster.get("1245184");
        if (lEHosts != null) {
            String string = lEPortMaster.getDescription();
            int n = lEHosts.length();
            int n2 = 0;
            while (n2 < n) {
                LEHost lEHost = (LEHost)lEHosts.get(n2);
                if (lEHost != null) {
                    this.addEntry(string, lEHost);
                }
                ++n2;
            }
        }
    }

    void addEntry(String string, LEHost lEHost) {
        Object[] objectArray = new Object[]{string, (String)lEHost.get("address"), (String)lEHost.get("hostname")};
        this.addRow(objectArray);
    }

    synchronized void removePortMaster(LEPortMaster lEPortMaster) {
        LEHosts lEHosts = (LEHosts)lEPortMaster.get("1245184");
        if (lEHosts == null) {
            return;
        }
        String string = lEPortMaster.getDescription();
        int n = this.getNumRows();
        int n2 = n - 1;
        while (n2 > -1) {
            String string2 = (String)this.getCellItem(n2, 0);
            if (string2.equals(string)) {
                this.deleteRow(n2);
            }
            --n2;
        }
    }

    void delete(LEPortMaster lEPortMaster, String string) {
        LEHosts lEHosts = (LEHosts)lEPortMaster.get("1245184");
        if (lEHosts == null) {
            return;
        }
        LEVector lEVector = lEHosts.delete(string);
        if (lEVector != null) {
            new LECmdErrorDialog(LEUiUtils.GetBaseFrame(), lEPortMaster.getConnectionFacade(), lEVector);
        }
    }

    boolean addNewEntry(LEDataSpec lEDataSpec) {
        Panel panel = new Panel();
        panel.setLayout(new BorderLayout());
        LEDataSpec lEDataSpec2 = lEDataSpec.getSpecFor("address");
        Component[][] componentArray = new Component[2][2];
        componentArray[0][0] = new Label(String.valueOf(lEDataSpec2.getDescription()) + ":");
        componentArray[0][0].setFont(LEFont.getBoldFont());
        componentArray[0][1] = LEFormLineFactory.BuildFormLine(null, null, null, lEDataSpec2);
        lEDataSpec2 = lEDataSpec.getSpecFor("hostname");
        componentArray[1][0] = new Label(String.valueOf(lEDataSpec2.getDescription()) + ":");
        componentArray[1][0].setFont(LEFont.getBoldFont());
        componentArray[1][1] = LEFormLineFactory.BuildFormLine(null, null, null, lEDataSpec2);
        panel.add("Center", new LECompGrid(componentArray, 2, false));
        LEAddDialog lEAddDialog = new LEAddDialog(LEUiUtils.GetBaseFrame(), "Add Host", panel);
        if (lEAddDialog.okay()) {
            this.m_addAddress = ((LEFormLine)((Object)componentArray[0][1])).getValue();
            this.m_addHostname = ((LEFormLine)((Object)componentArray[1][1])).getValue();
            if (this.m_addHostname.length() > 0) {
                return true;
            }
            new LEErrorDialog(LEUiUtils.GetBaseFrame(), "A hostname must be specified");
        }
        return false;
    }

    LENewEntry addNewEntryTo(LEPortMaster lEPortMaster) {
        LEHosts lEHosts = (LEHosts)lEPortMaster.get("1245184");
        LEVector lEVector = lEHosts.add(this.m_addAddress, this.m_addHostname);
        if (lEVector != null) {
            new LECmdErrorDialog(LEUiUtils.GetBaseFrame(), lEPortMaster.getConnectionFacade(), lEVector);
            this.refresh();
        } else {
            LEHost lEHost = (LEHost)lEHosts.get(lEHosts.length() - 1);
            if (lEHost != null) {
                this.addEntry(lEPortMaster.getDescription(), lEHost);
            }
        }
        return null;
    }

    LEVector determinePMs(String string) {
        LEVector lEVector = new LEVector();
        String string2 = null;
        int n = 0;
        while (n < this.m_pms.length) {
            LEHosts lEHosts = (LEHosts)this.m_pms[n].get("1245184");
            if (lEHosts != null) {
                lEVector.addElement(this.m_pms[n]);
                if (string2 == null) {
                    LEDataSpec lEDataSpec = lEHosts.getSpecFor("entry");
                    string2 = lEDataSpec.getDescription();
                }
            }
            ++n;
        }
        int n2 = lEVector.size();
        if (n2 > 1) {
            Component[][] componentArray = new Component[n2][2];
            componentArray[0][0] = new Label(String.valueOf(string) + " " + string2 + " to:");
            componentArray[0][0].setFont(LEFont.getBoldFont());
            int n3 = 0;
            while (n3 < n2) {
                componentArray[n3][1] = new Checkbox(((LEPortMaster)lEVector.elementAt(n3)).getDescription(), true, null);
                ++n3;
            }
            LEAddDialog lEAddDialog = new LEAddDialog(LEUiUtils.GetBaseFrame(), String.valueOf(string) + " " + string2, new LECompGrid(componentArray, 2, false));
            if (lEAddDialog.okay()) {
                int n4 = n2 - 1;
                while (n4 > -1) {
                    if (!((Checkbox)componentArray[n4][1]).getState()) {
                        lEVector.removeElementAt(n4);
                    }
                    --n4;
                }
                if (lEVector.size() == 0) {
                    lEVector = null;
                }
            } else {
                lEVector = null;
            }
        } else if (n2 == 0) {
            lEVector = null;
        }
        return lEVector;
    }

    void pasteTo(LEPortMaster lEPortMaster, Object object) {
        if (object instanceof LEVector) {
            LEVector lEVector = (LEVector)object;
            int n = lEVector.size();
            int n2 = 0;
            while (n2 < n) {
                this.pasteEntryTo(lEPortMaster, lEVector.elementAt(n2));
                ++n2;
            }
            return;
        }
        this.pasteEntryTo(lEPortMaster, object);
    }

    void pasteEntryTo(LEPortMaster lEPortMaster, Object object) {
        LEHosts lEHosts = (LEHosts)lEPortMaster.get("1245184");
        if (lEHosts == null) {
            return;
        }
        if (!(object instanceof LEHost)) {
            return;
        }
        LEHost lEHost = (LEHost)object;
        String string = (String)lEHost.get("address");
        String string2 = (String)lEHost.get("hostname");
        if (string == null || string2 == null) {
            return;
        }
        LEHost lEHost2 = this.findHost(lEHosts, string, string2);
        if (lEHost2 != null) {
            new LEErrorDialog(LEUiUtils.GetBaseFrame(), String.valueOf(lEPortMaster.getDescription()) + " already contains an entry that matches " + string + ", " + string2);
            return;
        }
        LEVector lEVector = lEHosts.add(string, string2);
        if (lEVector != null) {
            new LECmdErrorDialog(LEUiUtils.GetBaseFrame(), lEPortMaster.getConnectionFacade(), lEVector);
            return;
        }
        lEHost = (LEHost)lEHosts.get(lEHosts.length() - 1);
        if (lEHost != null) {
            this.addEntry(lEPortMaster.getDescription(), lEHost);
        }
    }

    LEHost findHost(LEHosts lEHosts, String string, String string2) {
        LEHost lEHost = null;
        int n = lEHosts.length();
        int n2 = 0;
        while (lEHost == null && n2 < n) {
            LEHost lEHost2 = (LEHost)lEHosts.get(n2);
            String string3 = (String)lEHost2.get("address");
            String string4 = (String)lEHost2.get("hostname");
            if (string.equals(string3) && string2.equals(string4)) {
                lEHost = lEHost2;
            }
            ++n2;
        }
        return lEHost;
    }
}

