/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.forms;

import com.lucent.ra.nms.forms.LEAddDialog;
import com.lucent.ra.nms.forms.LECmdErrorDialog;
import com.lucent.ra.nms.forms.LEFormLine;
import com.lucent.ra.nms.forms.LEFormLineFactory;
import com.lucent.ra.nms.forms.LENewEntry;
import com.lucent.ra.nms.forms.LETableForm;
import com.lucent.ra.nms.model.LEDataSpec;
import com.lucent.ra.nms.model.LEIPPool;
import com.lucent.ra.nms.model.LEIPPools;
import com.lucent.ra.nms.model.LEIPRanges;
import com.lucent.ra.nms.model.LEPortMaster;
import com.lucent.ra.nms.model.LETable;
import com.lucent.ra.nms.ui.LEErrorDialog;
import com.lucent.ra.nms.ui.LEFont;
import com.lucent.ra.nms.ui.LEUiUtils;
import com.lucent.ra.nms.util.LEAlphaNumericCompare;
import com.lucent.ra.nms.util.LEVector;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Label;
import java.awt.Panel;

public class LEIPPoolsForm
extends LETableForm {
    static final String PORTMASTER = "Device";
    static final String BLANK = "";
    String m_addName;

    public LEIPPoolsForm() {
        this.m_keyReadonly = false;
    }

    public void setContext(String string, LEVector lEVector) {
        this.m_platform = string;
        this.m_context = lEVector;
        this.m_cols = 2;
        this.initialize(1, 2, this.m_cols);
        this.setSortable(0, true);
        this.setSortable(1, true);
        this.setSortable(2, true);
        this.setSortObject(1, new LEAlphaNumericCompare());
        Object[] objectArray = new String[this.m_cols + 2];
        objectArray[0] = PORTMASTER;
        objectArray[1] = "IP Pool";
        objectArray[2] = "Range Count";
        objectArray[3] = "Default Gateway";
        this.setTitles(0, objectArray);
    }

    void addEntry(String string, LETable lETable, String string2) {
        Object[] objectArray = new Object[this.m_cols + 2];
        objectArray[0] = string;
        objectArray[1] = string2;
        Object object = lETable.get(string2);
        if (object instanceof LEIPPool) {
            LEIPPool lEIPPool = (LEIPPool)object;
            LEIPRanges lEIPRanges = (LEIPRanges)lEIPPool.get("ranges");
            objectArray[2] = lEIPRanges != null ? Integer.toString(lEIPRanges.size()) : BLANK;
            objectArray[3] = lEIPPool.get("75");
        }
        this.addRow(objectArray);
    }

    boolean addNewEntry(LEDataSpec lEDataSpec, LEDataSpec lEDataSpec2) {
        Panel panel = new Panel();
        panel.setLayout(new BorderLayout());
        Label label = new Label("IP Pool Name:");
        label.setFont(LEFont.getBoldFont());
        panel.add("West", label);
        Component component = LEFormLineFactory.BuildFormLine(null, null, null, lEDataSpec);
        panel.add("Center", component);
        LEAddDialog lEAddDialog = new LEAddDialog(LEUiUtils.GetBaseFrame(), "Add IP pool", panel);
        if (lEAddDialog.okay()) {
            this.m_addName = ((LEFormLine)((Object)component)).getValue();
            if (this.m_addName.length() > 0) {
                return true;
            }
            new LEErrorDialog(LEUiUtils.GetBaseFrame(), "An IP pool name must be entered");
        }
        return false;
    }

    LENewEntry addNewEntryTo(LEPortMaster lEPortMaster) {
        LENewEntry lENewEntry = null;
        LETable lETable = this.getTable(lEPortMaster);
        if (lETable.get(this.m_addName) == null) {
            LEVector lEVector = ((LEIPPools)lETable).add(this.m_addName);
            if (lEVector != null) {
                new LECmdErrorDialog(LEUiUtils.GetBaseFrame(), lEPortMaster.getConnectionFacade(), lEVector);
            } else {
                this.addEntry(lEPortMaster.getDescription(), lETable, this.m_addName);
                lENewEntry = new LENewEntry(lEPortMaster, lETable, this.m_addName);
            }
        } else {
            new LEErrorDialog(LEUiUtils.GetBaseFrame(), String.valueOf(lEPortMaster.getDescription()) + " already contains a IP pool named " + this.m_addName);
        }
        return lENewEntry;
    }

    void delete(LEPortMaster lEPortMaster, LETable lETable, String string) {
        if (!(lETable instanceof LEIPPools)) {
            return;
        }
        LEIPPools lEIPPools = (LEIPPools)lETable;
        LEVector lEVector = lEIPPools.delete(string);
        if (lEVector != null) {
            new LECmdErrorDialog(LEUiUtils.GetBaseFrame(), lEPortMaster.getConnectionFacade(), lEVector);
        }
    }

    String getPasteKey(LEPortMaster lEPortMaster, Object object) {
        LEVector lEVector;
        String string;
        if (!(object instanceof LEIPPool)) {
            return null;
        }
        LEIPPool lEIPPool = (LEIPPool)object;
        LEIPPools lEIPPools = (LEIPPools)this.getTable(lEPortMaster);
        if (lEIPPools.get(string = lEIPPool.getName()) != null) {
            string = LETableForm.GetUniqueKey(lEIPPools, string, 16);
        }
        if ((lEVector = lEIPPools.add(string)) != null) {
            new LECmdErrorDialog(LEUiUtils.GetBaseFrame(), lEPortMaster.getConnectionFacade(), lEVector);
            string = null;
        }
        return string;
    }
}

