/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.forms;

import com.lucent.ra.nms.forms.LEFormLine;
import com.lucent.ra.nms.forms.LEFormLineEvent;
import com.lucent.ra.nms.forms.LEFormLineListener;
import com.lucent.ra.nms.model.LEAttributes;
import com.lucent.ra.nms.model.LEDataSpec;
import com.lucent.ra.nms.model.LEPortMaster;
import com.lucent.ra.nms.ui.LEVPNKeyField;
import com.lucent.ra.nms.util.LEHelpManager;
import java.awt.Button;
import java.awt.FlowLayout;
import java.awt.Panel;
import java.awt.TextComponent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Random;

public class LEVPNKeyFormLine
extends Panel
implements LEFormLine,
MouseListener,
ActionListener {
    LEFormLineListener m_listener;
    String m_valid;
    LEVPNKeyField m_key;
    Button m_random;
    int m_min;
    int m_max;
    boolean m_hex;

    public LEVPNKeyFormLine() {
        this.setLayout(new FlowLayout(0, 0, 0));
        this.m_key = new LEVPNKeyField(48);
        this.add(this.m_key);
        this.m_random = new Button("Random");
        this.add(this.m_random);
        this.addMouseListener(this);
        this.m_key.addMouseListener(this);
        this.m_random.addMouseListener(this);
        this.m_random.addActionListener(this);
        this.m_min = 8;
        this.m_max = 64;
        this.m_hex = false;
    }

    public void initFormLine(LEPortMaster lEPortMaster, LEDataSpec lEDataSpec) {
        String string = (String)lEDataSpec.getAttribute(LEAttributes.MINIMUM);
        if (string != null) {
            this.m_min = Integer.parseInt(string);
        }
        if ((string = (String)lEDataSpec.getAttribute(LEAttributes.MAXIMUM)) != null) {
            this.m_max = Integer.parseInt(string);
            this.m_key.setColumns(this.m_max / 4);
        }
    }

    public void setListener(LEFormLineListener lEFormLineListener) {
        this.m_listener = lEFormLineListener;
    }

    public void setValue(Object object) {
        String string = object.toString();
        if (string.startsWith("0x") || string.startsWith("0X")) {
            this.m_key.setHex(true);
        } else {
            this.m_key.setNumeric(true);
        }
        ((TextComponent)this.m_key).setText(string);
    }

    public String getValue() {
        return this.m_key.getText();
    }

    public String getValidValues() {
        if (this.m_valid == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Decimal or Hexadecimal number ");
            if (this.m_min != this.m_max) {
                stringBuffer.append(this.m_min);
                stringBuffer.append(" to ");
            }
            stringBuffer.append(this.m_max);
            stringBuffer.append(" bits long");
            this.m_valid = stringBuffer.toString();
        }
        return this.m_valid;
    }

    public boolean equalsField(Object object) {
        if (object != null) {
            String string = object.toString();
            String string2 = this.getValue();
            return string2.equals(string);
        }
        return false;
    }

    public boolean isValueValid() {
        return true;
    }

    void notifyListener() {
        if (this.m_listener != null) {
            LEFormLineEvent lEFormLineEvent = new LEFormLineEvent(this, this.getValue());
            this.m_listener.formLineValueChanged(lEFormLineEvent);
        }
    }

    public void setEnabled(boolean bl) {
        this.m_key.setEnabled(bl);
        this.m_random.setEnabled(bl);
        super.setEnabled(bl);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        LEHelpManager.SetHelp(this.getValidValues());
    }

    public void mouseExited(MouseEvent mouseEvent) {
        LEHelpManager.SetHelp("");
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("0x");
        String string = this.generateRandomHexValue(this.m_max / 32);
        stringBuffer.append(string);
        stringBuffer.append("/");
        stringBuffer.append(this.m_max);
        ((TextComponent)this.m_key).setText(stringBuffer.toString());
        this.m_key.setHex(true);
    }

    protected String generateRandomHexValue(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        Random random = new Random();
        int n2 = 0;
        while (n2 < n) {
            int n3 = random.nextInt();
            String string = Integer.toHexString(n3);
            while (string.length() < 8) {
                string = String.valueOf(string) + "3";
            }
            stringBuffer.append(string);
            ++n2;
        }
        return stringBuffer.toString();
    }
}

