/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.ui;

import com.lucent.ra.nms.util.LEDebug;
import com.lucent.ra.nms.util.LEObservable;
import java.awt.Component;
import java.awt.Container;
import java.awt.MenuItem;
import java.awt.TextComponent;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;

public class LEClipboard
extends LEObservable
implements ActionListener,
FocusListener,
ContainerListener {
    public static final Integer CUT = new Integer(1);
    public static final Integer COPY = new Integer(2);
    public static final Integer PASTE = new Integer(3);
    public static final Integer DELETE = new Integer(4);
    public static final Integer CONTENT = new Integer(5);
    public static final String ACTION_CUT = new String("cut");
    public static final String ACTION_COPY = new String("copy");
    public static final String ACTION_PASTE = new String("paste");
    public static final String ACTION_DELETE = new String("delete");
    static LEClipboard s_clipboard = null;
    MenuItem m_cut;
    MenuItem m_copy;
    MenuItem m_paste;
    MenuItem m_delete;
    boolean m_cutable;
    boolean m_copyable;
    boolean m_pasteable;
    boolean m_deleteable;
    TextComponent m_text;
    Object m_contents;

    public static LEClipboard GetClipboard() {
        if (s_clipboard == null) {
            s_clipboard = new LEClipboard();
        }
        return s_clipboard;
    }

    public Object getContents() {
        return this.m_contents;
    }

    public void watchContainer(Container container) {
        container.addContainerListener(this);
    }

    public void setMenuItems(MenuItem menuItem, MenuItem menuItem2, MenuItem menuItem3, MenuItem menuItem4) {
        this.m_cut = menuItem;
        this.m_copy = menuItem2;
        this.m_paste = menuItem3;
        this.m_delete = menuItem4;
        this.m_cut.setActionCommand(ACTION_CUT);
        this.m_copy.setActionCommand(ACTION_COPY);
        this.m_paste.setActionCommand(ACTION_PASTE);
        this.m_delete.setActionCommand(ACTION_DELETE);
        this.m_cut.addActionListener(this);
        this.m_copy.addActionListener(this);
        this.m_paste.addActionListener(this);
        this.m_delete.addActionListener(this);
    }

    public void setState(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.setCut(bl);
        this.setCopy(bl2);
        this.setPaste(bl3);
        this.setDelete(bl4);
    }

    public void setCut(boolean bl) {
        this.m_cutable = bl;
        if (this.m_cut != null) {
            this.m_cut.setEnabled(this.m_cutable);
        }
    }

    public void setCopy(boolean bl) {
        this.m_copyable = bl;
        if (this.m_copy != null) {
            this.m_copy.setEnabled(this.m_copyable);
        }
    }

    public void setPaste(boolean bl) {
        this.m_pasteable = bl;
        if (this.m_paste != null) {
            this.m_paste.setEnabled(this.m_pasteable);
        }
    }

    public void setDelete(boolean bl) {
        this.m_deleteable = bl;
        if (this.m_delete != null) {
            this.m_delete.setEnabled(this.m_deleteable);
        }
    }

    public void reset() {
        if (this.m_cut != null) {
            this.m_cut.setEnabled(false);
        }
        if (this.m_copy != null) {
            this.m_copy.setEnabled(false);
        }
        if (this.m_paste != null) {
            this.m_paste.setEnabled(false);
        }
        if (this.m_delete != null) {
            this.m_delete.setEnabled(false);
        }
    }

    public void setContents(Object object) {
        this.m_contents = object;
        this.notifyObservers(CONTENT);
    }

    public void watch(Component component) {
        if (component instanceof Container) {
            Container container = (Container)component;
            int n = container.getComponentCount();
            int n2 = 0;
            while (n2 < n) {
                this.watch(container.getComponent(n2));
                ++n2;
            }
            return;
        }
        if (component instanceof TextComponent) {
            component.addFocusListener(this);
        }
    }

    public void forget(Component component) {
        if (component instanceof Container) {
            Container container = (Container)component;
            int n = container.getComponentCount();
            int n2 = 0;
            while (n2 < n) {
                this.forget(container.getComponent(n2));
                ++n2;
            }
            return;
        }
        if (component instanceof TextComponent) {
            component.removeFocusListener(this);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(ACTION_CUT)) {
            if (this.m_text != null) {
                this.cutText();
                return;
            }
            this.notifyObservers(CUT);
            return;
        }
        if (string.equals(ACTION_COPY)) {
            if (this.m_text != null) {
                this.copyText();
                return;
            }
            this.notifyObservers(COPY);
            return;
        }
        if (string.equals(ACTION_PASTE)) {
            if (this.m_text != null) {
                this.pasteText();
                return;
            }
            this.notifyObservers(PASTE);
            return;
        }
        if (string.equals(ACTION_DELETE)) {
            if (this.m_text != null) {
                this.deleteText();
                return;
            }
            this.notifyObservers(DELETE);
        }
    }

    public void componentAdded(ContainerEvent containerEvent) {
        this.m_text = null;
        this.watch(containerEvent.getChild());
    }

    public void componentRemoved(ContainerEvent containerEvent) {
        this.forget(containerEvent.getChild());
        this.m_text = null;
    }

    public void focusGained(FocusEvent focusEvent) {
        this.m_text = (TextComponent)focusEvent.getSource();
        this.setState(true, true, true, true);
    }

    public void focusLost(FocusEvent focusEvent) {
        this.reset();
        this.m_text = null;
    }

    void cutText() {
        String string = this.m_text.getSelectedText();
        StringSelection stringSelection = new StringSelection(string);
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(stringSelection, stringSelection);
        this.deleteSelection(this.m_text);
    }

    void copyText() {
        String string = this.m_text.getSelectedText();
        StringSelection stringSelection = new StringSelection(string);
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(stringSelection, stringSelection);
    }

    void deleteText() {
        this.deleteSelection(this.m_text);
    }

    void pasteText() {
        Transferable transferable = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(this);
        try {
            String string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
            this.pasteSelection(this.m_text, string);
            return;
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
            return;
        }
    }

    void deleteSelection(TextComponent textComponent) {
        int n = textComponent.getSelectionStart();
        int n2 = textComponent.getSelectionEnd();
        if (n2 > n) {
            String string = textComponent.getText();
            String string2 = String.valueOf(string.substring(0, n)) + string.substring(n2);
            textComponent.setText(string2);
        }
    }

    void pasteSelection(TextComponent textComponent, String string) {
        int n = textComponent.getSelectionStart();
        int n2 = textComponent.getSelectionEnd();
        String string2 = textComponent.getText();
        String string3 = String.valueOf(string2.substring(0, n)) + string + string2.substring(n2);
        textComponent.setText(string3);
    }
}

