/*
 * Decompiled with CFR 0.152.
 */
package oracle.help.util;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.net.MalformedURLException;
import java.net.URL;
import oracle.help.util.TreeNode;
import oracle.help.util.TreeRoot;

public class SitemapParser {
    private static final String HHC_TOKEN_START = "<";
    private static final String HHC_TOKEN_END = ">";
    private static final String HHC_TOKEN_OBJECT = "object";
    private static final String HHC_TOKEN_ENDOBJECT = "/object";
    private static final String HHC_TOKEN_SUBTREE = "ul";
    private static final String HHC_TOKEN_ENDSUBTREE = "/ul";
    private static final String HHC_TOKEN_SITEMAP = "text/sitemap";
    private static final String HHC_TOKEN_PARAM = "param";
    private static final String HHC_TOKEN_PARAMNAME = "name=";
    private static final String HHC_TOKEN_PARAMVALUE = "value=";
    private static final String HHC_TOKEN_OBJTYPE = "type=";
    private static final String HHC_PARAM_NAME = "name";
    private static final String HHC_PARAM_LOCAL = "local";
    private static final String HHC_PARAM_KEYWORD = "keyword";
    private static final String HHC_PARAM_SECTION = "section title";
    private StreamTokenizer _st;
    private boolean _isHhk = false;
    private String _indent;

    public TreeRoot parseHhc(String string, boolean bl) throws FileNotFoundException, IOException {
        FileReader fileReader = new FileReader(string);
        return this.parseHhc(new BufferedReader(fileReader), bl);
    }

    public TreeRoot parseHhk(String string) throws FileNotFoundException, IOException {
        FileReader fileReader = new FileReader(string);
        return this.parseHhk(new BufferedReader(fileReader));
    }

    public TreeRoot parseHhc(URL uRL, boolean bl) throws IOException {
        return this.parseHhc(uRL.openStream(), bl);
    }

    public TreeRoot parseHhk(URL uRL) throws IOException {
        return this.parseHhk(uRL.openStream());
    }

    public TreeRoot parseHhc(URL uRL, String string, boolean bl) throws IOException, MalformedURLException {
        return this.parseHhc(uRL.toString(), string, bl);
    }

    public TreeRoot parseHhc(String string, String string2, boolean bl) throws IOException, MalformedURLException {
        URL uRL = new URL(String.valueOf(string) + string2);
        TreeRoot treeRoot = this.parseHhc(uRL.openStream(), bl);
        treeRoot.setBaseURL(string);
        return treeRoot;
    }

    public TreeRoot parseHhk(URL uRL, String string) throws IOException, MalformedURLException {
        return this.parseHhk(uRL.toString(), string);
    }

    public TreeRoot parseHhk(String string, String string2) throws IOException, MalformedURLException {
        URL uRL = new URL(String.valueOf(string) + string2);
        TreeRoot treeRoot = this.parseHhk(uRL.openStream());
        treeRoot.setBaseURL(string);
        return treeRoot;
    }

    public TreeRoot parseHhc(InputStream inputStream, boolean bl) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        return this.parseHhc(bufferedReader, bl);
    }

    public TreeRoot parseHhk(InputStream inputStream) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        return this.parseHhk(bufferedReader);
    }

    public TreeRoot parseHhk(Reader reader) throws IOException {
        this._isHhk = true;
        return this.parseHhc(reader, false);
    }

    public TreeRoot parseHhc(Reader reader, boolean bl) throws IOException {
        String string;
        TreeRoot treeRoot;
        this._st = new StreamTokenizer(reader);
        this._st.wordChars(47, 47);
        this._st.wordChars(61, 61);
        this._st.wordChars(48, 57);
        this._st.quoteChar(34);
        this._st.ordinaryChar(39);
        TreeNode treeNode = treeRoot = new TreeRoot(bl);
        if (!this._isHhk) {
            this._indent = "";
        }
        while ((string = this._readToken()) != null) {
            if (!string.equals(HHC_TOKEN_START)) continue;
            string = this._readToken();
            if (string.equalsIgnoreCase(HHC_TOKEN_OBJECT)) {
                this._readObject(treeNode);
                continue;
            }
            if (string.equalsIgnoreCase(HHC_TOKEN_SUBTREE)) {
                if (!this._isHhk) {
                    if (treeNode.numChildren() <= 0) continue;
                    treeNode = treeNode.getChild(treeNode.numChildren() - 1);
                    continue;
                }
                if (this._indent == null) {
                    this._indent = "";
                    continue;
                }
                this._indent = " ";
                continue;
            }
            if (!string.equalsIgnoreCase(HHC_TOKEN_ENDSUBTREE)) continue;
            if (!this._isHhk) {
                if (treeNode.getParent() == null) continue;
                treeNode = treeNode.getParent();
                continue;
            }
            this._indent = "";
        }
        return treeRoot;
    }

    private void _readObject(TreeNode treeNode) throws IOException {
        TreeNode treeNode2;
        String string;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        boolean bl = false;
        boolean bl2 = false;
        while (!(string = this._readToken()).equals(HHC_TOKEN_END)) {
            if (!string.equals(HHC_TOKEN_OBJTYPE) || (string = this._readToken()).equalsIgnoreCase(HHC_TOKEN_SITEMAP)) continue;
            return;
        }
        while (true) {
            if (!(string = this._readToken()).equals(HHC_TOKEN_START)) {
                continue;
            }
            string = this._readToken();
            if (string.equalsIgnoreCase(HHC_TOKEN_ENDOBJECT)) break;
            if (!string.equalsIgnoreCase(HHC_TOKEN_PARAM)) continue;
            string5 = null;
            string6 = null;
            string = this._readToken();
            while (!string.equals(HHC_TOKEN_END)) {
                if (string.equalsIgnoreCase(HHC_TOKEN_PARAMNAME)) {
                    string5 = this._readToken();
                } else if (string.equalsIgnoreCase(HHC_TOKEN_PARAMVALUE)) {
                    string6 = this._readToken();
                }
                string = this._readToken();
            }
            if (string5 == null || string6 == null) continue;
            if (string5.equalsIgnoreCase(HHC_PARAM_NAME)) {
                if (string2 != null) {
                    bl = true;
                    string4 = string2;
                }
                if (bl && string4 != null) {
                    treeNode2 = new TreeNode(String.valueOf(this._indent) + string4);
                    treeNode.addChild(treeNode2);
                    string4 = null;
                    treeNode = treeNode2;
                }
                string2 = string6;
                continue;
            }
            if (string5.equalsIgnoreCase(HHC_PARAM_LOCAL)) {
                string3 = string6;
                if (bl) {
                    if (string4 != null) {
                        treeNode2 = new TreeNode(String.valueOf(this._indent) + string4, string3);
                        treeNode.addChild(treeNode2);
                        string4 = null;
                        string3 = null;
                        continue;
                    }
                    if (string2 == null) continue;
                    treeNode2 = new TreeNode(String.valueOf(this._indent) + string2, string3);
                    treeNode.addChild(treeNode2);
                    string2 = null;
                    string3 = null;
                    continue;
                }
                if (!bl2 || string2 == null) continue;
                treeNode2 = new TreeNode(String.valueOf(this._indent) + string2, string3);
                treeNode.addChild(treeNode2);
                string2 = null;
                string3 = null;
                continue;
            }
            if (string5.equalsIgnoreCase(HHC_PARAM_KEYWORD)) {
                string4 = string6;
                bl = true;
                continue;
            }
            if (!string5.equalsIgnoreCase(HHC_PARAM_SECTION)) continue;
            if (!bl2) {
                treeNode2 = new TreeNode(String.valueOf(this._indent) + string2);
                treeNode.addChild(treeNode2);
                string2 = string6;
                treeNode = treeNode2;
                bl2 = true;
                continue;
            }
            string2 = string6;
        }
        if (string2 == null || bl || bl2) {
            return;
        }
        treeNode2 = string3 == null ? new TreeNode(String.valueOf(this._indent) + string2) : new TreeNode(String.valueOf(this._indent) + string2, string3);
        treeNode.addChild(treeNode2);
    }

    private String _readToken() throws IOException {
        int n = this._st.nextToken();
        switch (n) {
            case -3: 
            case 34: {
                return this._st.sval;
            }
            case -1: {
                return null;
            }
        }
        return "" + (char)n;
    }

    public static void main(String[] stringArray) {
        SitemapParser sitemapParser = new SitemapParser();
        try {
            TreeRoot treeRoot = sitemapParser.parseHhk(stringArray[0]);
            treeRoot.printTree();
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }
}

