/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.forms;

import com.lucent.ra.nms.forms.LEAddDialog;
import com.lucent.ra.nms.forms.LECmdErrorDialog;
import com.lucent.ra.nms.forms.LEFormLine;
import com.lucent.ra.nms.forms.LEFormLineFactory;
import com.lucent.ra.nms.forms.LENewEntry;
import com.lucent.ra.nms.forms.LETableForm;
import com.lucent.ra.nms.model.LEBGPPeer;
import com.lucent.ra.nms.model.LEBGPPeers;
import com.lucent.ra.nms.model.LEDataSpec;
import com.lucent.ra.nms.model.LEPortMaster;
import com.lucent.ra.nms.model.LETable;
import com.lucent.ra.nms.ui.LECompGrid;
import com.lucent.ra.nms.ui.LEErrorDialog;
import com.lucent.ra.nms.ui.LEFont;
import com.lucent.ra.nms.ui.LEUiUtils;
import com.lucent.ra.nms.util.LEVector;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Label;
import java.awt.Panel;

public class LEBGPPeersForm
extends LETableForm {
    static final String PORTMASTER = "Device";
    static final String BLANK = "";
    String m_peer;
    String m_local;
    String m_asn;

    public LEBGPPeersForm() {
        this.m_keyReadonly = false;
    }

    public void setContext(String platform, LEVector context) {
        this.m_platform = platform;
        this.m_context = context;
        this.m_cols = 12;
        this.initialize(1, 2, this.m_cols);
        String[] titles = new String[this.m_cols + 2];
        titles[0] = PORTMASTER;
        titles[1] = "Destination Address";
        titles[2] = "Source Address";
        titles[3] = "ASN";
        titles[4] = "Easy Multihome";
        titles[5] = "Assume Default";
        titles[6] = "Hop Count";
        titles[7] = "State";
        titles[8] = "Confederation Member";
        titles[9] = "Route Reflector Client";
        titles[10] = "Always Next Hop";
        titles[11] = "Accept Policy";
        titles[12] = "Inject Policy";
        titles[13] = "Advertise Policy";
        this.setTitles(0, titles);
    }

    void addEntry(String host, LETable table, String key) {
        String[] data = new String[this.m_cols + 2];
        data[0] = host;
        data[1] = key;
        Object obj = table.get(key);
        if (obj instanceof LEBGPPeer) {
            LEBGPPeer peer = (LEBGPPeer)obj;
            data[2] = (String)peer.get("177");
            data[3] = (String)peer.get("106");
            data[4] = (String)peer.get("118");
            data[5] = (String)peer.get("119");
            data[6] = (String)peer.get("113");
            data[7] = (String)peer.get("96");
            data[8] = (String)peer.get("114");
            data[9] = (String)peer.get("115");
            data[10] = (String)peer.get("116");
            data[11] = (String)peer.get("121");
            data[12] = (String)peer.get("122");
            data[13] = (String)peer.get("123");
        }
        this.addRow(data);
    }

    boolean addNewEntry(LEDataSpec keySpec, LEDataSpec entrySpec) {
        Panel panel = new Panel();
        panel.setLayout(new BorderLayout());
        Component[][] comps = new Component[3][2];
        comps[0][0] = new Label("Peer Address:");
        comps[0][0].setFont(LEFont.getBoldFont());
        comps[0][1] = LEFormLineFactory.BuildFormLine(null, null, null, keySpec);
        LEDataSpec spec = entrySpec.getSpecFor("177");
        comps[1][0] = new Label(String.valueOf(spec.getDescription()) + ":");
        comps[1][0].setFont(LEFont.getBoldFont());
        comps[1][1] = LEFormLineFactory.BuildFormLine(null, null, null, spec);
        spec = entrySpec.getSpecFor("106");
        comps[2][0] = new Label(String.valueOf(spec.getDescription()) + ":");
        comps[2][0].setFont(LEFont.getBoldFont());
        comps[2][1] = LEFormLineFactory.BuildFormLine(null, null, null, spec);
        panel.add("Center", new LECompGrid(comps, 2, false));
        LEAddDialog dlg = new LEAddDialog(LEUiUtils.GetBaseFrame(), "Add BGP Peer", panel);
        if (dlg.okay()) {
            this.m_peer = ((LEFormLine)((Object)comps[0][1])).getValue();
            this.m_local = ((LEFormLine)((Object)comps[1][1])).getValue();
            this.m_asn = ((LEFormLine)((Object)comps[2][1])).getValue();
            if (this.m_peer.length() == 0) {
                new LEErrorDialog(LEUiUtils.GetBaseFrame(), "A peer address must be entered");
                return false;
            }
            if (this.m_local.length() == 0) {
                new LEErrorDialog(LEUiUtils.GetBaseFrame(), "A local address must be entered");
                return false;
            }
            if (this.m_asn.length() == 0) {
                new LEErrorDialog(LEUiUtils.GetBaseFrame(), "An asn id must be entered");
                return false;
            }
            return true;
        }
        return false;
    }

    LENewEntry addNewEntryTo(LEPortMaster pm) {
        LENewEntry entry = null;
        LETable table = this.getTable(pm);
        if (table.get(this.m_peer) == null) {
            LEVector errors = ((LEBGPPeers)table).add(this.m_peer, this.m_local, this.m_asn);
            if (errors != null) {
                new LECmdErrorDialog(LEUiUtils.GetBaseFrame(), pm.getConnectionFacade(), errors);
            } else {
                this.addEntry(pm.getDescription(), table, this.m_peer);
                entry = new LENewEntry(pm, table, this.m_peer);
            }
        } else {
            new LEErrorDialog(LEUiUtils.GetBaseFrame(), String.valueOf(pm.getDescription()) + " already contains the BGP peer with address " + this.m_peer);
        }
        return entry;
    }

    void delete(LEPortMaster pm, LETable table, String key) {
        if (!(table instanceof LEBGPPeers)) {
            return;
        }
        LEBGPPeers peers = (LEBGPPeers)table;
        LEVector errors = peers.delete(key);
        if (errors != null) {
            new LECmdErrorDialog(LEUiUtils.GetBaseFrame(), pm.getConnectionFacade(), errors);
        }
    }

    String getPasteKey(LEPortMaster pm, Object obj) {
        String asn;
        String local_addr;
        LEVector errors;
        String dest_addr;
        if (!(obj instanceof LEBGPPeer)) {
            return null;
        }
        LEBGPPeer peer = (LEBGPPeer)obj;
        LEBGPPeers peers = (LEBGPPeers)this.getTable(pm);
        if (peers.get(dest_addr = peer.getName()) != null) {
            dest_addr = LETableForm.GetUniqueKey(peers, dest_addr, 16);
        }
        if ((errors = peers.add(dest_addr, local_addr = (String)peer.get("177"), asn = (String)peer.get("106"))) != null) {
            new LECmdErrorDialog(LEUiUtils.GetBaseFrame(), pm.getConnectionFacade(), errors);
            dest_addr = null;
        }
        return dest_addr;
    }
}

