/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.forms;

import com.lucent.ra.nms.forms.LEFormLine;
import com.lucent.ra.nms.forms.LEFormLineListener;
import com.lucent.ra.nms.model.LEDataSpec;
import com.lucent.ra.nms.model.LEPortMaster;
import com.lucent.ra.nms.ui.LEIPPanel;
import com.lucent.ra.nms.util.LEHelpManager;
import java.awt.Choice;
import java.awt.FlowLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

public class LEBGPPrefixFormLine
extends Panel
implements LEFormLine,
MouseListener {
    LEFormLineListener m_listener;
    String m_valid;
    LEIPPanel m_ip = new LEIPPanel();
    Choice m_cidr;

    public LEBGPPrefixFormLine() {
        super(new FlowLayout(0, 0, 0));
        this.add(this.m_ip);
        this.add(new Label(" /"));
        this.m_cidr = new Choice();
        this.initCIDR();
        this.add(this.m_cidr);
        this.addMouseListener(this);
    }

    public void initFormLine(LEPortMaster pm, LEDataSpec spec) {
    }

    public void setListener(LEFormLineListener listener) {
        this.m_listener = listener;
    }

    public void setValue(Object field) {
        int pos;
        String val = field.toString();
        if (val.length() > 0 && (pos = val.indexOf(47)) > 0) {
            this.m_ip.setAddress(val.substring(0, pos));
            this.m_cidr.select(val.substring(pos + 1));
        }
    }

    public String getValue() {
        StringBuffer buf = new StringBuffer();
        String addr = this.m_ip.getAddress();
        if (addr.equals("")) {
            return "";
        }
        buf.append(addr);
        buf.append("/");
        buf.append(this.m_cidr.getSelectedItem());
        return buf.toString();
    }

    public String getValidValues() {
        if (this.m_valid == null) {
            StringBuffer buf = new StringBuffer();
            int i = 0;
            while (i < 4) {
                if (i > 0) {
                    buf.append('.');
                }
                buf.append(0);
                ++i;
            }
            buf.append("/8 - ");
            int i2 = 0;
            while (i2 < 4) {
                if (i2 > 0) {
                    buf.append('.');
                }
                buf.append(255);
                ++i2;
            }
            buf.append("/32");
            this.m_valid = buf.toString();
        }
        return this.m_valid;
    }

    public boolean equalsField(Object field) {
        if (field instanceof String) {
            String val = this.getValue();
            return val.equals((String)field);
        }
        return false;
    }

    public void keyReleased(KeyEvent event) {
    }

    public void keyTyped(KeyEvent event) {
    }

    public boolean isValueValid() {
        return true;
    }

    public void mouseClicked(MouseEvent event) {
    }

    public void mouseEntered(MouseEvent event) {
        LEHelpManager.SetHelp(this.getValidValues());
    }

    public void mouseExited(MouseEvent event) {
    }

    public void mousePressed(MouseEvent event) {
    }

    public void mouseReleased(MouseEvent event) {
    }

    protected void initCIDR() {
        int i = 8;
        while (i < 33) {
            this.m_cidr.add(Integer.toString(i));
            ++i;
        }
        this.m_cidr.select("20");
    }
}

