/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.forms;

import com.lucent.ra.nms.forms.LEFormLine;
import com.lucent.ra.nms.forms.LEFormLineEvent;
import com.lucent.ra.nms.forms.LEFormLineListener;
import com.lucent.ra.nms.model.LEAttributes;
import com.lucent.ra.nms.model.LEDataSpec;
import com.lucent.ra.nms.model.LEPortMaster;
import com.lucent.ra.nms.ui.LETextField;
import com.lucent.ra.nms.util.LEDebug;
import com.lucent.ra.nms.util.LEHelpManager;
import com.lucent.ra.nms.util.LEITSParamParser;
import java.awt.TextComponent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

public class LECustParamFormLine
extends LETextField
implements LEFormLine,
ActionListener,
MouseListener {
    public static final int DEFAULT_SIZE = 60;
    public static final char ECHO_CHAR = '*';
    LEFormLineListener m_listener;
    String m_valid;
    int m_maxLen;

    public LECustParamFormLine() {
        super(60);
        this.addActionListener(this);
        this.addMouseListener(this);
    }

    public void initFormLine(LEPortMaster pm, LEDataSpec spec) {
        block4: {
            String max;
            if (spec == null) break block4;
            if (spec.getAttribute(LEAttributes.WRITEONLY) != null) {
                this.setEchoChar('*');
            }
            if ((max = (String)spec.getAttribute(LEAttributes.MAXIMUM)) != null) {
                try {
                    this.m_maxLen = Math.min(Integer.parseInt(max), 60);
                    this.setColumns(this.m_maxLen);
                }
                catch (NumberFormatException e) {
                    LEDebug.getLog().logln(20, e);
                }
            }
        }
    }

    public void setValue(Object field) {
        ((TextComponent)this).setText(field.toString().toUpperCase());
    }

    public void setListener(LEFormLineListener listener) {
        this.m_listener = listener;
    }

    public String getValue() {
        return this.getText().toUpperCase();
    }

    public String getValidValues() {
        if (this.m_valid == null) {
            StringBuffer buf = new StringBuffer("See PacketStar ITS Network Administration manual for valid syntax");
            this.m_valid = buf.toString();
        }
        return this.m_valid;
    }

    public boolean equalsField(Object field) {
        if (field != null) {
            String oldVal = field.toString();
            String val = this.getValue();
            if (val.compareTo("") == 0) {
                return false;
            }
            return val.equals(oldVal);
        }
        return false;
    }

    public boolean isValueValid() {
        LEITSParamParser param = new LEITSParamParser();
        String pstring = this.getText().trim().toUpperCase();
        return param.isValidString(pstring);
    }

    public void actionPerformed(ActionEvent event) {
        if (this.m_listener != null) {
            LEFormLineEvent formEvent = new LEFormLineEvent(this, this.getValue());
            this.m_listener.formLineValueChanged(formEvent);
        }
    }

    public void mouseClicked(MouseEvent event) {
    }

    public void mouseEntered(MouseEvent event) {
        LEHelpManager.SetHelp(this.getValidValues());
    }

    public void mouseExited(MouseEvent event) {
        LEHelpManager.SetHelp("");
    }

    public void mousePressed(MouseEvent event) {
    }

    public void mouseReleased(MouseEvent event) {
    }
}

