/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.forms;

import com.lucent.ra.nms.forms.LEAddDialog;
import com.lucent.ra.nms.forms.LECmdErrorDialog;
import com.lucent.ra.nms.forms.LEFormLine;
import com.lucent.ra.nms.forms.LEFormLineFactory;
import com.lucent.ra.nms.forms.LELoginUsersForm;
import com.lucent.ra.nms.forms.LENewEntry;
import com.lucent.ra.nms.forms.LERenameDialog;
import com.lucent.ra.nms.forms.LETableForm;
import com.lucent.ra.nms.model.LEDBLoginUser;
import com.lucent.ra.nms.model.LEDBLoginUsers;
import com.lucent.ra.nms.model.LEDataSpec;
import com.lucent.ra.nms.model.LEPortMaster;
import com.lucent.ra.nms.model.LETable;
import com.lucent.ra.nms.model.LEUsers;
import com.lucent.ra.nms.ui.LECompGrid;
import com.lucent.ra.nms.ui.LEErrorDialog;
import com.lucent.ra.nms.ui.LEFont;
import com.lucent.ra.nms.ui.LEUiUtils;
import com.lucent.ra.nms.util.LEVector;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Label;
import java.awt.Panel;

public class LEDBLoginUsersForm
extends LETableForm {
    String m_addName;
    String m_addPhone;

    public LEDBLoginUsersForm() {
        this.m_renameEntries = true;
    }

    boolean addNewEntry(LEDataSpec keySpec, LEDataSpec entrySpec) {
        Panel panel = new Panel();
        panel.setLayout(new BorderLayout());
        LEDataSpec spec = entrySpec.getSpecFor("301");
        Component[][] comps = new Component[2][2];
        comps[0][0] = new Label(String.valueOf(keySpec.getDescription()) + ":");
        comps[0][0].setFont(LEFont.getBoldFont());
        comps[0][1] = LEFormLineFactory.BuildFormLine(null, null, null, keySpec);
        comps[1][0] = new Label(String.valueOf(spec.getDescription()) + ":");
        comps[1][0].setFont(LEFont.getBoldFont());
        comps[1][1] = LEFormLineFactory.BuildFormLine(null, null, null, spec);
        panel.add("Center", new LECompGrid(comps, 2, false));
        LEAddDialog dlg = new LEAddDialog(LEUiUtils.GetBaseFrame(), "Add Dialback Login User", panel);
        if (dlg.okay()) {
            this.m_addName = ((LEFormLine)((Object)comps[0][1])).getValue();
            this.m_addPhone = ((LEFormLine)((Object)comps[1][1])).getValue();
            if (this.m_addName.length() > 0 && this.m_addPhone.length() > 0) {
                return true;
            }
            if (this.m_addName.length() == 0) {
                new LEErrorDialog(LEUiUtils.GetBaseFrame(), "A user name must be specified");
            } else if (this.m_addPhone.length() == 0) {
                new LEErrorDialog(LEUiUtils.GetBaseFrame(), "A telephone number must be specified");
            }
        }
        return false;
    }

    LENewEntry addNewEntryTo(LEPortMaster pm) {
        LENewEntry entry = null;
        LEUsers users = (LEUsers)pm.get("1835008");
        if (users.getUser(this.m_addName) == null) {
            LEDBLoginUsers table = (LEDBLoginUsers)this.getTable(pm);
            LEVector errors = table.add(this.m_addName, this.m_addPhone);
            if (errors != null) {
                new LECmdErrorDialog(LEUiUtils.GetBaseFrame(), pm.getConnectionFacade(), errors);
            }
            this.addEntry(pm.getDescription(), table, this.m_addName);
            entry = new LENewEntry(pm, table, this.m_addName);
        } else {
            new LEErrorDialog(LEUiUtils.GetBaseFrame(), String.valueOf(pm.getDescription()) + " already contains a user named " + this.m_addName);
        }
        return entry;
    }

    void delete(LEPortMaster pm, LETable table, String key) {
        if (!(table instanceof LEDBLoginUsers)) {
            return;
        }
        LEDBLoginUsers users = (LEDBLoginUsers)table;
        LEVector errors = users.delete(key);
        if (errors != null) {
            new LECmdErrorDialog(LEUiUtils.GetBaseFrame(), pm.getConnectionFacade(), errors);
        }
    }

    String getPasteKey(LEPortMaster pm, Object obj) {
        LEVector errors;
        if (!(obj instanceof LEDBLoginUser)) {
            return null;
        }
        LEDBLoginUser user = (LEDBLoginUser)obj;
        LEDBLoginUsers users = (LEDBLoginUsers)this.getTable(pm);
        String name = user.getName();
        String phone = (String)user.get("301");
        if (phone == null) {
            return null;
        }
        LEUsers allUsers = (LEUsers)pm.get("1835008");
        if (allUsers.getUser(name) != null) {
            name = LELoginUsersForm.GetUniqueKey(allUsers, name, 8);
        }
        if ((errors = users.add(name, phone)) != null) {
            new LECmdErrorDialog(LEUiUtils.GetBaseFrame(), pm.getConnectionFacade(), errors);
            name = null;
        }
        return name;
    }

    String renameEntry(LEPortMaster pm, LETable table, String name) {
        String newKey = null;
        LERenameDialog dlg = new LERenameDialog(LEUiUtils.GetBaseFrame(), table.getKeySpec(), name);
        String newName = dlg.getNewName();
        if (newName != null) {
            LEUsers users = (LEUsers)pm.get("1835008");
            Object obj = users.getUser(newName);
            if (obj == null) {
                LEDBLoginUser user = (LEDBLoginUser)table.get(name);
                String phone = (String)user.get("301");
                LEVector errors = ((LEDBLoginUsers)table).add(newName, phone);
                if (errors == null) {
                    newKey = newName;
                } else {
                    new LECmdErrorDialog(LEUiUtils.GetBaseFrame(), pm.getConnectionFacade(), errors);
                }
            } else {
                new LEErrorDialog(LEUiUtils.GetBaseFrame(), String.valueOf(pm.getDescription()) + " already contains a user named " + newName);
            }
        }
        return newKey;
    }
}

