/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.forms;

import com.lucent.ra.nms.forms.LEAddDialog;
import com.lucent.ra.nms.forms.LECmdErrorDialog;
import com.lucent.ra.nms.forms.LEFormLine;
import com.lucent.ra.nms.forms.LEFormLineFactory;
import com.lucent.ra.nms.forms.LELoginUsersForm;
import com.lucent.ra.nms.forms.LENewEntry;
import com.lucent.ra.nms.forms.LERenameDialog;
import com.lucent.ra.nms.forms.LETableForm;
import com.lucent.ra.nms.model.LEDBNetUser;
import com.lucent.ra.nms.model.LEDBNetUsers;
import com.lucent.ra.nms.model.LEDataSpec;
import com.lucent.ra.nms.model.LELocations;
import com.lucent.ra.nms.model.LEPortMaster;
import com.lucent.ra.nms.model.LETable;
import com.lucent.ra.nms.model.LEUsers;
import com.lucent.ra.nms.ui.LEErrorDialog;
import com.lucent.ra.nms.ui.LEFont;
import com.lucent.ra.nms.ui.LEUiUtils;
import com.lucent.ra.nms.util.LEVector;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Label;
import java.awt.Panel;

public class LEDBNetUsersForm
extends LETableForm {
    String m_addName;
    String m_addLoc;

    public LEDBNetUsersForm() {
        this.m_renameEntries = true;
    }

    boolean addNewEntry(LEDataSpec keySpec, LEDataSpec entrySpec) {
        Panel panel = new Panel();
        panel.setLayout(new BorderLayout());
        Label lbl = new Label(String.valueOf(keySpec.getDescription()) + ":");
        lbl.setFont(LEFont.getBoldFont());
        panel.add("West", lbl);
        Component comp = LEFormLineFactory.BuildFormLine(null, null, null, keySpec);
        panel.add("Center", comp);
        LEAddDialog dlg = new LEAddDialog(LEUiUtils.GetBaseFrame(), "Add Dialback Network User", panel);
        if (dlg.okay()) {
            this.m_addName = ((LEFormLine)((Object)comp)).getValue();
            if (this.m_addName.length() > 0) {
                return true;
            }
            if (this.m_addName.length() == 0) {
                new LEErrorDialog(LEUiUtils.GetBaseFrame(), "A user name must be specified");
            }
        }
        return false;
    }

    LENewEntry addNewEntryTo(LEPortMaster pm) {
        LENewEntry entry = null;
        LEUsers users = (LEUsers)pm.get("1835008");
        if (users.getUser(this.m_addName) == null) {
            LELocations locs = (LELocations)pm.get("1703936");
            if (locs == null || locs.size() == 0) {
                new LEErrorDialog(LEUiUtils.GetBaseFrame(), String.valueOf(pm.getDescription()) + " must contain at least one location before you can add a dialback network user");
                return null;
            }
            LEDBNetUsers table = (LEDBNetUsers)this.getTable(pm);
            this.m_addLoc = this.getLocationName(pm, table);
            if (this.m_addLoc == null) {
                return null;
            }
            LEVector errors = table.add(this.m_addName, this.m_addLoc);
            if (errors != null) {
                new LECmdErrorDialog(LEUiUtils.GetBaseFrame(), pm.getConnectionFacade(), errors);
            }
            this.addEntry(pm.getDescription(), table, this.m_addName);
            entry = new LENewEntry(pm, table, this.m_addName);
        } else {
            new LEErrorDialog(LEUiUtils.GetBaseFrame(), String.valueOf(pm.getDescription()) + " already contains a user named " + this.m_addName);
        }
        return entry;
    }

    String getLocationName(LEPortMaster pm, LEDBNetUsers users) {
        String locName = null;
        LEDataSpec entrySpec = users.getSpecFor("entry");
        LEDataSpec spec = entrySpec.getSpecFor("368");
        Panel panel = new Panel();
        panel.setLayout(new BorderLayout());
        Label lbl = new Label("Select location for " + pm.getDescription() + ":", 1);
        lbl.setFont(LEFont.getBoldFont());
        panel.add("North", lbl);
        lbl = new Label("Location:");
        lbl.setFont(LEFont.getBoldFont());
        panel.add("West", lbl);
        Component comp = LEFormLineFactory.BuildFormLine(pm, null, null, spec);
        panel.add("Center", comp);
        LEAddDialog dlg = new LEAddDialog(LEUiUtils.GetBaseFrame(), "Select Location for Dialback Network User", panel);
        if (dlg.okay()) {
            locName = ((LEFormLine)((Object)comp)).getValue();
        }
        return locName;
    }

    void delete(LEPortMaster pm, LETable table, String key) {
        if (!(table instanceof LEDBNetUsers)) {
            return;
        }
        LEDBNetUsers users = (LEDBNetUsers)table;
        LEVector errors = users.delete(key);
        if (errors != null) {
            new LECmdErrorDialog(LEUiUtils.GetBaseFrame(), pm.getConnectionFacade(), errors);
        }
    }

    String getPasteKey(LEPortMaster pm, Object obj) {
        LEVector errors;
        if (!(obj instanceof LEDBNetUser)) {
            return null;
        }
        LEDBNetUser user = (LEDBNetUser)obj;
        LEDBNetUsers users = (LEDBNetUsers)this.getTable(pm);
        String name = user.getName();
        String loc = (String)user.get("368");
        if (loc == null) {
            return null;
        }
        LEUsers allUsers = (LEUsers)pm.get("1835008");
        if (allUsers.getUser(name) != null) {
            name = LELoginUsersForm.GetUniqueKey(allUsers, name, 8);
        }
        if ((errors = users.add(name, loc)) != null) {
            new LECmdErrorDialog(LEUiUtils.GetBaseFrame(), pm.getConnectionFacade(), errors);
            name = null;
        }
        return name;
    }

    String renameEntry(LEPortMaster pm, LETable table, String name) {
        String newKey = null;
        LERenameDialog dlg = new LERenameDialog(LEUiUtils.GetBaseFrame(), table.getKeySpec(), name);
        String newName = dlg.getNewName();
        if (newName != null) {
            LEUsers users = (LEUsers)pm.get("1835008");
            Object obj = users.getUser(newName);
            if (obj == null) {
                LEDBNetUser user = (LEDBNetUser)table.get(name);
                String loc = (String)user.get("368");
                LEVector errors = ((LEDBNetUsers)table).add(newName, loc);
                if (errors == null) {
                    newKey = newName;
                } else {
                    new LECmdErrorDialog(LEUiUtils.GetBaseFrame(), pm.getConnectionFacade(), errors);
                }
            } else {
                new LEErrorDialog(LEUiUtils.GetBaseFrame(), String.valueOf(pm.getDescription()) + " already contains a user named " + newName);
            }
        }
        return newKey;
    }
}

