/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.forms;

import com.lucent.ra.nms.forms.LEFormLine;
import com.lucent.ra.nms.forms.LEFormLineEvent;
import com.lucent.ra.nms.forms.LEFormLineListener;
import com.lucent.ra.nms.model.LEAttributes;
import com.lucent.ra.nms.model.LEDataSpec;
import com.lucent.ra.nms.model.LEPortMaster;
import com.lucent.ra.nms.util.LEHelpManager;
import com.lucent.ra.nms.util.LEVector;
import java.awt.Choice;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;

public class LEEnumFormLine
extends Choice
implements LEFormLine,
ItemListener,
MouseListener {
    public static final String BLANK = "NONE";
    LEVector m_values = new LEVector();
    LEFormLineListener m_listener;
    String m_valid;

    public LEEnumFormLine() {
        this.addItemListener(this);
        this.addMouseListener(this);
    }

    public void initFormLine(LEPortMaster pm, LEDataSpec spec) {
        if (spec != null) {
            Object obj = spec.getAttribute(LEAttributes.VALUES);
            if (obj instanceof String) {
                this.m_values.addElement(obj);
            } else if (obj instanceof Vector) {
                this.m_values.addVector((Vector)obj);
            }
        }
        int len = this.m_values.size();
        int i = 0;
        while (i < len) {
            this.addItem((String)this.m_values.elementAt(i));
            ++i;
        }
    }

    public void setListener(LEFormLineListener listener) {
        this.m_listener = listener;
    }

    public void setValue(Object field) {
        String newValue = field.toString();
        int index = 0;
        int len = this.m_values.size();
        int i = 0;
        while (i < len) {
            String val = (String)this.m_values.elementAt(i);
            if (val.equalsIgnoreCase(newValue)) {
                index = i;
                i = len;
            }
            ++i;
        }
        this.select(index);
    }

    public String getValue() {
        return this.getSelectedItem();
    }

    public String getValidValues() {
        if (this.m_valid == null) {
            StringBuffer buf = new StringBuffer();
            int count = this.getItemCount();
            int i = 0;
            while (i < count) {
                String item;
                if (i > 0) {
                    buf.append(", ");
                }
                if ((item = this.getItem(i)).length() > 0) {
                    buf.append(item);
                } else {
                    buf.append(BLANK);
                }
                ++i;
            }
            this.m_valid = buf.toString();
        }
        return this.m_valid;
    }

    public boolean equalsField(Object field) {
        if (field instanceof String) {
            String val = this.getSelectedItem();
            return val.equalsIgnoreCase((String)field);
        }
        return false;
    }

    public boolean isValueValid() {
        return true;
    }

    public void itemStateChanged(ItemEvent event) {
        if (this.m_listener != null) {
            LEFormLineEvent formEvent = new LEFormLineEvent(this, this.getSelectedItem());
            this.m_listener.formLineValueChanged(formEvent);
        }
    }

    public void mouseClicked(MouseEvent event) {
    }

    public void mouseEntered(MouseEvent event) {
        LEHelpManager.SetHelp(this.getValidValues());
    }

    public void mouseExited(MouseEvent event) {
        LEHelpManager.SetHelp("");
    }

    public void mousePressed(MouseEvent event) {
    }

    public void mouseReleased(MouseEvent event) {
    }
}

