/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.forms;

import com.lucent.ra.nms.forms.LEAddDialog;
import com.lucent.ra.nms.forms.LECmdErrorDialog;
import com.lucent.ra.nms.forms.LEFormLine;
import com.lucent.ra.nms.forms.LEFormLineFactory;
import com.lucent.ra.nms.forms.LENewEntry;
import com.lucent.ra.nms.forms.LERenameDialog;
import com.lucent.ra.nms.forms.LETableForm;
import com.lucent.ra.nms.model.LEDataSpec;
import com.lucent.ra.nms.model.LEFilter;
import com.lucent.ra.nms.model.LEFilters;
import com.lucent.ra.nms.model.LEPortMaster;
import com.lucent.ra.nms.model.LETable;
import com.lucent.ra.nms.ui.LEErrorDialog;
import com.lucent.ra.nms.ui.LEFont;
import com.lucent.ra.nms.ui.LEUiUtils;
import com.lucent.ra.nms.util.LEVector;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Label;
import java.awt.Panel;

public class LEFiltersForm
extends LETableForm {
    static final String PORTMASTER = "Device";
    static final String BLANK = "";
    String m_addName;

    public LEFiltersForm() {
        this.m_renameEntries = true;
    }

    public void setContext(String platform, LEVector context) {
        this.m_platform = platform;
        this.m_context = context;
        this.m_tags.addElement("ip_rule");
        this.m_tags.addElement("ipx_rule");
        this.m_tags.addElement("sap_rule");
        this.m_cols = this.m_tags.size();
        this.initialize(1, 2, this.m_cols);
        String[] titles = new String[this.m_cols + 2];
        titles[0] = PORTMASTER;
        titles[1] = "Filter";
        titles[2] = "IP Rule Count";
        titles[3] = "IPX Rule Count";
        titles[4] = "SAP Rule Count";
        this.setTitles(0, titles);
    }

    void addEntry(String host, LETable table, String key) {
        String[] data = new String[this.m_cols + 2];
        data[0] = host;
        data[1] = key;
        Object obj = table.get(key);
        if (obj instanceof LEFilter) {
            LEFilter filter = (LEFilter)obj;
            if ((obj = filter.get("ip_rule")) instanceof LETable) {
                data[2] = Integer.toString(((LETable)obj).size());
            }
            if ((obj = filter.get("ipx_rule")) instanceof LETable) {
                data[3] = Integer.toString(((LETable)obj).size());
            }
            if ((obj = filter.get("sap_rule")) instanceof LETable) {
                data[4] = Integer.toString(((LETable)obj).size());
            }
        }
        this.addRow(data);
    }

    boolean addNewEntry(LEDataSpec keySpec, LEDataSpec entrySpec) {
        Panel panel = new Panel();
        panel.setLayout(new BorderLayout());
        Label lbl = new Label("Filter Name:");
        lbl.setFont(LEFont.getBoldFont());
        panel.add("West", lbl);
        Component comp = LEFormLineFactory.BuildFormLine(null, null, null, keySpec);
        panel.add("Center", comp);
        LEAddDialog dlg = new LEAddDialog(LEUiUtils.GetBaseFrame(), "Add Filter", panel);
        if (dlg.okay()) {
            this.m_addName = ((LEFormLine)((Object)comp)).getValue();
            if (this.m_addName.length() > 0) {
                return true;
            }
            new LEErrorDialog(LEUiUtils.GetBaseFrame(), "A filter name must be entered");
        }
        return false;
    }

    LENewEntry addNewEntryTo(LEPortMaster pm) {
        LENewEntry entry = null;
        LETable table = this.getTable(pm);
        if (table.get(this.m_addName) == null) {
            LEVector errors = ((LEFilters)table).add(this.m_addName);
            if (errors != null) {
                new LECmdErrorDialog(LEUiUtils.GetBaseFrame(), pm.getConnectionFacade(), errors);
            }
            this.addEntry(pm.getDescription(), table, this.m_addName);
            entry = new LENewEntry(pm, table, this.m_addName);
        } else {
            new LEErrorDialog(LEUiUtils.GetBaseFrame(), String.valueOf(pm.getDescription()) + " already contains a filter named " + this.m_addName);
        }
        return entry;
    }

    void delete(LEPortMaster pm, LETable table, String key) {
        if (!(table instanceof LEFilters)) {
            return;
        }
        LEFilters filters = (LEFilters)table;
        LEVector errors = filters.delete(key);
        if (errors != null) {
            new LECmdErrorDialog(LEUiUtils.GetBaseFrame(), pm.getConnectionFacade(), errors);
        }
    }

    String getPasteKey(LEPortMaster pm, Object obj) {
        LEVector errors;
        String name;
        if (!(obj instanceof LEFilter)) {
            return null;
        }
        LEFilter filter = (LEFilter)obj;
        LEFilters filters = (LEFilters)this.getTable(pm);
        if (filters.get(name = filter.getName()) != null) {
            name = LETableForm.GetUniqueKey(filters, name, 16);
        }
        if ((errors = filters.add(name)) != null) {
            new LECmdErrorDialog(LEUiUtils.GetBaseFrame(), pm.getConnectionFacade(), errors);
            name = null;
        }
        return name;
    }

    String renameEntry(LEPortMaster pm, LETable table, String name) {
        String newKey = null;
        LERenameDialog dlg = new LERenameDialog(LEUiUtils.GetBaseFrame(), table.getKeySpec(), name);
        String newName = dlg.getNewName();
        if (newName != null) {
            Object obj = table.get(newName);
            if (obj == null) {
                LEVector errors = ((LEFilters)table).add(newName);
                if (errors == null) {
                    newKey = newName;
                } else {
                    new LECmdErrorDialog(LEUiUtils.GetBaseFrame(), pm.getConnectionFacade(), errors);
                }
            } else {
                new LEErrorDialog(LEUiUtils.GetBaseFrame(), String.valueOf(pm.getDescription()) + " already contains a filter named " + newName);
            }
        }
        return newKey;
    }
}

