/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.forms;

import com.lucent.ra.nms.forms.LEFormLine;
import com.lucent.ra.nms.forms.LEStringFormLine;
import com.lucent.ra.nms.model.LEAttributes;
import com.lucent.ra.nms.model.LEConfig;
import com.lucent.ra.nms.model.LEDataSpec;
import com.lucent.ra.nms.model.LEPortMaster;
import com.lucent.ra.nms.util.LEDebug;
import java.awt.Button;
import java.awt.Component;
import java.awt.Label;
import java.util.Hashtable;

public class LEFormLineFactory {
    static final String PREFIX = "com.lucent.ra.nms.forms.LE";
    static final String SUFFIX = "FormLine";
    static Hashtable s_classes = new Hashtable();

    public static Component BuildFormLine(LEPortMaster pm, String key, Object field, LEDataSpec spec) {
        Component comp = null;
        if (field instanceof LEConfig) {
            String des = spec.getDescription();
            if (des == null) {
                des = key;
            }
            comp = new Button(String.valueOf(des) + "...");
        } else if (spec == null) {
            LEStringFormLine fl = new LEStringFormLine();
            fl.setValue(field);
            comp = fl;
        } else if (spec.getAttribute(LEAttributes.READONLY) != null) {
            comp = new Label(field.toString(), 0);
        } else if (field instanceof LEConfig) {
            String des = spec.getDescription();
            if (des == null) {
                des = key;
            }
            comp = new Button(String.valueOf(des) + "...");
        } else {
            String type = spec.getType();
            String classname = (String)s_classes.get(type);
            if (classname == null) {
                StringBuffer buf = new StringBuffer(PREFIX);
                buf.append(type);
                buf.append(SUFFIX);
                classname = buf.toString();
                s_classes.put(type, classname);
            }
            try {
                Class<?> formClass = Class.forName(classname);
                Object obj = formClass.newInstance();
                if (obj instanceof LEFormLine && obj instanceof Component) {
                    LEFormLine form = (LEFormLine)obj;
                    form.initFormLine(pm, spec);
                    if (field != null) {
                        form.setValue(field);
                    }
                    comp = (Component)obj;
                }
            }
            catch (ClassNotFoundException e) {
                LEDebug.getLog().logln(20, e);
            }
            catch (InstantiationException e) {
                LEDebug.getLog().logln(20, e);
            }
            catch (IllegalAccessException e) {
                LEDebug.getLog().logln(20, e);
            }
            if (comp == null) {
                LEStringFormLine fl = new LEStringFormLine();
                fl.initFormLine(pm, spec);
                if (field != null) {
                    fl.setValue(field);
                }
                comp = fl;
            }
        }
        return comp;
    }
}

