/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.forms;

import com.lucent.ra.nms.forms.LEAddDialog;
import com.lucent.ra.nms.forms.LECmdErrorDialog;
import com.lucent.ra.nms.forms.LEFormLine;
import com.lucent.ra.nms.forms.LEFormLineFactory;
import com.lucent.ra.nms.forms.LENewEntry;
import com.lucent.ra.nms.forms.LETableForm;
import com.lucent.ra.nms.model.LEDataSpec;
import com.lucent.ra.nms.model.LEGroup;
import com.lucent.ra.nms.model.LEGroups;
import com.lucent.ra.nms.model.LEPortMaster;
import com.lucent.ra.nms.model.LETable;
import com.lucent.ra.nms.ui.LECompGrid;
import com.lucent.ra.nms.ui.LEErrorDialog;
import com.lucent.ra.nms.ui.LEFont;
import com.lucent.ra.nms.ui.LEUiUtils;
import com.lucent.ra.nms.util.LEVector;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Label;
import java.awt.Panel;

public class LEGroupsForm
extends LETableForm {
    String m_addGroup;
    String m_addChannels;
    String m_addRate;

    boolean addNewEntry(LEDataSpec keySpec, LEDataSpec entrySpec) {
        Panel panel = new Panel();
        panel.setLayout(new BorderLayout());
        Component[][] comps = new Component[3][2];
        comps[0][0] = new Label(String.valueOf(keySpec.getDescription()) + ":");
        comps[0][0].setFont(LEFont.getBoldFont());
        comps[0][1] = LEFormLineFactory.BuildFormLine(null, null, null, keySpec);
        LEDataSpec spec = entrySpec.getSpecFor(LEGroup.CHANNELS);
        comps[1][0] = new Label(String.valueOf(spec.getDescription()) + ":");
        comps[1][0].setFont(LEFont.getBoldFont());
        comps[1][1] = LEFormLineFactory.BuildFormLine(null, null, null, spec);
        spec = entrySpec.getSpecFor(LEGroup.SPEED);
        comps[2][0] = new Label(String.valueOf(spec.getDescription()) + ":");
        comps[2][0].setFont(LEFont.getBoldFont());
        comps[2][1] = LEFormLineFactory.BuildFormLine(null, null, null, spec);
        panel.add("Center", new LECompGrid(comps, 2, false));
        LEAddDialog dlg = new LEAddDialog(LEUiUtils.GetBaseFrame(), "Add Group", panel);
        if (dlg.okay()) {
            this.m_addGroup = ((LEFormLine)((Object)comps[0][1])).getValue();
            this.m_addChannels = ((LEFormLine)((Object)comps[1][1])).getValue();
            this.m_addRate = ((LEFormLine)((Object)comps[2][1])).getValue();
            if (this.m_addChannels.length() > 0) {
                return true;
            }
            new LEErrorDialog(LEUiUtils.GetBaseFrame(), "A list of channels must be specified");
        }
        return false;
    }

    LENewEntry addNewEntryTo(LEPortMaster pm) {
        LENewEntry entry = null;
        LEGroups table = (LEGroups)this.getTable(pm);
        if (table.get(this.m_addGroup) == null) {
            LEVector errors = table.add(this.m_addGroup, this.m_addChannels, this.m_addRate);
            if (errors != null) {
                new LECmdErrorDialog(LEUiUtils.GetBaseFrame(), pm.getConnectionFacade(), errors);
            }
            this.addEntry(pm.getDescription(), table, this.m_addGroup);
            entry = new LENewEntry(pm, table, this.m_addGroup);
        } else {
            new LEErrorDialog(LEUiUtils.GetBaseFrame(), String.valueOf(pm.getDescription()) + " " + table.getLine() + " already contains group " + this.m_addGroup);
        }
        return entry;
    }

    void delete(LEPortMaster pm, LETable table, String key) {
        if (!(table instanceof LEGroups)) {
            return;
        }
        LEGroups groups = (LEGroups)table;
        LEVector errors = groups.delete(key);
        if (errors != null) {
            new LECmdErrorDialog(LEUiUtils.GetBaseFrame(), pm.getConnectionFacade(), errors);
        }
    }

    void pasteEntryTo(LEPortMaster pm, Object obj) {
        String key = this.getPasteKey(pm, obj);
        if (key == null) {
            return;
        }
        this.updateEntry(pm.getDescription(), this.getTable(pm), key);
    }

    String getPasteKey(LEPortMaster pm, Object obj) {
        String cgroup;
        if (!(obj instanceof LEGroup)) {
            return null;
        }
        LEGroup group = (LEGroup)obj;
        LEGroups groups = (LEGroups)this.getTable(pm);
        if (groups.get(cgroup = group.getCGroup()) != null) {
            new LEErrorDialog(LEUiUtils.GetBaseFrame(), String.valueOf(pm.getDescription()) + " " + groups.getLine() + " already contains group " + cgroup);
            cgroup = null;
        } else {
            String channels = (String)group.get(LEGroup.CHANNELS);
            String rate = (String)group.get(LEGroup.SPEED);
            if (channels == null || rate == null) {
                return null;
            }
            LEVector errors = groups.add(cgroup, channels, rate);
            if (errors != null) {
                new LECmdErrorDialog(LEUiUtils.GetBaseFrame(), pm.getConnectionFacade(), errors);
                cgroup = null;
            }
        }
        return cgroup;
    }
}

