/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.forms;

import com.lucent.ra.nms.forms.LEAddDialog;
import com.lucent.ra.nms.forms.LECmdErrorDialog;
import com.lucent.ra.nms.forms.LEFormLine;
import com.lucent.ra.nms.forms.LEFormLineFactory;
import com.lucent.ra.nms.forms.LENewEntry;
import com.lucent.ra.nms.forms.LETableForm;
import com.lucent.ra.nms.model.LEDataSpec;
import com.lucent.ra.nms.model.LEIPRules;
import com.lucent.ra.nms.model.LEPortMaster;
import com.lucent.ra.nms.model.LETable;
import com.lucent.ra.nms.ui.LEFont;
import com.lucent.ra.nms.ui.LEUiUtils;
import com.lucent.ra.nms.util.LEDebug;
import com.lucent.ra.nms.util.LEVector;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Label;
import java.awt.Panel;

public class LEIPRulesForm
extends LETableForm {
    String m_addAction;

    boolean addNewEntry(LEDataSpec keySpec, LEDataSpec entrySpec) {
        Panel panel = new Panel();
        panel.setLayout(new BorderLayout());
        LEDataSpec spec = entrySpec.getSpecFor("action");
        Label lbl = new Label(String.valueOf(spec.getDescription()) + ": ");
        lbl.setFont(LEFont.getBoldFont());
        panel.add("West", lbl);
        Component comp = LEFormLineFactory.BuildFormLine(null, null, null, spec);
        panel.add("East", comp);
        LEAddDialog dlg = new LEAddDialog(LEUiUtils.GetBaseFrame(), "Add IP Rule", panel);
        if (dlg.okay()) {
            this.m_addAction = ((LEFormLine)((Object)comp)).getValue();
            return true;
        }
        return false;
    }

    LENewEntry addNewEntryTo(LEPortMaster pm) {
        LENewEntry entry = null;
        LEIPRules table = (LEIPRules)this.getTable(pm);
        LEVector errors = table.add(this.m_addAction);
        if (errors != null) {
            new LECmdErrorDialog(LEUiUtils.GetBaseFrame(), pm.getConnectionFacade(), errors);
            this.refresh();
        } else {
            String key = Integer.toString(table.size());
            this.addEntry(pm.getDescription(), table, key);
            entry = new LENewEntry(pm, table, key);
        }
        return entry;
    }

    void delete(LEPortMaster pm, LETable table, String key) {
        if (!(table instanceof LEIPRules)) {
            return;
        }
        LEIPRules rules = (LEIPRules)table;
        try {
            int rule = Integer.parseInt(key);
            LEVector errors = rules.delete(rule);
            if (errors != null) {
                new LECmdErrorDialog(LEUiUtils.GetBaseFrame(), pm.getConnectionFacade(), errors);
            }
        }
        catch (NumberFormatException e) {
            LEDebug.getLog().logln(20, e);
        }
    }
}

