/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.forms;

import com.lucent.ra.nms.forms.LEFormLine;
import com.lucent.ra.nms.forms.LEFormLineEvent;
import com.lucent.ra.nms.forms.LEFormLineListener;
import com.lucent.ra.nms.model.LEAttributes;
import com.lucent.ra.nms.model.LEDataSpec;
import com.lucent.ra.nms.model.LEPortMaster;
import com.lucent.ra.nms.ui.LETextField;
import com.lucent.ra.nms.util.LEDebug;
import com.lucent.ra.nms.util.LEHelpManager;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.FlowLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextComponent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

public class LEIdleFormLine
extends Panel
implements LEFormLine,
ActionListener,
ItemListener,
MouseListener {
    public static final String MINUTES_STR = new String("minutes");
    public static final String SECONDS_STR = new String("seconds");
    static final int MINUTES = 0;
    static final int SECONDS = 1;
    LETextField m_idle;
    Checkbox m_seconds;
    Checkbox m_minutes;
    int m_state;
    int m_min;
    int m_max = 1440;
    String m_valid;
    LEFormLineListener m_listener;

    public LEIdleFormLine() {
        this.setLayout(new FlowLayout(0, 0, 0));
        this.m_idle = new LETextField(3);
        this.m_idle.setNumeric(true);
        this.m_idle.addActionListener(this);
        this.m_idle.addMouseListener(this);
        this.add(this.m_idle);
        this.add(new Label(""));
        CheckboxGroup units = new CheckboxGroup();
        this.m_state = 1;
        this.m_seconds = new Checkbox(SECONDS_STR, units, true);
        this.m_seconds.addItemListener(this);
        this.m_seconds.addMouseListener(this);
        this.m_minutes = new Checkbox(MINUTES_STR, units, false);
        this.m_minutes.addItemListener(this);
        this.m_minutes.addMouseListener(this);
        this.add(this.m_seconds);
        this.add(this.m_minutes);
        this.addMouseListener(this);
    }

    public void initFormLine(LEPortMaster pm, LEDataSpec spec) {
        block6: {
            if (spec == null) {
                return;
            }
            String tmp = (String)spec.getAttribute(LEAttributes.MINIMUM);
            if (tmp != null) {
                try {
                    this.m_min = Integer.parseInt(tmp);
                }
                catch (NumberFormatException e) {
                    LEDebug.getLog().logln(20, e);
                }
            }
            if ((tmp = (String)spec.getAttribute(LEAttributes.MAXIMUM)) == null) break block6;
            try {
                this.m_max = Integer.parseInt(tmp);
            }
            catch (NumberFormatException e) {
                LEDebug.getLog().logln(20, e);
            }
        }
    }

    public void setValue(Object field) {
        String val = field.toString();
        String units = null;
        int index = val.indexOf(32);
        if (index > -1) {
            units = val.substring(index + 1, val.length());
            val = val.substring(0, index);
        }
        ((TextComponent)this.m_idle).setText(val);
        if (units != null && units.equalsIgnoreCase(SECONDS_STR)) {
            this.m_seconds.setState(true);
        } else {
            this.m_minutes.setState(true);
        }
    }

    public void setListener(LEFormLineListener listener) {
        this.m_listener = listener;
    }

    public String getValue() {
        StringBuffer buf = new StringBuffer();
        String val = this.m_idle.getText();
        if (val.length() > 0) {
            try {
                int num = Integer.parseInt(val);
                num = Math.max(num, this.m_min);
                num = Math.min(num, this.m_max);
                buf.append(Integer.toString(num));
            }
            catch (NumberFormatException e) {
                LEDebug.getLog().logln(20, e);
                buf.append(Integer.toString(this.m_min));
            }
        } else {
            buf.append(Integer.toString(0));
        }
        buf.append(' ');
        if (this.m_seconds.getState()) {
            buf.append(SECONDS_STR);
        } else {
            buf.append(MINUTES_STR);
        }
        return new String(buf);
    }

    public String getValidValues() {
        if (this.m_valid == null) {
            StringBuffer buf = new StringBuffer();
            buf.append(this.m_min);
            buf.append(" - ");
            buf.append(this.m_max);
            buf.append(" minutes or seconds");
            this.m_valid = buf.toString();
        }
        return this.m_valid;
    }

    public boolean isValueValid() {
        int value = 0;
        try {
            String val = this.m_idle.getText();
            value = Integer.parseInt(val);
        }
        catch (NumberFormatException e) {
            LEDebug.getLog().logln(20, e);
        }
        if (value < this.m_min) {
            return false;
        }
        return value <= this.m_max;
    }

    public boolean equalsField(Object field) {
        if (field != null) {
            String oldVal = field.toString();
            String val = this.getValue();
            return val.equalsIgnoreCase(oldVal);
        }
        return false;
    }

    public void itemStateChanged(ItemEvent event) {
        this.notifyListener();
    }

    public void actionPerformed(ActionEvent event) {
        this.notifyListener();
    }

    public void mouseClicked(MouseEvent event) {
    }

    public void mouseEntered(MouseEvent event) {
        LEHelpManager.SetHelp(this.getValidValues());
    }

    public void mouseExited(MouseEvent event) {
    }

    public void mousePressed(MouseEvent event) {
    }

    public void mouseReleased(MouseEvent event) {
    }

    void notifyListener() {
        if (this.m_listener != null) {
            LEFormLineEvent event = new LEFormLineEvent(this, this.getValue());
            this.m_listener.formLineValueChanged(event);
        }
    }
}

