/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.forms;

import com.lucent.ra.nms.forms.LEFormLine;
import com.lucent.ra.nms.forms.LEFormLineListener;
import com.lucent.ra.nms.model.LEBoard;
import com.lucent.ra.nms.model.LEBoards;
import com.lucent.ra.nms.model.LEDataSpec;
import com.lucent.ra.nms.model.LELines;
import com.lucent.ra.nms.model.LEPortMaster;
import com.lucent.ra.nms.util.LEVector;
import java.awt.Choice;
import java.awt.FlowLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

public class LEMuxChannelFormLine
extends Panel
implements LEFormLine,
ItemListener {
    public static final String BLANK = "";
    LEPortMaster m_pm;
    Choice m_board;
    Choice m_line;
    String m_selBoard;
    LEFormLineListener m_listener;

    public LEMuxChannelFormLine() {
        this.setLayout(new FlowLayout(0, 5, 0));
        this.add(new Label("Board:", 0));
        this.m_board = new Choice();
        this.add(this.m_board);
        this.m_board.addItemListener(this);
        this.add(new Label("Line:", 0));
        this.m_line = new Choice();
        this.add(this.m_line);
    }

    public void initFormLine(LEPortMaster pm, LEDataSpec spec) {
        this.m_pm = pm;
        LEBoards boards = (LEBoards)this.m_pm.get("2555904");
        if (boards != null) {
            this.m_board.add(BLANK);
            LEVector keys = boards.getKeys();
            int len = keys.size();
            int i = 0;
            while (i < len) {
                Object lines;
                String id = (String)keys.elementAt(i);
                LEBoard board = (LEBoard)boards.get(id);
                if (board != null && (lines = board.get(LEBoard.LINES)) != null) {
                    this.m_board.add(id);
                }
                ++i;
            }
        } else {
            this.m_board.setEnabled(false);
        }
    }

    public void itemStateChanged(ItemEvent event) {
        this.m_selBoard = this.m_board.getSelectedItem();
        this.fillLines();
    }

    public void setListener(LEFormLineListener listener) {
        this.m_listener = listener;
    }

    public void setValue(Object field) {
        if (field instanceof String) {
            String value = (String)field;
            if (value.length() == 0) {
                this.m_board.select(0);
                this.fillLines();
            } else {
                String board = value.substring(0, 1);
                String line = value.substring(2);
                this.m_board.select(board);
                this.m_selBoard = board;
                this.fillLines();
                this.m_line.select(line);
            }
        }
    }

    public String getValue() {
        StringBuffer buf = new StringBuffer();
        String board = this.m_board.getSelectedItem();
        if (!board.equals(BLANK)) {
            buf.append(board);
            buf.append(' ');
            buf.append(this.m_line.getSelectedItem());
        }
        return new String(buf);
    }

    public String getValidValues() {
        return null;
    }

    public boolean equalsField(Object field) {
        return this.getValue().equals(field);
    }

    public boolean isValueValid() {
        return true;
    }

    void fillLines() {
        LELines lines;
        LEBoards boards;
        LEBoard board;
        this.m_line.removeAll();
        if (this.m_selBoard != null && (board = (LEBoard)(boards = (LEBoards)this.m_pm.get("2555904")).get(this.m_selBoard)) != null && (lines = (LELines)board.get(LEBoard.LINES)) != null) {
            LEVector keys = lines.getKeys();
            int len = keys.size();
            int i = 0;
            while (i < len) {
                String key = (String)keys.elementAt(i);
                String line = key.substring(4);
                this.m_line.add(line);
                ++i;
            }
        }
        if (this.m_line.getItemCount() == 0) {
            this.m_line.add("0");
            this.m_line.setEnabled(false);
        } else {
            this.m_line.setEnabled(true);
        }
    }
}

