/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.forms;

import com.lucent.ra.nms.forms.LEAddDialog;
import com.lucent.ra.nms.forms.LECmdErrorDialog;
import com.lucent.ra.nms.forms.LEFormLine;
import com.lucent.ra.nms.forms.LEFormLineFactory;
import com.lucent.ra.nms.forms.LENewEntry;
import com.lucent.ra.nms.forms.LETableForm;
import com.lucent.ra.nms.model.LEDataSpec;
import com.lucent.ra.nms.model.LENATMap;
import com.lucent.ra.nms.model.LEPortMaster;
import com.lucent.ra.nms.model.LETable;
import com.lucent.ra.nms.ui.LEErrorDialog;
import com.lucent.ra.nms.ui.LEFont;
import com.lucent.ra.nms.ui.LEUiUtils;
import com.lucent.ra.nms.util.LEDebug;
import com.lucent.ra.nms.util.LEVector;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Label;
import java.awt.Panel;

public class LENATMapForm
extends LETableForm {
    private static final int MAX_RULES = 20;
    String m_addType;
    int m_numRules;

    void addEntry(String host, LETable table, String key) {
        if (table instanceof LENATMap) {
            this.m_numRules = table.size();
        }
        super.addEntry(host, table, key);
    }

    boolean addNewEntry(LEDataSpec keySpec, LEDataSpec entrySpec) {
        if (this.m_numRules < 20) {
            Panel panel = new Panel();
            panel.setLayout(new BorderLayout());
            LEDataSpec spec = entrySpec.getSpecFor("type");
            Label lbl = new Label(String.valueOf(spec.getDescription()) + ": ");
            lbl.setFont(LEFont.getBoldFont());
            panel.add("West", lbl);
            Component comp = LEFormLineFactory.BuildFormLine(null, null, null, spec);
            panel.add("East", comp);
            LEAddDialog dlg = new LEAddDialog(LEUiUtils.GetBaseFrame(), "Add NAT Map Rule", panel);
            if (dlg.okay()) {
                this.m_addType = ((LEFormLine)((Object)comp)).getValue();
                return true;
            }
        } else {
            StringBuffer errbuf = new StringBuffer();
            errbuf.append("You cannot have more than ");
            errbuf.append(20);
            errbuf.append(" rules in a NAT Map.");
            LEErrorDialog lEErrorDialog = new LEErrorDialog(LEUiUtils.GetBaseFrame(), errbuf.toString());
        }
        return false;
    }

    LENewEntry addNewEntryTo(LEPortMaster pm) {
        LENewEntry entry = null;
        LENATMap table = (LENATMap)this.getTable(pm);
        LEVector errors = null;
        if (this.m_addType.equals("addrmap") || this.m_addType.equals("staticaddrmap")) {
            errors = table.add(this.m_addType, "1.2.3.4", "1.2.3.4", false);
        } else if (this.m_addType.equals("statictuportmap")) {
            errors = table.add(this.m_addType, "1.2.3.4:1", "1.2.3.4:1", false);
        }
        if (errors != null) {
            new LECmdErrorDialog(LEUiUtils.GetBaseFrame(), pm.getConnectionFacade(), errors);
            this.refresh();
        } else {
            String key = Integer.toString(table.size());
            this.addEntry(pm.getDescription(), table, key);
            entry = new LENewEntry(pm, table, key);
        }
        return entry;
    }

    void delete(LEPortMaster pm, LETable table, String key) {
        if (!(table instanceof LENATMap)) {
            return;
        }
        LENATMap map = (LENATMap)table;
        try {
            int rule = Integer.parseInt(key);
            LEVector errors = map.delete(rule);
            if (errors != null) {
                new LECmdErrorDialog(LEUiUtils.GetBaseFrame(), pm.getConnectionFacade(), errors);
            }
        }
        catch (NumberFormatException e) {
            LEDebug.getLog().logln(20, e);
        }
    }
}

