/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.forms;

import com.lucent.ra.nms.forms.LEAddDialog;
import com.lucent.ra.nms.forms.LECmdErrorDialog;
import com.lucent.ra.nms.forms.LEFormLine;
import com.lucent.ra.nms.forms.LEFormLineFactory;
import com.lucent.ra.nms.forms.LENewEntry;
import com.lucent.ra.nms.forms.LETableForm;
import com.lucent.ra.nms.model.LEDataSpec;
import com.lucent.ra.nms.model.LEOSPFArea;
import com.lucent.ra.nms.model.LEOSPFAreas;
import com.lucent.ra.nms.model.LEPortMaster;
import com.lucent.ra.nms.model.LETable;
import com.lucent.ra.nms.ui.LEErrorDialog;
import com.lucent.ra.nms.ui.LEFont;
import com.lucent.ra.nms.ui.LEUiUtils;
import com.lucent.ra.nms.util.LEVector;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Label;
import java.awt.Panel;

public class LEOSPFAreasForm
extends LETableForm {
    String m_addArea;

    boolean addNewEntry(LEDataSpec keySpec, LEDataSpec entrySpec) {
        Panel panel = new Panel();
        panel.setLayout(new BorderLayout());
        Label lbl = new Label("OSPF Area:");
        lbl.setFont(LEFont.getBoldFont());
        panel.add("West", lbl);
        Component comp = LEFormLineFactory.BuildFormLine(null, null, null, keySpec);
        panel.add("Center", comp);
        LEAddDialog dlg = new LEAddDialog(LEUiUtils.GetBaseFrame(), "Add OSPF Area", panel);
        if (dlg.okay()) {
            this.m_addArea = ((LEFormLine)((Object)comp)).getValue();
            return true;
        }
        return false;
    }

    LENewEntry addNewEntryTo(LEPortMaster pm) {
        LENewEntry entry = null;
        LEOSPFAreas table = (LEOSPFAreas)this.getTable(pm);
        if (table.get(this.m_addArea) == null) {
            LEVector errors = table.add(this.m_addArea);
            if (errors != null) {
                new LECmdErrorDialog(LEUiUtils.GetBaseFrame(), pm.getConnectionFacade(), errors);
            }
            this.addEntry(pm.getDescription(), table, this.m_addArea);
            entry = new LENewEntry(pm, table, this.m_addArea);
        } else {
            new LEErrorDialog(LEUiUtils.GetBaseFrame(), String.valueOf(pm.getDescription()) + " already contains the OSPF area " + this.m_addArea);
        }
        return entry;
    }

    void delete(LEPortMaster pm, LETable table, String key) {
        if (!(table instanceof LEOSPFAreas)) {
            return;
        }
        LEOSPFAreas locs = (LEOSPFAreas)table;
        LEVector errors = locs.delete(key);
        if (errors != null) {
            new LECmdErrorDialog(LEUiUtils.GetBaseFrame(), pm.getConnectionFacade(), errors);
        }
    }

    String getPasteKey(LEPortMaster pm, Object obj) {
        String name;
        if (!(obj instanceof LEOSPFArea)) {
            return null;
        }
        LEOSPFArea area = (LEOSPFArea)obj;
        LEOSPFAreas areas = (LEOSPFAreas)this.getTable(pm);
        if (areas.get(name = area.getName()) != null) {
            new LEErrorDialog(LEUiUtils.GetBaseFrame(), String.valueOf(pm.getDescription()) + " already contains the OSPF area " + name);
            name = null;
        } else {
            LEVector errors = areas.add(name);
            if (errors != null) {
                new LECmdErrorDialog(LEUiUtils.GetBaseFrame(), pm.getConnectionFacade(), errors);
                name = null;
            }
        }
        return name;
    }
}

