/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.forms;

import com.lucent.ra.nms.forms.LEAddDialog;
import com.lucent.ra.nms.forms.LECmdErrorDialog;
import com.lucent.ra.nms.forms.LEFormLine;
import com.lucent.ra.nms.forms.LEFormLineFactory;
import com.lucent.ra.nms.forms.LENewEntry;
import com.lucent.ra.nms.forms.LETableForm;
import com.lucent.ra.nms.model.LEDataSpec;
import com.lucent.ra.nms.model.LEPVC;
import com.lucent.ra.nms.model.LEPVCs;
import com.lucent.ra.nms.model.LEPortMaster;
import com.lucent.ra.nms.model.LETable;
import com.lucent.ra.nms.ui.LEErrorDialog;
import com.lucent.ra.nms.ui.LEFont;
import com.lucent.ra.nms.ui.LEUiUtils;
import com.lucent.ra.nms.util.LEVector;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Label;
import java.awt.Panel;

public class LEPVCsForm
extends LETableForm {
    static final String PORTMASTER = "Device";
    static final String BLANK = "";
    String m_addName;

    public LEPVCsForm() {
        this.m_simpleTable = true;
    }

    boolean addNewEntry(LEDataSpec keySpec, LEDataSpec entrySpec) {
        Panel panel = new Panel();
        panel.setLayout(new BorderLayout());
        Label lbl = new Label(String.valueOf(keySpec.getDescription()) + ":");
        lbl.setFont(LEFont.getBoldFont());
        panel.add("West", lbl);
        Component comp = LEFormLineFactory.BuildFormLine(null, null, null, keySpec);
        panel.add("Center", comp);
        LEAddDialog dlg = new LEAddDialog(LEUiUtils.GetBaseFrame(), "Add PVC", panel);
        if (dlg.okay()) {
            this.m_addName = ((LEFormLine)((Object)comp)).getValue();
            if (this.m_addName.length() > 0) {
                return true;
            }
            new LEErrorDialog(LEUiUtils.GetBaseFrame(), "An VPI and VCI must be entered");
        }
        return false;
    }

    LENewEntry addNewEntryTo(LEPortMaster pm) {
        LENewEntry entry = null;
        LETable table = this.getTable(pm);
        if (table.get(this.m_addName) == null) {
            LEVector errors = ((LEPVCs)table).add(this.m_addName);
            if (errors != null) {
                new LECmdErrorDialog(LEUiUtils.GetBaseFrame(), pm.getConnectionFacade(), errors);
            } else {
                this.addEntry(pm.getDescription(), table, this.m_addName);
                entry = new LENewEntry(pm, table, this.m_addName);
            }
        } else {
            new LEErrorDialog(LEUiUtils.GetBaseFrame(), String.valueOf(pm.getDescription()) + " already contains a PVC " + this.m_addName);
        }
        return entry;
    }

    void delete(LEPortMaster pm, LETable table, String key) {
        if (!(table instanceof LEPVCs)) {
            return;
        }
        LEPVCs pvcs = (LEPVCs)table;
        LEVector errors = pvcs.delete(key);
        if (errors != null) {
            new LECmdErrorDialog(LEUiUtils.GetBaseFrame(), pm.getConnectionFacade(), errors);
        }
    }

    String getPasteKey(LEPortMaster pm, Object obj) {
        LEVector errors;
        String name;
        if (!(obj instanceof LEPVC)) {
            return null;
        }
        LEPVC pvc = (LEPVC)obj;
        LEPVCs pvcs = (LEPVCs)this.getTable(pm);
        if (pvcs.get(name = pvc.getPVC()) != null) {
            name = LETableForm.GetUniqueKey(pvcs, name, 9);
        }
        if ((errors = pvcs.add(name)) != null) {
            new LECmdErrorDialog(LEUiUtils.GetBaseFrame(), pm.getConnectionFacade(), errors);
            name = null;
        }
        return name;
    }
}

