/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.forms;

import com.lucent.ra.nms.forms.LEFormLine;
import com.lucent.ra.nms.forms.LEFormLineFactory;
import com.lucent.ra.nms.forms.LEStringFormLine;
import com.lucent.ra.nms.model.LEConfig;
import com.lucent.ra.nms.model.LEDataSpec;
import com.lucent.ra.nms.model.LEPortMaster;
import com.lucent.ra.nms.model.LEPrefixes;
import com.lucent.ra.nms.util.LEVector;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

public class LEPrefixesPanel
extends Panel
implements ItemListener,
ActionListener {
    LEPortMaster m_pm;
    LEPrefixes m_ordered;
    LEFormLine m_fl;
    List m_list;
    Button m_add;
    Button m_insert;
    Button m_delete;

    public LEPrefixesPanel(LEPortMaster pm, LEVector context) {
        this.setLayout(new BorderLayout(5, 5));
        this.m_pm = pm;
        LEConfig config = pm;
        int len = context.size();
        int i = 0;
        while (config != null && i < len) {
            Object obj = ((LEConfig)config).get((String)context.elementAt(i));
            config = obj instanceof LEConfig ? (LEConfig)obj : null;
            ++i;
        }
        String host = pm.getDescription();
        this.add("North", new Label(host, 1));
        if (config instanceof LEPrefixes) {
            this.m_ordered = (LEPrefixes)config;
            this.m_list = new List();
            this.add("Center", this.m_list);
            Panel sub = new Panel();
            sub.setLayout(new BorderLayout());
            Panel top = new Panel();
            top.setLayout(new BorderLayout());
            LEDataSpec spec = this.m_ordered.getSpecFor("entry");
            Component comp = LEFormLineFactory.BuildFormLine(this.m_pm, "entry", "", spec);
            if (!(comp instanceof LEFormLine)) {
                comp = new LEStringFormLine();
            }
            this.m_fl = (LEFormLine)((Object)comp);
            top.add("Center", comp);
            sub.add("North", top);
            Panel bottom = new Panel();
            bottom.setLayout(new GridLayout(1, 3, 5, 5));
            this.m_add = new Button("Add");
            bottom.add(this.m_add);
            this.m_add.addActionListener(this);
            this.m_insert = new Button("Insert");
            bottom.add(this.m_insert);
            this.m_insert.setEnabled(false);
            this.m_insert.addActionListener(this);
            this.m_delete = new Button("Delete");
            bottom.add(this.m_delete);
            this.m_delete.setEnabled(false);
            this.m_delete.addActionListener(this);
            sub.add("South", bottom);
            this.add("South", sub);
            this.fillList();
        }
    }

    public LEPrefixes getPrefixes() {
        return this.m_ordered;
    }

    public LEPortMaster getPortMaster() {
        return this.m_pm;
    }

    public void ok() {
        if (this.m_ordered == null) {
            return;
        }
        this.m_ordered.deleteAll();
        int count = this.m_list.getItemCount();
        int i = 0;
        while (i < count) {
            this.m_ordered.add(this.m_list.getItem(i));
            ++i;
        }
        this.m_ordered.setChgFlag(false);
        this.m_ordered.setPlansChgFlag(true);
    }

    public void cancel() {
        if (this.m_ordered == null) {
            return;
        }
        this.m_list.removeAll();
        this.fillList();
        this.m_ordered.setChgFlag(false);
    }

    public void gone() {
    }

    public void actionPerformed(ActionEvent event) {
        Object src = event.getSource();
        if (src == this.m_add) {
            String val = this.m_fl.getValue();
            if (val != null && !val.equals("")) {
                this.m_list.add(val);
                this.m_list.select(this.m_list.getItemCount() - 1);
                this.setState();
                this.m_ordered.setChgFlag(true);
            }
        } else if (src == this.m_insert) {
            String val;
            int index = this.m_list.getSelectedIndex();
            if (index > -1 && (val = this.m_fl.getValue()) != null && !val.equals("")) {
                this.m_list.add(val, index);
                this.m_list.select(index);
                this.m_ordered.setChgFlag(true);
            }
            this.setState();
        } else if (src == this.m_delete) {
            int index = this.m_list.getSelectedIndex();
            if (index > -1) {
                this.m_list.remove(index);
                this.m_ordered.setChgFlag(true);
                if (index > 0) {
                    this.m_list.select(index - 1);
                } else if (this.m_list.getItemCount() > 0) {
                    this.m_list.select(0);
                }
            }
            this.setState();
        }
    }

    public void itemStateChanged(ItemEvent event) {
        int state = event.getStateChange();
        if (state == 1 || state == 2) {
            this.setState();
        }
    }

    void fillList() {
        if (this.m_ordered == null) {
            return;
        }
        int count = this.m_ordered.length();
        int i = 0;
        while (i < count) {
            this.m_list.addItem((String)this.m_ordered.get(i));
            ++i;
        }
        this.m_list.addItemListener(this);
    }

    void setState() {
        int index = this.m_list.getSelectedIndex();
        if (index > -1) {
            this.m_insert.setEnabled(true);
            this.m_delete.setEnabled(true);
            this.m_fl.setValue(this.m_list.getItem(index));
        } else {
            this.m_insert.setEnabled(false);
            this.m_delete.setEnabled(false);
        }
    }
}

