/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.model;

import com.lucent.ra.nms.model.LEBindings;
import com.lucent.ra.nms.model.LEConfig;
import com.lucent.ra.nms.model.LEConnectionFacade;
import com.lucent.ra.nms.util.LEVector;

public class LEDHCP
extends LEConfig {
    public static final String BINDINGS = "bindings";
    public static final String DOMAIN = "159";
    public static final String ENCAPSULATION = "190";
    public static final String GATEWAY = "75";
    public static final String IPPOOL = "ippool";
    public static final String LEASE = "200";
    public static final String NAMESERVER_1 = "157";
    public static final String NAMESERVER_2 = "158";
    public static final String NETBIOS_SCOPE = "201";
    public static final String NETMASK = "15";
    public static final String RELAY = "204";
    public static final String STATUS = "17";
    public static final String WINSERVER_1 = "202";
    public static final String WINSERVER_2 = "203";
    public static final int KEY_COUNT = 14;
    static String[] s_keys = null;

    public static String[] GetAllPossibleKeys() {
        if (s_keys == null) {
            s_keys = new String[14];
            int n = 0;
            LEDHCP.s_keys[n++] = BINDINGS;
            LEDHCP.s_keys[n++] = DOMAIN;
            LEDHCP.s_keys[n++] = ENCAPSULATION;
            LEDHCP.s_keys[n++] = GATEWAY;
            LEDHCP.s_keys[n++] = IPPOOL;
            LEDHCP.s_keys[n++] = LEASE;
            LEDHCP.s_keys[n++] = NAMESERVER_1;
            LEDHCP.s_keys[n++] = NAMESERVER_2;
            LEDHCP.s_keys[n++] = NETBIOS_SCOPE;
            LEDHCP.s_keys[n++] = NETMASK;
            LEDHCP.s_keys[n++] = RELAY;
            LEDHCP.s_keys[n++] = STATUS;
            LEDHCP.s_keys[n++] = WINSERVER_1;
            LEDHCP.s_keys[n++] = WINSERVER_2;
        }
        return s_keys;
    }

    public LEDHCP(LEConnectionFacade lEConnectionFacade) {
        super(lEConnectionFacade);
    }

    public Object clone() {
        LEDHCP lEDHCP = new LEDHCP(this.m_facade);
        lEDHCP.copy(this);
        return lEDHCP;
    }

    LEConfig createConfig(String string) {
        if (string.equals(BINDINGS)) {
            return new LEBindings(this.m_facade);
        }
        return new LEConfig(this.m_facade);
    }

    boolean generateCommands(LEVector lEVector, LEVector lEVector2) {
        String string;
        boolean bl = lEVector == null;
        int n = lEVector2.size();
        if (bl || lEVector.contains(DOMAIN)) {
            this.makeSetCommand(lEVector2, null, DOMAIN, "dhcp domain");
        }
        if (bl || lEVector.contains(ENCAPSULATION)) {
            this.makeSetCommand(lEVector2, null, ENCAPSULATION, "dhcp encapsulation");
        }
        if (bl || lEVector.contains(GATEWAY)) {
            this.makeSetCommand(lEVector2, null, GATEWAY, "dhcp gateway");
        }
        if (bl || lEVector.contains(IPPOOL)) {
            this.makeSetCommand(lEVector2, null, IPPOOL, "dhcp pool");
        }
        if ((bl || lEVector.contains(LEASE)) && (string = (String)this.get(LEASE)) != null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("set ");
            stringBuffer.append("dhcp lease");
            stringBuffer.append(string);
            stringBuffer.append(" minutes");
            lEVector2.addElement(stringBuffer.toString());
        }
        if (bl || lEVector.contains(NAMESERVER_1)) {
            this.makeSetCommand(lEVector2, null, NAMESERVER_1, "dhcp nameserver 1");
        }
        if (bl || lEVector.contains(NAMESERVER_2)) {
            this.makeSetCommand(lEVector2, null, NAMESERVER_2, "dhcp nameserver 2");
        }
        if (bl || lEVector.contains(NETBIOS_SCOPE)) {
            this.makeSetCommand(lEVector2, null, NETBIOS_SCOPE, "dhcp netbios-scope");
        }
        if (bl || lEVector.contains(NETMASK)) {
            this.makeSetCommand(lEVector2, null, NETMASK, "dhcp netmask");
        }
        if (bl || lEVector.contains(WINSERVER_1)) {
            this.makeSetCommand(lEVector2, null, WINSERVER_1, "dhcp wins-server 1");
        }
        if (bl || lEVector.contains(WINSERVER_2)) {
            this.makeSetCommand(lEVector2, null, WINSERVER_2, "dhcp wins-server 2");
        }
        if (bl || lEVector.contains(STATUS)) {
            this.makeSetCommand(lEVector2, null, STATUS, "dhcp server");
        }
        if (bl || lEVector.contains(RELAY)) {
            this.makeSetCommand(lEVector2, null, RELAY, "dhcp relay");
        }
        return lEVector2.size() > n;
    }
}

